package com.biz.crm.tpm.business.warning.config.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 预警对象类型[数据字典:tpm_warning_receiving_object_type]
 *
 * @author duyiran
 * @create 2022-11-04 14:37
 */
public enum TpmWarningReceivingObjectTypeEnum {

    ORG("org","按组织"),
    POSITION("position","按职位"),
    PUSH_DIMENSION("push_dimension","推送维度");

    TpmWarningReceivingObjectTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private String code;

    private String desc;

    public static TpmWarningReceivingObjectTypeEnum findByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(TpmWarningReceivingObjectTypeEnum type : values()){
            if(StringUtils.equals(type.getCode(),code)){
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
