package com.biz.crm.tpm.business.warning.config.sdk.event;

import com.biz.crm.tpm.business.warning.config.sdk.dto.log.TpmWarningConfigLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 预警配置业务日志事件接口
 *
 * @author duyiran
 * @create 2022-11-04 16:51
 */
public interface TpmWarningConfigLogEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(TpmWarningConfigLogEventDto dto);

    /**
     * 删除事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(TpmWarningConfigLogEventDto dto);

    /**
     * 修改事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(TpmWarningConfigLogEventDto dto);

    /**
     * 启用事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(TpmWarningConfigLogEventDto dto);

    /**
     * 禁用事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(TpmWarningConfigLogEventDto dto);

}
