package com.biz.crm.tpm.business.warning.config.sdk.service;

import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 预警变量及汇总数据信息
 * @author wanghaojia
 * @date 2023/10/21 16:46
 */
@Slf4j
public abstract class AbstractTpmWarningMonitoringVariableAndPushGroupRegister extends AbstractTpmWarningMonitoringVariableRegister {

    public List<String> defaultDimensionKey(){
        return Lists.newArrayList();
    }


    public abstract String getDimensionCodeKey(TpmWarningDimensionEnum dimension);

    public abstract List<String> getDimensionKey(TpmWarningDimensionEnum dimension);

    /**
     * @param dto 预警配置
     * @param dataList 数据集合
     * @return 汇总数据
     */
    public List<Map<String, Object>> groupList(TpmWarningConfigDto dto, List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)){
            return com.google.common.collect.Lists.newArrayList();
        }
        List<String> dimensionKeyList = getDimensionKeyList(dto);
        if(CollectionUtils.isEmpty(dimensionKeyList)){
            return com.google.common.collect.Lists.newArrayList();
        }

        Map<String,Map<String, Object>> groupMap = Maps.newHashMap();
        for (Map<String, Object> objectMap : dataList) {
            StringBuilder groupKeyBuilder = new StringBuilder();

            Map<String, Object> thisGroupMap = Maps.newHashMap();
            List<String> defaultDimensionKeyList = defaultDimensionKey();
            if (!CollectionUtils.isEmpty(defaultDimensionKeyList)){
                //默认分组字段,非必填，例如年月等条件
                for (String dimensionKey : defaultDimensionKeyList) {
                    String dimensionValue = Optional.ofNullable(objectMap.get(dimensionKey)).orElse("").toString();
                    groupKeyBuilder.append(dimensionValue);//汇总键
                    thisGroupMap.put(dimensionKey,dimensionValue);
                }
            }
            for (String dimensionKey : dimensionKeyList) {
                String dimensionValue = Optional.ofNullable(objectMap.get(dimensionKey)).orElse("").toString();
                groupKeyBuilder.append(dimensionValue);//汇总键
                thisGroupMap.put(dimensionKey,dimensionValue);
            }
            String groupKey = groupKeyBuilder.toString();
            if (groupMap.containsKey(groupKey)){
                thisGroupMap = groupMap.get(groupKey);
                int warningCount = (int) thisGroupMap.get("warning_count");
                thisGroupMap.put("warning_count",warningCount + 1);
            }else{
                thisGroupMap.put("warning_count",1);
                groupMap.put(groupKey,thisGroupMap);
            }

            for (TpmWarningMonitoringVariable tpmWarningMonitoringVariable : variableList()) {
                if(!tpmWarningMonitoringVariable.getIsGroup()){
                    continue;
                }
                String variableField = tpmWarningMonitoringVariable.getVariableField();
                BigDecimal groupDecimal = (BigDecimal) thisGroupMap.getOrDefault(variableField,BigDecimal.ZERO);
                groupDecimal = groupDecimal.add(getBigDecimal(tpmWarningMonitoringVariable,objectMap.get(variableField)));
                thisGroupMap.put(variableField,groupDecimal);
            }
        }
        return com.google.common.collect.Lists.newArrayList(groupMap.values());
    }

    public List<String> getDimensionCodeKeyList(TpmWarningConfigDto dto){
        String pushDimension = dto.getPushDimension();
        String[] split = pushDimension.split(",");
        List<String> dimensionCodeKeyList = com.google.common.collect.Lists.newArrayList();
        for (String dimension : split) {
            TpmWarningDimensionEnum dimensionEnum = TpmWarningDimensionEnum.findByCode(dimension);
            if (null == dimensionEnum){
                continue;
            }
            //维度对应的编码键
            String dimensionCodeKey = this.getDimensionCodeKey(dimensionEnum);
            if (StringUtils.isNotEmpty(dimensionCodeKey)){
                dimensionCodeKeyList.add(dimensionCodeKey);
            }
        }
        return dimensionCodeKeyList;
    }

    public List<String> getDimensionKeyList(TpmWarningConfigDto dto){
        String pushDimension = dto.getPushDimension();
        String[] split = pushDimension.split(",");
        List<String> dimensionCodeKeyList = com.google.common.collect.Lists.newArrayList();
        for (String dimension : split) {
            TpmWarningDimensionEnum dimensionEnum = TpmWarningDimensionEnum.findByCode(dimension);
            if (null == dimensionEnum){
                continue;
            }
            //维度对应的编码键
            List<String> dimensionKeyList = this.getDimensionKey(dimensionEnum);
            if (!CollectionUtils.isEmpty(dimensionKeyList)){
                dimensionCodeKeyList.addAll(dimensionKeyList);
            }
        }
        return dimensionCodeKeyList;
    }


    protected BigDecimal getBigDecimal(TpmWarningMonitoringVariable tpmWarningMonitoringVariable,Object obj){
        if (null == obj){
            return BigDecimal.ZERO;
        }
        String objStr = obj.toString();
        if (StringUtils.isEmpty(objStr)){
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = new BigDecimal(objStr);
        if (null != tpmWarningMonitoringVariable.getGroupScale()){
            bigDecimal = bigDecimal.setScale(tpmWarningMonitoringVariable.getGroupScale(), RoundingMode.HALF_UP);
        }
        return bigDecimal;
    }

}
