package com.biz.crm.tpm.business.warning.config.sdk.service;

import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.biz.crm.mn.common.base.util.SqlUtil;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 预警变量注册器
 * @author wanghaojia
 * @date 2023/6/14 15:11
 */
public abstract class AbstractTpmWarningMonitoringVariableRegister {

    @Autowired(required = false)
    private TpmWarningMonitoringSdkService tpmWarningMonitoringSdkService;

    /**
     * 监控表名
     * @return
     */
    public abstract String monitoringTable();

    /**
     * 添加通用变量
     */
    public List<TpmWarningMonitoringVariable> allVariableList(){
        List<TpmWarningMonitoringVariable> variableList = variableList();
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("warningMsg");
        tpmWarningMonitoringVariable.setVariableFieldName("默认告警信息");
        tpmWarningMonitoringVariable.setIsWaring(true);
        tpmWarningMonitoringVariable.setIsCondition(false);
//        tpmWarningMonitoringVariable.setVariableQueryField("warningMsg");
        variableList.add(tpmWarningMonitoringVariable);
        return variableList;
    }

    /**
     * 变量map
     */
    protected abstract List<TpmWarningMonitoringVariable> variableList();

    /**
     * 查询sql
     * @return
     */
    public abstract List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList);

    public List<String> findWarningBusinessCodeList(){
        String monitoringTable = monitoringTable();
        return tpmWarningMonitoringSdkService.findWarningBusinessCodeList(monitoringTable);
    }

    public String appendWhereSql(List<TpmWarningConditionDto> conditionList){
        StringBuilder appendWhereSql = new StringBuilder(SQLBinaryOperator.BooleanAnd.name);
        appendWhereSql.append("(1=2 ");
        List<TpmWarningMonitoringVariable> variableList = variableList();
        for (TpmWarningConditionDto tpmWarningConditionDto : conditionList) {
            String formula = tpmWarningConditionDto.getFormula();
            formula = formula.replace(" ", "")
                    .replace("&&", " and ")
                    .replace("||", " or ")
                    .replace("==", "=");
            for (TpmWarningMonitoringVariable tpmWarningMonitoringVariable : variableList) {
                if (formula.contains(tpmWarningMonitoringVariable.getVariableField())){
                    formula = formula.replace(tpmWarningMonitoringVariable.getVariableField(),tpmWarningMonitoringVariable.getVariableQueryField());
                }
            }
            appendWhereSql.append("\n").append(SQLBinaryOperator.BooleanOr.name).append("(").append(formula).append(")");
        }
        appendWhereSql.append(")");
        return appendWhereSql.toString();
    }

    public String appendWaringBusinessCodeInList(){
        List<String> warningBusinessCodeList = findWarningBusinessCodeList();
        if (!CollectionUtils.isEmpty(warningBusinessCodeList)){
            String sqlIn500 = SqlUtil.setSqlIn500(warningBusinessCodeList, businessCodeField(), true);
            return "\n" + SQLBinaryOperator.BooleanOr.name + "(" + sqlIn500 + ")";
        }
        return null;
    }

    /**
     * 业务编码字段名
     */
    public abstract String businessCodeField();

    /**
     * 是否重新计算
     */
    public boolean doMathCompute(){
        return false;
    }

}
