package com.biz.crm.tpm.business.warning.config.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigDisplayVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TPM-预警配置(TpmWarningConfig)表服务接口
 *
 * @author duyiran
 * @since 2022-11-03 15:44:39
 */
public interface TpmWarningConfigService {

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param tpmWarningConfig 实体对象
     * @return
     */
    Page<TpmWarningConfigVo> findByConditions(Pageable pageable, TpmWarningConfigDto tpmWarningConfig);

    /**
     * 执行预警
     */
    public void executeWarning();

    /**
     * 通过主键查询单条数据(前端用)
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmWarningConfigDisplayVo findById(String id);

    /**
     * 新增数据
     *
     * @param tpmWarningConfig 实体对象
     * @return 新增结果
     */
    TpmWarningConfigVo create(TpmWarningConfigDto tpmWarningConfig);

    /**
     * 修改新据
     *
     * @param tpmWarningConfig 实体对象
     * @return 修改结果
     */
    TpmWarningConfigVo update(TpmWarningConfigDto tpmWarningConfig);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    List<TpmWarningConfigVo> delete(List<String> idList);

}

