package com.biz.crm.tpm.business.warning.config.sdk.service;

import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningMonitoringVo;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/6/14 16:27
 */
public interface TpmWarningMonitoringSdkService {

    /**
     * 查询当前预警的业务编码集合
     * @param monitoringTable 监控表
     */
    List<String> findWarningBusinessCodeList(String monitoringTable);

    /**
     * 查询监控表数据
     * @param monitoringTable 监控表
     * @param businessCodeList 业务编码集合
     */
    List<TpmWarningMonitoringVo> findTpmWarningMonitoringList(String monitoringTable,List<String> businessCodeList);

    /**
     * 查询禁用推送的数据
     */
    List<String> findExcludeBusinessCodeList(String monitoringTable);

}
