package com.biz.crm.tpm.business.warning.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 预警配置详情展示vo（前端用）
 *
 * @author duyiran
 * @create 2022-11-03 17:19
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class TpmWarningConfigDisplayVo extends TenantFlagOpVo {

    /**
     * 预警规则编码[数据字典:tpm_warning_config_status]
     */
    @ApiModelProperty(name = "预警状态[数据字典:tpm_warning_config_status]", notes = "预警规则编码[数据字典:tpm_warning_config_status]")
    private String status;

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    private String code;

    /**
     * 预警规则名称
     */
    @ApiModelProperty(name = "预警规则名称", notes = "预警规则名称")
    private String name;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 推送维度[数据字典:tpm_warning_dimension]
     */
    @ApiModelProperty(name = "推送维度[数据字典:tpm_warning_dimension]", notes = "推送维度[数据字典:tpm_warning_dimension]")
    private String pushDimension;

    private List<String> pushDimensionStrList;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    private String salesOrgName;

    /**
     * 活动形式Code
     */
    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    /**
     * 预警方式[数据字典:tpm_warning_mode]
     */
    @ApiModelProperty(name = "预警方式[数据字典:tpm_warning_mode]", notes = "预警方式[数据字典:tpm_warning_mode]")
    private String warningMode;

    /**
     * 预警开始日期
     */
    @ApiModelProperty(name = "预警开始日期", notes = "预警开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 预警结束日期
     */
    @ApiModelProperty(name = "预警结束日期", notes = "预警结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    /**
     * 预警频率
     */
    @ApiModelProperty(name = "预警频率", notes = "预警频率")
    private String warningFrequency;

    /**
     * 监控表
     */
    private String monitoringTable;

    /**
     * 推送内容
     */
    private String pushContent;

    /**
     * 推送内容公式
     */
    private String pushContentFormula;

    /**
     * 是否重复推送
     */
    private String repeatPush;


    @ApiModelProperty("预警条件列表")
    List<TpmWarningConditionVo> conditionList;

    @ApiModelProperty("推送维度列表（前端用）")
    List<TpmWarningReceivingObjectVo> pushDimensionList;

    @ApiModelProperty("预警对象-组织包含（前端用）")
    List<TpmWarningReceivingObjectVo> orgs;

    @ApiModelProperty("预警对象-组织非包含（前端用）")
    List<TpmWarningReceivingObjectVo> nonOrgs;

    @ApiModelProperty("预警对象-职位包含（前端用）")
    List<TpmWarningReceivingObjectVo> positions;

    @ApiModelProperty("预警对象-职位非包含（前端用）")
    List<TpmWarningReceivingObjectVo> nonPositions;

}
