package com.biz.crm.tpm.business.warning.config.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author duyiran
 * @create 2022-11-05 17:49
 */
@Data
@CrmExcelExport
@EqualsAndHashCode(callSuper = true)
public class TpmWarningConfigExportsVo extends CrmExcelVo {

    /**
     * 数据业务状态（启用状态）
     */
    @CrmExcelColumn(value = "启用状态")
    private String enableStatus;

    /**
     * 预警规则编码[数据字典:tpm_warning_config_status]
     */
    @CrmExcelColumn(value = "预警状态")
    private String status;

    @CrmExcelColumn(value = "预警规则编码")
    private String code;

    /**
     * 预警规则名称
     */
    @CrmExcelColumn(value = "预警规则名称")
    private String name;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元")
    private String businessUnitCode;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称")
    private String salesOrgName;

    /**
     * 活动形式Code
     */
    @CrmExcelColumn(value = "活动形式编码")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @CrmExcelColumn(value = "活动形式名称")
    private String activityFormName;

    /**
     * 预警方式[数据字典:tpm_warning_mode]
     */
    @CrmExcelColumn(value = "预警方式")
    private String warningMode;

    /**
     * 预警开始日期
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn(value = "预警开始日期")
    private Date startDate;

    /**
     * 预警结束日期
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn(value = "预警结束日期")
    private Date endDate;
}
