/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.sdk.service;

import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractTpmWarningMonitoringVariableAndPushGroupRegister
extends AbstractTpmWarningMonitoringVariableRegister {
    private static final Logger log = LoggerFactory.getLogger(AbstractTpmWarningMonitoringVariableAndPushGroupRegister.class);

    public List<String> defaultDimensionKey() {
        return Lists.newArrayList();
    }

    public abstract String getDimensionCodeKey(TpmWarningDimensionEnum var1);

    public abstract List<String> getDimensionKey(TpmWarningDimensionEnum var1);

    public List<Map<String, Object>> groupList(TpmWarningConfigDto dto, List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        List<String> dimensionKeyList = this.getDimensionKeyList(dto);
        if (CollectionUtils.isEmpty(dimensionKeyList)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        HashMap groupMap = Maps.newHashMap();
        for (Map<String, Object> objectMap : dataList) {
            String dimensionValue;
            StringBuilder groupKeyBuilder = new StringBuilder();
            Map<String, String> thisGroupMap = Maps.newHashMap();
            List<String> defaultDimensionKeyList = this.defaultDimensionKey();
            if (!CollectionUtils.isEmpty(defaultDimensionKeyList)) {
                for (String dimensionKey : defaultDimensionKeyList) {
                    dimensionValue = Optional.ofNullable(objectMap.get(dimensionKey)).orElse("").toString();
                    groupKeyBuilder.append(dimensionValue);
                    thisGroupMap.put(dimensionKey, dimensionValue);
                }
            }
            for (String dimensionKey : dimensionKeyList) {
                dimensionValue = Optional.ofNullable(objectMap.get(dimensionKey)).orElse("").toString();
                groupKeyBuilder.append(dimensionValue);
                thisGroupMap.put(dimensionKey, dimensionValue);
            }
            String groupKey = groupKeyBuilder.toString();
            if (groupMap.containsKey(groupKey)) {
                thisGroupMap = (Map)groupMap.get(groupKey);
                int warningCount = (Integer)thisGroupMap.get("warning_count");
                thisGroupMap.put("warning_count", (String)((Object)Integer.valueOf(warningCount + 1)));
            } else {
                thisGroupMap.put("warning_count", (String)((Object)Integer.valueOf(1)));
                groupMap.put(groupKey, thisGroupMap);
            }
            for (TpmWarningMonitoringVariable tpmWarningMonitoringVariable : this.variableList()) {
                if (!tpmWarningMonitoringVariable.getIsGroup().booleanValue()) continue;
                String variableField = tpmWarningMonitoringVariable.getVariableField();
                BigDecimal groupDecimal = thisGroupMap.getOrDefault(variableField, (String)((Object)BigDecimal.ZERO));
                groupDecimal = groupDecimal.add(this.getBigDecimal(tpmWarningMonitoringVariable, objectMap.get(variableField)));
                thisGroupMap.put(variableField, (String)((Object)groupDecimal));
            }
        }
        return com.google.common.collect.Lists.newArrayList(groupMap.values());
    }

    public List<String> getDimensionCodeKeyList(TpmWarningConfigDto dto) {
        String pushDimension = dto.getPushDimension();
        String[] split = pushDimension.split(",");
        ArrayList dimensionCodeKeyList = com.google.common.collect.Lists.newArrayList();
        for (String dimension : split) {
            String dimensionCodeKey;
            TpmWarningDimensionEnum dimensionEnum = TpmWarningDimensionEnum.findByCode(dimension);
            if (null == dimensionEnum || !StringUtils.isNotEmpty((CharSequence)(dimensionCodeKey = this.getDimensionCodeKey(dimensionEnum)))) continue;
            dimensionCodeKeyList.add(dimensionCodeKey);
        }
        return dimensionCodeKeyList;
    }

    public List<String> getDimensionKeyList(TpmWarningConfigDto dto) {
        String pushDimension = dto.getPushDimension();
        String[] split = pushDimension.split(",");
        ArrayList dimensionCodeKeyList = com.google.common.collect.Lists.newArrayList();
        for (String dimension : split) {
            List<String> dimensionKeyList;
            TpmWarningDimensionEnum dimensionEnum = TpmWarningDimensionEnum.findByCode(dimension);
            if (null == dimensionEnum || CollectionUtils.isEmpty(dimensionKeyList = this.getDimensionKey(dimensionEnum))) continue;
            dimensionCodeKeyList.addAll(dimensionKeyList);
        }
        return dimensionCodeKeyList;
    }

    protected BigDecimal getBigDecimal(TpmWarningMonitoringVariable tpmWarningMonitoringVariable, Object obj) {
        if (null == obj) {
            return BigDecimal.ZERO;
        }
        String objStr = obj.toString();
        if (StringUtils.isEmpty((CharSequence)objStr)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = new BigDecimal(objStr);
        if (null != tpmWarningMonitoringVariable.getGroupScale()) {
            bigDecimal = bigDecimal.setScale((int)tpmWarningMonitoringVariable.getGroupScale(), RoundingMode.HALF_UP);
        }
        return bigDecimal;
    }
}

