package com.biz.crm.tpm.business.warning.result.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.warning.result.local.service.TpmWarningResultService;
import com.biz.crm.tpm.business.warning.result.sdk.dto.TpmWarningResultDto;
import com.biz.crm.tpm.business.warning.result.sdk.vo.TpmWarningResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * TPM-预警结果(TpmWarningResult)表相关的http接口
 *
 * @author duyiran
 * @since 2022-12-08 11:13:05
 */
@RestController
@RequestMapping("/v1/tpmWarningResult")
@Slf4j
@Api(tags = "TPM-预警结果")
public class TpmWarningResultController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmWarningResultService tpmWarningResultService;

    /**
     * 分页查询所有数据
     *
     * @param pageable         分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmWarningResultVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                           @ApiParam(name = "dto", value = "TPM-预警结果") TpmWarningResultDto dto) {
        try {
            Page<TpmWarningResultVo> page = this.tpmWarningResultService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<TpmWarningResultVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            TpmWarningResultVo vo = this.tpmWarningResultService.findById(id);
            return Result.ok(vo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
