package com.biz.crm.tpm.business.warning.result.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 预警结果 实体
 *
 * @author duyiran
 * @create 2022-11-07 17:42
 */
@Data
@TableName("tpm_warning_result")
@Entity(name = "tpm_warning_result")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmWarningResult", description = "TPM-预警结果")
@org.hibernate.annotations.Table(appliesTo = "tpm_warning_result", comment = "TPM-预警结果")
@Table(name = "tpm_warning_result", indexes = {@Index(name = "tpm_warning_result_index1", columnList = "tenant_code, code", unique = true)})
public class TpmWarningResult extends TenantFlagOpEntity {

    /**
     * 预警结果编码
     */
    @ApiModelProperty(name = "预警结果编码", notes = "预警结果编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警结果编码'")
    private String code;

    /**
     * 预警规则编码
     */
    @ApiModelProperty(name = "预警规则编码", notes = "预警规则编码")
    @Column(name = "warning_config_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警规则编码'")
    private String warningConfigCode;

    /**
     * 预警规则名称
     */
    @ApiModelProperty(name = "预警规则名称", notes = "预警规则名称")
    @Column(name = "warning_config_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '预警规则名称'")
    private String warningConfigName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format]'")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit]'")
    private String businessUnitCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售组织名称'")
    private String salesOrgName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 预警级别[数据字典:tpm_warning_level]
     */
    @ApiModelProperty(name = "预警级别[数据字典:tpm_warning_level]", notes = "预警级别[数据字典:tpm_warning_level]")
    @Column(name = "warning_level", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预警级别[数据字典:tpm_warning_level]'")
    private String warningLevel;

    /**
     * 预警确认状态[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "预警确认状态[数据字典:yesOrNo]", notes = "预警确认状态[数据字典:yesOrNo]")
    @Column(name = "confirm_status", nullable = true, length = 1, columnDefinition = "VARCHAR(32) COMMENT '预警确认状态[数据字典:yesOrNo]'")
    private String confirmStatus;

    /**
     * 预警开始日期
     */
    @ApiModelProperty(name = "预警开始日期", notes = "预警开始日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "start_date", nullable = true, length = 10, columnDefinition = "datetime COMMENT '预警开始日期'")
    private Date startDate;

    /**
     * 预警结束日期
     */
    @ApiModelProperty(name = "预警结束日期", notes = "预警结束日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", nullable = true, length = 10, columnDefinition = "datetime COMMENT '预警结束日期'")
    private Date endDate;

    /**
     * 预警通知日期
     */
    @ApiModelProperty(name = "预警通知日期", notes = "预警通知日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "notice_date", nullable = true, length = 10, columnDefinition = "datetime COMMENT '预警通知日期'")
    private Date noticeDate;

    /**
     * 职位编码
     */
    @ApiModelProperty(name = "职位编码", notes = "职位编码")
    @Column(name = "position_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码'")
    private String positionCode;

    /**
     * 职位名称
     */
    @ApiModelProperty(name = "职位名称", notes = "职位名称")
    @Column(name = "position_name", length = 255, columnDefinition = "varchar(255) COMMENT '职位名称'")
    private String positionName;

    /**
     * 用户登录名
     */
    @ApiModelProperty(name = "用户登录名", notes = "用户登录名")
    @Column(name = "user_name", length = 32, columnDefinition = "varchar(32) COMMENT '用户登录名'")
    private String userName;

    /**
     * 钉钉用户ID
     */
    @ApiModelProperty(name = "钉钉用户ID", notes = "钉钉用户ID")
    @Column(name = "ding_talk_user_id", length = 32, columnDefinition = "varchar(32) COMMENT '钉钉用户ID'")
    private String dingTalkUserId;

    /**
     * 钉钉员工姓名
     */
    @ApiModelProperty(name = "钉钉员工姓名", notes = "钉钉员工姓名")
    @Column(name = "ding_talk_name", length = 128, columnDefinition = "varchar(128) COMMENT '钉钉员工姓名'")
    private String dingTalkName;

    /**
     * 钉钉职位
     */
    @ApiModelProperty(name = "钉钉职位", notes = "钉钉职位")
    @Column(name = "ding_talk_title", length = 128, columnDefinition = "varchar(128) COMMENT '钉钉职位'")
    private String dingTalkTitle;

    /**
     * 钉钉手机号码
     */
    @ApiModelProperty(name = "钉钉手机号码", notes = "钉钉手机号码")
    @Column(name = "ding_talk_mobile", length = 11, columnDefinition = "varchar(11) COMMENT '钉钉手机号码'")
    private String dingTalkMobile;

    /**
     * 预警内容
     */
    @ApiModelProperty(name = "预警内容", notes = "预警内容")
    @Column(name = "notice_content", length = 255, columnDefinition = "varchar(255) COMMENT '预警内容'")
    private String noticeContent;

}
