package com.biz.crm.tpm.business.warning.result.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.warning.result.local.entity.TpmWarningResult;
import com.biz.crm.tpm.business.warning.result.local.mapper.TpmWarningResultMapper;
import com.biz.crm.tpm.business.warning.result.sdk.dto.TpmWarningResultDto;
import com.biz.crm.tpm.business.warning.result.sdk.vo.TpmWarningResultVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;


/**
 * TPM-预警结果(TpmWarningResult)表数据库访问层
 *
 * @author duyiran
 * @since 2022-12-08 11:13:09
 */
@Component
public class TpmWarningResultRepository extends ServiceImpl<TpmWarningResultMapper, TpmWarningResult> {

    @Autowired(required = false)
    private TpmWarningResultMapper tpmWarningResultMapper;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      dto
     * @return 所有数据
     */
    public Page<TpmWarningResultVo> findByConditions(Pageable pageable, TpmWarningResultDto dto) {
        Page<TpmWarningResultVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmWarningResultMapper.findByConditions(page, dto);
    }
}

