package com.biz.crm.tpm.business.warning.result.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.warning.result.local.entity.TpmWarningResult;
import com.biz.crm.tpm.business.warning.result.sdk.dto.TpmWarningResultDto;
import com.biz.crm.tpm.business.warning.result.sdk.vo.TpmWarningResultVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TPM-预警结果(TpmWarningResult)表服务接口
 *
 * @author duyiran
 * @since 2022-12-08 11:13:06
 */
public interface TpmWarningResultService {

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      dto
     * @return
     */
    Page<TpmWarningResultVo> findByConditions(Pageable pageable, TpmWarningResultDto dto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmWarningResultVo findById(String id);

    /**
     * 新增数据
     *
     * @param resultDtoList dto对象List
     */
    void create(List<TpmWarningResultDto> resultDtoList);

}

