package com.biz.crm.tpm.business.warning.result.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.result.local.entity.TpmWarningResult;
import com.biz.crm.tpm.business.warning.result.local.repository.TpmWarningResultRepository;
import com.biz.crm.tpm.business.warning.result.local.service.TpmWarningResultService;
import com.biz.crm.tpm.business.warning.result.sdk.dto.TpmWarningResultDto;
import com.biz.crm.tpm.business.warning.result.sdk.vo.TpmWarningResultVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * TPM-预警结果(TpmWarningResult)表服务实现类
 *
 * @author duyiran
 * @since 2022-12-08 11:13:07
 */
@Service("tpmWarningResultService")
public class TpmWarningResultServiceImpl implements TpmWarningResultService {

    @Autowired(required = false)
    private TpmWarningResultRepository tpmWarningResultRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param dto 实体对象
     * @return
     */
    @Override
    public Page<TpmWarningResultVo> findByConditions(Pageable pageable, TpmWarningResultDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmWarningResultDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        return this.tpmWarningResultRepository.findByConditions(pageable, dto);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public TpmWarningResultVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        TpmWarningResult entity = this.tpmWarningResultRepository.getById(id);
        Validate.notNull(entity, "数据不存在，请刷新后重试！");
        Validate.isTrue(DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), "数据不存在，请刷新后重试！");
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue(tenantCode.equals(entity.getTenantCode()), "数据不存在，请刷新后重试！");
        return this.nebulaToolkitService.copyObjectByWhiteList(entity, TpmWarningResultVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 新增数据
     *
     * @param resultDtoList dto对象
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void create(List<TpmWarningResultDto> resultDtoList) {
        Collection<TpmWarningResult> entity = nebulaToolkitService.copyCollectionByWhiteList(resultDtoList, TpmWarningResultDto.class, TpmWarningResult.class, HashSet.class, ArrayList.class);
        this.tpmWarningResultRepository.saveOrUpdateBatch(entity);
    }

}

