/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.result.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.result.local.entity.TpmWarningResult;
import com.biz.crm.tpm.business.warning.result.local.repository.TpmWarningResultRepository;
import com.biz.crm.tpm.business.warning.result.local.service.TpmWarningResultService;
import com.biz.crm.tpm.business.warning.result.sdk.dto.TpmWarningResultDto;
import com.biz.crm.tpm.business.warning.result.sdk.vo.TpmWarningResultVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmWarningResultService")
public class TpmWarningResultServiceImpl
implements TpmWarningResultService {
    @Autowired(required=false)
    private TpmWarningResultRepository tpmWarningResultRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<TpmWarningResultVo> findByConditions(Pageable pageable, TpmWarningResultDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmWarningResultDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        return this.tpmWarningResultRepository.findByConditions(pageable, dto);
    }

    @Override
    public TpmWarningResultVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmWarningResult entity = (TpmWarningResult)((Object)this.tpmWarningResultRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return (TpmWarningResultVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmWarningResultVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(List<TpmWarningResultDto> resultDtoList) {
        Collection entity = this.nebulaToolkitService.copyCollectionByWhiteList(resultDtoList, TpmWarningResultDto.class, TpmWarningResult.class, HashSet.class, ArrayList.class, new String[0]);
        this.tpmWarningResultRepository.saveOrUpdateBatch(entity);
    }
}

