/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.consumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmLargeDateWithholdingMessageDto;
import com.biz.crm.tpm.business.withholding.detail.local.service.impl.TpmLargeDateWithholdingAsyncService;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_WITHHOLDING_DETAIL_TOPIC${rocketmq.environment}", selectorExpression="LARGE_DATE_WITHHOLDING_SAVE_OR_UPDATE_MQ_TAG", consumerGroup="LARGE_DATE_WITHHOLDING_SAVE_OR_UPDATE_MQ_TAG${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY)
public class TpmLargeDateWithholdingSaveOrUpdateConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(TpmLargeDateWithholdingSaveOrUpdateConsumer.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private TpmLargeDateWithholdingAsyncService tpmLargeDateWithholdingAsyncService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u5927\u65e5\u671f\u9884\u63d0 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        TpmLargeDateWithholdingMessageDto messageDto = (TpmLargeDateWithholdingMessageDto)JSONObject.parseObject((String)message.getMsgBody(), TpmLargeDateWithholdingMessageDto.class);
        try {
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
            Object formulaObj = this.redisService.get("tpm:withholding:largeDate:formula:" + messageDto.getFormulaCacheId());
            Validate.notNull((Object)formulaObj, (String)"\u5927\u65e5\u671f\u9884\u63d0===\u300b\u7f13\u5b58\u9884\u63d0\u516c\u5f0f\u4fe1\u606f\u8fc7\u671f\uff01", (Object[])new Object[0]);
            WithholdingFormulaMainVo formulaMainVo = (WithholdingFormulaMainVo)JSONObject.parseObject((String)formulaObj.toString(), WithholdingFormulaMainVo.class);
            Object terminalObj = this.redisService.get("tpm:withholding:largeDate:terminal:" + messageDto.getUuid());
            Validate.notNull((Object)formulaObj, (String)"\u5927\u65e5\u671f\u9884\u63d0===\u300b\u7f13\u5b58\u7ec8\u7aef\u4fe1\u606f\u8fc7\u671f\uff01", (Object[])new Object[0]);
            List terminalCodeList = JSONObject.parseArray((String)terminalObj.toString(), String.class);
            log.info("\u5927\u65e5\u671f\u9884\u63d0===>\u6d88\u8d39\u95e8\u5e97\u6570\u91cf[{}]", (Object)terminalCodeList.size());
            List terminalVoList = this.terminalVoService.findBaseByTerminalCodes(terminalCodeList);
            for (List terminalVos : Lists.partition((List)terminalVoList, (int)20)) {
                this.tpmLargeDateWithholdingAsyncService.saveOrUpdate(loginUser, loginDetails, formulaMainVo, messageDto, terminalVos);
            }
        }
        catch (Exception e) {
            log.error("\u5927\u65e5\u671f\u9884\u63d0\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

