/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailActivityDetailPlanMqDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailCostCenterUtil;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_WITHHOLDING_DETAIL_TOPIC${rocketmq.environment}", selectorExpression="WITHHOLDING_DETAIL_ACTIVITY_DETAIL_PLAN_TAG", consumerGroup="ORDER_WITHHOLDING_DETAIL_ACTIVITY_DETAIL_PLAN_TAG${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY)
public class TpmWithholdingDetailActivityDetailPlanConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailActivityDetailPlanConsumer.class);
    @Autowired(required=false)
    private TpmWithholdingDetailService tpmWithholdingDetailService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private TpmWithholdingDetailCostCenterUtil tpmWithholdingDetailCostCenterUtil;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleMessage(MqMessageVo message) {
        try {
            log.info("=====>    \u9884\u63d0\u660e\u7ec6-\u6d3b\u52a8\u7ec6\u6848\u5206\u7ec4\u6d88\u606f\u63a5\u6536\u6210\u529f    <=====");
            List sendMsgList = JSONArray.parseArray((String)message.getMsgBody(), TpmWithholdingDetailActivityDetailPlanMqDto.class);
            List<TpmWithholdingDetailDto> dtoList = this.mqDto2Dto(sendMsgList, message);
            String lock = "withholding:detail:activity:detail:plan";
            boolean lockFlag = false;
            try {
                lockFlag = this.redisLockService.tryLock(lock, TimeUnit.SECONDS, 10L);
                if (lockFlag) {
                    this.tpmWithholdingDetailService.insertList(dtoList);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (lockFlag) {
                    this.redisLockService.unlock(lock);
                }
            }
        }
        catch (Exception e) {
            log.error("\u9884\u63d0\u660e\u7ec6-\u6d3b\u52a8\u7ec6\u6848\u9884\u63d0\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f";
    }

    private List<TpmWithholdingDetailDto> mqDto2Dto(List<TpmWithholdingDetailActivityDetailPlanMqDto> dtoList, MqMessageVo message) {
        List customerVoList;
        String withholdingYearMonth = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        ArrayList<TpmWithholdingDetailDto> dtoResultList = new ArrayList<TpmWithholdingDetailDto>();
        JSONObject userJsonObject = JSON.parseObject((String)message.getAccountJson());
        String ruleCode = "YTMX";
        Date date = new Date();
        Set activityDetailPlanItemCodeSet = dtoList.stream().map(TpmWithholdingDetailActivityDetailPlanMqDto::getCode).collect(Collectors.toSet());
        List activityDetailPlanItemVoList = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes(activityDetailPlanItemCodeSet);
        List activityDetailPlanVoList = this.activityDetailPlanSdkService.findByCodes((Collection)activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).collect(Collectors.toSet()));
        Map activityDetailPlanVoMap = activityDetailPlanVoList.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity()));
        Set customerCodeSet = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Map customerVoMap = null;
        if (!CollectionUtils.isEmpty(customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        Set salesOrgCodeSet = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getActivityOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        Map<Object, Object> salesOrgVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet));
            salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        List activityTypeVoList = this.activityTypeService.findByCodes(activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getActivityTypeCode).distinct().collect(Collectors.toList()));
        Map activityTypeMap = null;
        if (!CollectionUtils.isEmpty((Collection)activityTypeVoList)) {
            activityTypeMap = activityTypeVoList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, Function.identity()));
        }
        List withholdingCodeList = this.generateCodeService.generateCode(ruleCode, activityDetailPlanItemVoList.size());
        int counter = 0;
        for (ActivityDetailPlanItemVo planVo : activityDetailPlanItemVoList) {
            ActivityTypeVo activityType;
            Optional<TpmWithholdingDetailActivityDetailPlanMqDto> dtoOptional = dtoList.stream().filter(o -> o.getCode().equals(planVo.getDetailPlanItemCode())).findFirst();
            if (!dtoOptional.isPresent()) continue;
            BigDecimal auditAmount = planVo.getAlreadyAuditAmount() == null ? BigDecimal.ZERO : planVo.getAlreadyAuditAmount();
            TpmWithholdingDetailActivityDetailPlanMqDto dto = dtoOptional.get();
            TpmWithholdingDetailDto withholdingDetailDto = new TpmWithholdingDetailDto();
            if (activityDetailPlanVoMap.get(planVo.getDetailPlanCode()) != null) {
                withholdingDetailDto.setActivityName(((ActivityDetailPlanVo)activityDetailPlanVoMap.get(planVo.getDetailPlanCode())).getDetailPlanName());
                withholdingDetailDto.setBusinessFormatCode(((ActivityDetailPlanVo)activityDetailPlanVoMap.get(planVo.getDetailPlanCode())).getBusinessFormatCode());
                withholdingDetailDto.setBusinessUnitCode(((ActivityDetailPlanVo)activityDetailPlanVoMap.get(planVo.getDetailPlanCode())).getBusinessUnitCode());
            }
            withholdingDetailDto.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
            withholdingDetailDto.setActivityDetailCode(planVo.getDetailPlanItemCode());
            withholdingDetailDto.setActivityFormCode(planVo.getActivityFormCode());
            withholdingDetailDto.setActivityFormName(planVo.getActivityFormName());
            withholdingDetailDto.setActivityTypeCode(planVo.getActivityTypeCode());
            withholdingDetailDto.setActivityTypeName(planVo.getActivityTypeName());
            withholdingDetailDto.setTerminalCode(planVo.getTerminalCode());
            withholdingDetailDto.setTerminalName(planVo.getTerminalName());
            withholdingDetailDto.setCustomerCode(planVo.getCustomerCode());
            if (StringUtils.isNotEmpty((CharSequence)planVo.getCustomerCode()) && customerVoMap != null && customerVoMap.get(planVo.getCustomerCode()) != null) {
                withholdingDetailDto.setCustomerName(((CustomerVo)customerVoMap.get(planVo.getCustomerCode())).getCustomerName());
                withholdingDetailDto.setCustomerErpCode(((CustomerVo)customerVoMap.get(planVo.getCustomerCode())).getErpCode());
            }
            if (planVo.getFeeYearMonth() != null) {
                withholdingDetailDto.setFeeYearMonth(DateUtil.format((Date)planVo.getFeeYearMonth(), (String)"yyyy-MM"));
            }
            withholdingDetailDto.setBeginDate(planVo.getActivityBeginDate());
            withholdingDetailDto.setEndDate(planVo.getActivityEndDate());
            withholdingDetailDto.setBudgetSubjectCode(planVo.getBudgetItemCode());
            withholdingDetailDto.setActivityApplyAmount(planVo.getFeeAmount());
            withholdingDetailDto.setAdjustAmount(BigDecimal.ZERO);
            withholdingDetailDto.setUsedAmount(auditAmount);
            withholdingDetailDto.setPredictAmount(dto.getAuditAmount());
            withholdingDetailDto.setWithholdingAmount(dto.getAuditAmount().subtract(auditAmount));
            withholdingDetailDto.setAfterAdjustAmount(withholdingDetailDto.getWithholdingAmount());
            withholdingDetailDto.setWithholdingYearMonth(StringUtils.isNotEmpty((CharSequence)dto.getYearMonth()) ? dto.getYearMonth() : withholdingYearMonth);
            withholdingDetailDto.setSalesOrgCode(planVo.getActivityOrgCode());
            if (StringUtils.isNotEmpty((CharSequence)planVo.getActivityOrgCode()) && salesOrgVoMap.get(planVo.getActivityOrgCode()) != null) {
                withholdingDetailDto.setSalesOrgName(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgName());
                withholdingDetailDto.setSalesOrgErpCode(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getErpCode());
                withholdingDetailDto.setSalesOrgLevel(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgLevel());
                withholdingDetailDto.setSalesInstitutionCode(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesInstitutionCode());
                if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgLevel())) {
                    withholdingDetailDto.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgCode());
                }
                if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgLevel())) {
                    withholdingDetailDto.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgCode());
                    withholdingDetailDto.setSalesGroupCode(((SalesOrgVo)salesOrgVoMap.get(planVo.getActivityOrgCode())).getSalesOrgCode());
                }
            }
            if (activityTypeMap != null && BusinessUnitEnum.VERTICAL.getCode().equals(withholdingDetailDto.getBusinessUnitCode()) && (activityType = (ActivityTypeVo)activityTypeMap.get(withholdingDetailDto.getActivityTypeCode())) != null && "personnel_cost".equals(activityType.getActivityTypeType())) {
                withholdingDetailDto.setQuantity(new BigDecimal(planVo.getQuantity()));
            }
            withholdingDetailDto.setProductCode(planVo.getProductCode());
            withholdingDetailDto.setProductName(planVo.getProductName());
            withholdingDetailDto.setResaleCommercialCode(planVo.getSystemCode());
            withholdingDetailDto.setResaleCommercialName(planVo.getSystemName());
            withholdingDetailDto.setSupplierCode(planVo.getSupplierCode());
            withholdingDetailDto.setSupplierName(planVo.getSupplierName());
            withholdingDetailDto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            withholdingDetailDto.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.ACTIVITY_WITHHOLDING.getCode());
            withholdingDetailDto.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
            withholdingDetailDto.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
            withholdingDetailDto.setPayType(planVo.getPaymentMethod());
            withholdingDetailDto.setAuditForm(planVo.getAuditForm());
            withholdingDetailDto.setRegion(planVo.getRegion());
            withholdingDetailDto.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            withholdingDetailDto.setCreateAccount(userJsonObject.getString("account"));
            withholdingDetailDto.setCreateName(userJsonObject.getString("realName"));
            withholdingDetailDto.setModifyAccount(userJsonObject.getString("account"));
            withholdingDetailDto.setModifyName(userJsonObject.getString("realName"));
            withholdingDetailDto.setCreateTime(date);
            withholdingDetailDto.setModifyTime(date);
            withholdingDetailDto.setTenantCode(TenantUtils.getTenantCode());
            withholdingDetailDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            withholdingDetailDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            withholdingDetailDto.setUniqueMd5Key(withholdingDetailDto.generateUniqueMd5Key());
            dtoResultList.add(withholdingDetailDto);
            ++counter;
        }
        Map<String, CostCenterRelationVo> costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(dtoResultList, null);
        dtoResultList.forEach(v -> {
            if (costCenterMap.containsKey(v.getActivityDetailCode())) {
                CostCenterRelationVo vo = (CostCenterRelationVo)costCenterMap.get(v.getActivityDetailCode());
                v.setCostCenter(vo.getCostCenterCode());
                v.setCostCenterName(vo.getCostCenterName());
            }
        });
        return dtoResultList;
    }
}

