/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailActivityDetailPlanDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailAdjustDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailProtocolDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailSubmitDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailActivityDetailPlanVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailSubmitSummaryRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.task.TpmWithholdingDetailTaskConfig;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailSplitCacheUntil;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.NotSupportedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/withholding/detail"})
@Api(tags={"TPM-\u9884\u63d0\u660e\u7ec6\u5217\u8868\u63a5\u53e3"})
public class TpmWithholdingDetailController
extends MnPageCacheController<TpmWithholdingDetailRespVo, TpmWithholdingDetailDto> {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailController.class);
    @Autowired(required=false)
    private TpmWithholdingDetailService tpmWithholdingDetailService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmWithholdingDetailTaskConfig tpmWithholdingDetailTaskConfig;

    @PostMapping(value={"findByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="")
    public Result<Page<TpmWithholdingDetailRespVo>> findByConditions(@RequestBody TpmWithholdingDetailDto reqVo, Pageable pageable) {
        try {
            if (StringUtils.isEmpty((CharSequence)reqVo.getEnableStatus())) {
                reqVo.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            }
            return Result.ok((Object)this.tpmWithholdingDetailService.queryByPage(reqVo, pageable));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"queryById"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e", notes="")
    public Result<TpmWithholdingDetailRespVo> queryById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.queryById(id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"redoWithholding"})
    @ApiOperation(value="\u624b\u52a8\u91cd\u65b0\u751f\u6210\u9884\u63d0\u660e\u7ec6", notes="")
    public Result<?> redoWithholding(@RequestBody TpmWithholdingDetailRedoWithholdingDto dto) {
        try {
            return Result.ok((String)this.tpmWithholdingDetailService.redoWithholding(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e", notes="")
    public Result<TpmWithholdingDetailRespVo> add(@RequestBody TpmWithholdingDetailDto reqVo) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.insert(reqVo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"edit"})
    @ApiOperation(value="\u7f16\u8f91\u6570\u636e", notes="")
    public Result<TpmWithholdingDetailRespVo> edit(@RequestBody TpmWithholdingDetailDto reqVo) {
        try {
            if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
                throw new NotSupportedException("\u7f3a\u5c11\u552f\u4e00\u952e");
            }
            return Result.ok((Object)this.tpmWithholdingDetailService.update(reqVo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping(value={"deleteById"})
    @ApiOperation(value="\u5220\u9664\u6570\u636e", notes="")
    public Result<Boolean> deleteById(String id) {
        return Result.ok((Object)this.tpmWithholdingDetailService.deleteById(id));
    }

    @DeleteMapping(value={"delete"})
    @ApiOperation(value="\u6839\u636eid\u5217\u8868\u5220\u9664\u6570\u636e", notes="")
    public Result<?> deleteByIds(@RequestParam(value="ids") List<String> ids) {
        try {
            this.tpmWithholdingDetailService.deleteByIds(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="", notes="")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.tpmWithholdingDetailService.enable(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="", notes="")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.tpmWithholdingDetailService.disable(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"submitApproval"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279", notes="")
    public Result<?> submitApproval(@RequestBody TpmWithholdingDetailSubmitDto submitDto) {
        ArrayList<String> lockList = new ArrayList<String>();
        try {
            Validate.notNull((Object)submitDto.getIds(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\uff01", (Object[])new Object[0]);
            for (String id : submitDto.getIds()) {
                String lockKey = "withholding:detail:submit" + id;
                boolean lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 1L);
                if (lockSuccess) {
                    lockList.add(lockKey);
                    continue;
                }
                throw new UnsupportedOperationException("\u6570\u636e\u52a0\u9501\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            }
            this.tpmWithholdingDetailService.submitApproval(submitDto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (!CollectionUtils.isEmpty(lockList)) {
                for (String lock : lockList) {
                    this.redisLockService.unlock(lock);
                }
            }
        }
    }

    @PostMapping(value={"submitAndSetPass"})
    @ApiOperation(value="\u786e\u8ba4\u5ba1\u6279\u901a\u8fc7(\u76f4\u63a5\u8bbe\u7f6e\u5ba1\u6279\u72b6\u6001\u4e3a\u5ba1\u6279\u901a\u8fc7)", notes="")
    public Result<?> submitAndSetPass(@RequestBody List<String> ids) {
        try {
            this.tpmWithholdingDetailService.submitAndSetPass(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"summaryForSubmit"})
    @ApiOperation(value="\u7edf\u8ba1\u63d0\u4ea4\u5ba1\u6279\u7684\u9884\u63d0\u660e\u7ec6\u6570\u636e\uff0c\u5e76\u8fd4\u56de", notes="")
    public Result<TpmWithholdingDetailSubmitSummaryRespVo> summaryForSubmit(@RequestBody List<String> ids) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.summaryForSubmit(ids));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"summaryForSubmitNew"})
    @ApiOperation(value="\u7edf\u8ba1\u63d0\u4ea4\u5ba1\u6279\u7684\u9884\u63d0\u660e\u7ec6\u6570\u636e\uff0c\u5e76\u8fd4\u56de", notes="")
    public Result<TpmWithholdingDetailSubmitSummaryRespVo> summaryForSubmitNew(@RequestBody TpmWithholdingDetailDto reqVo) {
        try {
            List idList = this.tpmWithholdingDetailService.findIdListByCondition(reqVo);
            if (CollectionUtils.isEmpty((Collection)idList)) {
                return Result.error((String)"\u65e0\u53ef\u63d0\u4ea4\u5ba1\u6279\u7684\u9884\u63d0\u6570\u636e");
            }
            return Result.ok((Object)this.tpmWithholdingDetailService.summaryForSubmit(idList));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"summaryForSubmitByProcessNo"})
    @ApiOperation(value="\u7edf\u8ba1\u63d0\u4ea4\u5ba1\u6279\u7684\u9884\u63d0\u660e\u7ec6\u6570\u636e\uff0c\u5e76\u8fd4\u56de", notes="")
    public Result<TpmWithholdingDetailSubmitSummaryRespVo> summaryForSubmitByProcessNo(@RequestParam(value="processNo") String processNo) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.summaryForSubmitByProcessNo(processNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"summaryForSubmitByProcessNoNew"})
    @ApiOperation(value="\u7edf\u8ba1\u63d0\u4ea4\u5ba1\u6279\u7684\u9884\u63d0\u660e\u7ec6\u6570\u636e\uff0c\u5e76\u8fd4\u56de", notes="")
    public Result<TpmWithholdingDetailSubmitSummaryRespVo> summaryForSubmitByProcessNoNew(@RequestParam(value="processNo") String processNo) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.summaryForSubmitByProcessNo(processNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findDetailPageForSubmit"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5ba1\u6279\u660e\u7ec6\u6570\u636e", notes="")
    public Result<Page<TpmWithholdingDetailRespVo>> findDetailPageForSubmit(@ApiParam(name="reqVo", value="\u8fc7\u6ee4\u53c2\u6570") TpmWithholdingDetailDto reqVo, Pageable pageable) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.findDetailPageForSubmit(pageable, reqVo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findTotalAmountForSubmit"})
    @ApiOperation(value="\u67e5\u8be2\u5ba1\u6279\u660e\u7ec6\u5408\u8ba1\u9884\u63d0\u91d1\u989d", notes="")
    public Result<TpmWithholdingDetailRespVo> findTotalAmountForSubmit(@ApiParam(name="reqVo", value="\u8fc7\u6ee4\u53c2\u6570") TpmWithholdingDetailDto reqVo) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.findTotalAmountForSubmit(reqVo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"addProtocol"})
    @ApiOperation(value="\u9884\u63d0\u660e\u7ec6\u6dfb\u52a0\u9644\u4ef6", notes="")
    public Result<?> addProtocol(@RequestBody TpmWithholdingDetailProtocolDto dto) {
        try {
            this.tpmWithholdingDetailService.addProtocol(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findProtocolById"})
    @ApiOperation(value="\u9884\u63d0\u660e\u7ec6\u67e5\u770b\u9644\u4ef6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u9884\u63d0\u660e\u7ec6id", name="id", required=true, paramType="String")})
    public Result<List<OrdinaryFileVo>> findProtocolById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.findProtocolById(id));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"createSplitData"})
    @ApiOperation(value="\u6279\u91cf\u8c03\u6574-\u5206\u644a", notes="")
    public Result<?> createSplitData(@RequestBody TpmWithholdingDetailAdjustDto dto) {
        String lockKey = TpmWithholdingDetailSplitCacheUntil.getOpLockKey(dto.getCacheKey());
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock(lockKey, TpmWithholdingDetailSplitCacheUntil.getTimeUnit(), (long)TpmWithholdingDetailSplitCacheUntil.getWaitTime());
            Validate.isTrue((boolean)lock, (String)"\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (Object[])new Object[0]);
            this.tpmWithholdingDetailService.createSplitData(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"saveSplitData"})
    @ApiOperation(value="\u6279\u91cf\u8c03\u6574-\u63d0\u4ea4", notes="")
    public Result<?> saveSplitData(@RequestBody TpmWithholdingDetailAdjustDto dto) {
        String lockKey = TpmWithholdingDetailSplitCacheUntil.getOpLockKey(dto.getCacheKey());
        boolean lock = false;
        try {
            lock = this.redisLockService.tryLock(lockKey, TpmWithholdingDetailSplitCacheUntil.getTimeUnit(), (long)TpmWithholdingDetailSplitCacheUntil.getWaitTime());
            Validate.isTrue((boolean)lock, (String)"\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (Object[])new Object[0]);
            this.tpmWithholdingDetailService.saveSplitData(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lock) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    @PostMapping(value={"activityPlanPage"})
    @ApiOperation(value="\u6279\u91cf\u8c03\u6574-\u5206\u9875\u9009\u62e9\u6d3b\u52a8\u7ec6\u6848", notes="")
    public Result<Page<TpmWithholdingDetailActivityDetailPlanVo>> activityPlanPage(@RequestBody TpmWithholdingDetailActivityDetailPlanDto dto, Pageable pageable) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.activityPlanPage(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findSplitDataByCostCenterCodeList"})
    @ApiOperation(value="\u9884\u63d0\u660e\u7ec6-\u83b7\u53d6\u6210\u672c\u4e2d\u5fc3\u9500\u552e\u6570\u636e", notes="")
    public Result<?> findSplitDataByCostCenterCodeList(@ApiParam(name="costCenterCodeList") @RequestParam(value="costCenterCode") List<String> costCenterCodeList, @RequestParam(value="feeYearMonth") String feeYearMonth) {
        try {
            return Result.ok((Object)this.tpmWithholdingDetailService.findSplitDataByCostCenterCodeList(costCenterCodeList, feeYearMonth));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"manualVerticalTask"})
    @ApiModelProperty(value="\u9884\u63d0\u660e\u7ec6-\u624b\u52a8\u89e6\u53d1\u5782\u76f4\u5b9a\u65f6\u4efb\u52a1", notes="")
    public Result<?> manualVerticalTask() {
        try {
            this.tpmWithholdingDetailTaskConfig.verticalTask();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

