/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.withholding.detail.local.mapper.TpmWithholdingDetailEntityMapper;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TpmWithholdingDetailProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailProcessCallBackListener.class);
    @Autowired(required=false)
    TpmWithholdingDetailEntityMapper tpmWithholdingDetailEntityMapper;

    public String getBusinessCode() {
        return "withholding_detail_process";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        List entityList = this.tpmWithholdingDetailEntityMapper.selectBatchIds(dto.getBusinessNoList());
        log.error("\u9884\u63d0\u660e\u7ec6-\u672c\u6b21\u5ba1\u6279\u4f20\u5165\u4e1a\u52a1\u7f16\u7801\uff1a" + dto.getBusinessNo());
        log.error("\u9884\u63d0\u660e\u7ec6-\u672c\u6b21\u5ba1\u6279\u4f20\u5165\u4e1a\u52a1\u7f16\u7801\u5217\u8868\uff1a" + JSON.toJSONString((Object)dto.getBusinessNoList()));
        log.error("\u9884\u63d0\u660e\u7ec6-\u672c\u6b21\u5ba1\u6279\u6d89\u53ca\u6570\u636e\uff1a" + JSON.toJSONString((Object)entityList));
        List invalidList = entityList.stream().filter(o -> DelFlagStatusEnum.DELETE.getCode().equals(o.getDelFlag())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invalidList)) {
            throw new UnsupportedOperationException("\u5b58\u5728\u5df2\u5220\u9664\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        String processStatus = dto.getProcessStatus();
        this.tpmWithholdingDetailEntityMapper.updateProcessStatusByIdList(processStatus, dto.getBusinessNoList());
    }
}

