/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableInventoryCheckService;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.withholding.detail.local.entity.TpmWithholdingDetailEntity;
import com.biz.crm.tpm.business.withholding.detail.local.mapper.TpmWithholdingDetailEntityMapper;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmLargeDateWithholdingMessageDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaInfoVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaRProductVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TpmLargeDateWithholdingAsyncService {
    private static final Logger log = LoggerFactory.getLogger(TpmLargeDateWithholdingAsyncService.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmWithholdingDetailEntityMapper tpmWithholdingDetailEntityMapper;
    @Autowired(required=false)
    private VariableInventoryCheckService variableInventoryCheckService;

    @Transactional
    @Async(value="asyncThread")
    public void saveOrUpdate(UserIdentity userIdentity, AbstractCrmUserIdentity loginDetails, WithholdingFormulaMainVo formulaMainVo, TpmLargeDateWithholdingMessageDto messageDto, List<TerminalVo> terminList) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        List productCodeList = formulaMainVo.getProductVoList().stream().map(WithholdingFormulaRProductVo::getProductCode).distinct().collect(Collectors.toList());
        List mdmProductList = this.productVoService.findByCodes(productCodeList);
        Map mdmProductMap = mdmProductList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        CustomerVo customerVo = messageDto.getCustomerVo();
        Date date = messageDto.getDate();
        SalesOrgAllParentVo salesOrgAllParentVo = messageDto.getSalesOrgAllParentVo();
        SalesOrgVo salesOrgVo = salesOrgAllParentVo.getCurrSalesOrgVo();
        ArrayList<TpmWithholdingDetailEntity> result = new ArrayList<TpmWithholdingDetailEntity>();
        for (TerminalVo terminalVo : terminList) {
            for (String productCode : productCodeList) {
                CalculateDto calculateDto = new CalculateDto();
                calculateDto.setActivityFormCode(formulaMainVo.getEffectiveActivityFormCode());
                calculateDto.setCode(formulaMainVo.getWithholdingFormulaCode());
                calculateDto.setName(formulaMainVo.getWithholdingFormulaName());
                calculateDto.setBusinessUnitCode(formulaMainVo.getBusinessUnitCode());
                calculateDto.setBusinessFormatCode(formulaMainVo.getBusinessFormatCode());
                calculateDto.setCustomerCode(formulaMainVo.getCustomerCode());
                calculateDto.setDistributionChannel(terminalVo.getCustomerChannelCode());
                calculateDto.setTerminalCode(terminalVo.getTerminalCode());
                calculateDto.setStoresCode(terminalVo.getTerminalCode());
                if (StringUtils.isNotEmpty((CharSequence)terminalVo.getSalesInstitutionCode())) {
                    String salesInstitutionCode = terminalVo.getSalesInstitutionCode();
                    String replace = salesInstitutionCode.substring(4, 8) + salesInstitutionCode.substring(0, 4);
                    calculateDto.setStoresCode(terminalVo.getTerminalCode().replace(replace, ""));
                }
                if (Objects.nonNull(customerVo)) {
                    calculateDto.setCustomerErpCode(customerVo.getErpCode());
                }
                calculateDto.setDate(date);
                calculateDto.setFormulaInfoDtoList(new ArrayList());
                calculateDto.setProductCode(productCode);
                calculateDto.setSalesOrgCode(salesOrgAllParentVo.getCurrSalesOrgCode());
                calculateDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
                calculateDto.setSalesGroupCode(salesOrgAllParentVo.getSalesGroupCode());
                calculateDto.setSalesGroupErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
                calculateDto.setSalesOrganizationErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
                calculateDto.setSalesOrganizationCode(salesOrgAllParentVo.getSalesInstitutionCode());
                calculateDto.setSalesGroupCode(salesOrgAllParentVo.getCurrSalesOrgCode());
                for (WithholdingFormulaInfoVo infoVo : formulaMainVo.getWithholdingFormulaInfoVoList()) {
                    FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                    formulaInfoDto.setFormulaCode(infoVo.getWithholdingFormulaCode());
                    formulaInfoDto.setFormula(infoVo.getWithholdingFormula());
                    formulaInfoDto.setFormulaCondition(infoVo.getWithholdingFormulaCondition());
                    formulaInfoDto.setFormulaConditionName(infoVo.getWithholdingFormulaConditionName());
                    formulaInfoDto.setFormulaName(infoVo.getWithholdingFormulaName());
                    calculateDto.getFormulaInfoDtoList().add(formulaInfoDto);
                }
                List inventoryCheckVos = this.variableInventoryCheckService.findInventoryCheck(calculateDto);
                if (CollectionUtils.isEmpty((Collection)inventoryCheckVos)) {
                    log.error("\u5927\u65e5\u671f\u9884\u63d0\u8ba1\u7b97\u5931\u8d25=====\u300b\u95e8\u5e97[" + terminalVo.getTerminalCode() + "]\u4ea7\u54c1[" + productCode + "]===>\u65e0\u5e93\u5b58\u76d8\u70b9");
                    continue;
                }
                BigDecimal total = BigDecimal.ZERO;
                for (TpmInventoryCheckVo inventoryCheckVo : inventoryCheckVos) {
                    ArrayList<CalculateDto> calculateDtoList = new ArrayList<CalculateDto>();
                    calculateDto.setInventoryCheckVo(inventoryCheckVo);
                    calculateDtoList.add(calculateDto);
                    log.info("\u5927\u65e5\u671f\u9884\u63d0\u8ba1\u7b97\u53c2\u6570=====\u300b{}", JSONObject.toJSON(calculateDtoList));
                    List filterVos = null;
                    try {
                        List calculateVoList = this.variableService.orCalculateConditionAndExpression(calculateDtoList);
                        filterVos = calculateVoList.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
                    }
                    catch (Exception e) {
                        log.error("\u5927\u65e5\u671f\u9884\u63d0\u8ba1\u7b97\u5f02\u5e38=====\u300b\u95e8\u5e97[" + terminalVo.getTerminalCode() + "]\u4ea7\u54c1[" + productCode + "]===>" + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    if (CollectionUtils.isEmpty(filterVos)) {
                        log.info("\u5927\u65e5\u671f\u9884\u63d0\u8ba1\u7b97\u7ed3\u679c=====\u300b\u65e0\u6ee1\u8db3\u6761\u4ef6");
                        continue;
                    }
                    BigDecimal sum = filterVos.stream().map(CalculateVo::getFormulaValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    total = total.add(sum);
                }
                log.info("\u5927\u65e5\u671f\u9884\u63d0\u8ba1\u7b97\u7ed3\u679c=====\u300b{}", (Object)total);
                List withholdingCodeList = this.generateCodeService.generateCode("YTMX", 1);
                TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
                entity.setWithholdingDetailCode((String)withholdingCodeList.get(0));
                entity.setBusinessFormatCode(formulaMainVo.getBusinessFormatCode());
                entity.setBusinessUnitCode(formulaMainVo.getBusinessUnitCode());
                entity.setSalesOrgCode(salesOrgAllParentVo.getCurrSalesOrgCode());
                entity.setTerminalName(terminalVo.getTerminalName());
                entity.setTerminalCode(terminalVo.getTerminalCode());
                entity.setSalesOrgName(salesOrgVo.getSalesOrgName());
                entity.setSalesOrgErpCode(salesOrgVo.getErpCode());
                entity.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
                entity.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
                entity.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
                entity.setSalesGroupCode(salesOrgAllParentVo.getSalesGroupCode());
                entity.setCustomerCode(formulaMainVo.getCustomerCode());
                if (customerVo != null) {
                    entity.setCustomerName(customerVo.getCustomerName());
                    entity.setCustomerErpCode(customerVo.getErpCode());
                }
                entity.setProductCode(productCode);
                ProductVo productVo = (ProductVo)mdmProductMap.get(productCode);
                if (productVo != null) {
                    entity.setProductName(productVo.getProductName());
                }
                entity.setWithholdingAmount(total);
                entity.setAdjustAmount(BigDecimal.ZERO);
                entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                entity.setWithholdingYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
                entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode());
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setCreateAccount(loginDetails.getAccount());
                entity.setCreateName(loginDetails.getRealName());
                entity.setModifyAccount(loginDetails.getAccount());
                entity.setModifyName(loginDetails.getRealName());
                entity.setCreateTime(date);
                entity.setModifyTime(date);
                entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
                result.add(entity);
            }
        }
        log.info("\u5927\u65e5\u671f\u65b0\u589e\u66f4\u65b0\u6570\u636e[{}]\u6761", (Object)result.size());
        if (CollectionUtils.isNotEmpty(result)) {
            this.tpmWithholdingDetailEntityMapper.insertList(result);
        }
    }
}

