/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailActivityDetailPlanMqDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailActivityDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailGenerateMqVoUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TpmWithholdingDetailActivityDetailPartServiceImpl
implements TpmWithholdingDetailActivityDetailPartService {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailActivityDetailPartServiceImpl.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    public void redoWithholding(TpmWithholdingDetailRedoWithholdingDto dto) {
        int page = 1;
        int pageSize = 500;
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        ActivityDetailPlanItemDto itemDto = new ActivityDetailPlanItemDto();
        itemDto.setSalesOrgCode(dto.getSalesOrgCode());
        itemDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        itemDto.setCustomerCode(dto.getCustomerCode());
        itemDto.setSystemCode(dto.getResaleCommercialCode());
        itemDto.setDetailPlanCode(dto.getDetailPlanCode());
        itemDto.setBeginDateEnd(dto.getEndDate());
        Page result = this.activityDetailPlanItemSdkService.findForWithholding((Pageable)pageable, TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode(), itemDto);
        if (CollectionUtils.isEmpty((Collection)result.getRecords())) {
            throw new UnsupportedOperationException("\u4e0d\u5b58\u5728\u53ef\u9884\u63d0\u6d3b\u52a8\u660e\u7ec6\u6570\u636e");
        }
        List<TpmWithholdingDetailActivityDetailPlanMqDto> sendMsgList = new ArrayList();
        while (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            try {
                List detailItemCodeList = result.getRecords().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList());
                List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(new HashSet(detailItemCodeList));
                for (ActivityDetailPlanItemVo activityDetailPlanItem : result.getRecords()) {
                    if (CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
                        TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                        mqDto.setCode(activityDetailPlanItem.getDetailPlanItemCode());
                        mqDto.setEnterAccountAmount(activityDetailPlanItem.getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.getAlreadyUpAccountAmount());
                        mqDto.setYearMonth(dto.getWithholdingYearMonth());
                        mqDto.setAuditAmount(activityDetailPlanItem.getFeeAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.getFeeAmount());
                        sendMsgList.add(mqDto);
                        continue;
                    }
                    Optional<DetailedForecastVo> detailForecastOptional = detailedForecastVoList.stream().filter(o -> o.getActivityDetailItemCode().equals(activityDetailPlanItem.getDetailPlanItemCode())).findFirst();
                    TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                    mqDto.setCode(activityDetailPlanItem.getDetailPlanItemCode());
                    mqDto.setEnterAccountAmount(activityDetailPlanItem.getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.getAlreadyUpAccountAmount());
                    mqDto.setYearMonth(dto.getWithholdingYearMonth());
                    if (detailForecastOptional.isPresent()) {
                        mqDto.setAuditAmount(detailForecastOptional.get().getEstimatedWriteOffAmount() == null ? BigDecimal.ZERO : detailForecastOptional.get().getEstimatedWriteOffAmount());
                    } else {
                        mqDto.setAuditAmount(activityDetailPlanItem.getFeeAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.getFeeAmount());
                    }
                    sendMsgList.add(mqDto);
                }
                if (sendMsgList.size() >= 500) {
                    try {
                        MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
                        mqMessage.setMsgBody(JSON.toJSONString(sendMsgList.subList(0, 500)));
                        mqMessage.setTag("WITHHOLDING_DETAIL_ACTIVITY_DETAIL_PLAN_TAG");
                        this.rocketMqProducer.sendMqMsg(mqMessage);
                        sendMsgList = sendMsgList.subList(500, sendMsgList.size());
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        log.error("\u9884\u63d0\u660e\u7ec6-\u6d3b\u52a8\u9884\u63d0\u63a8\u9001\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)e.getStackTrace()));
                    }
                }
                if (result.getRecords().size() == pageSize) {
                    pageable = PageRequest.of((int)(++page), (int)pageSize);
                    result = this.activityDetailPlanItemSdkService.findForWithholding((Pageable)pageable, TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode(), itemDto);
                    continue;
                }
                result = new Page();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        }
        if (sendMsgList.size() != 0) {
            MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
            mqMessage.setMsgBody(JSON.toJSONString(sendMsgList));
            mqMessage.setTag("WITHHOLDING_DETAIL_ACTIVITY_DETAIL_PLAN_TAG");
            this.rocketMqProducer.sendMqMsg(mqMessage);
        }
    }

    public void systemWithholding() {
        int page = 1;
        int pageSize = 500;
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        ActivityDetailPlanItemDto itemDto = new ActivityDetailPlanItemDto();
        itemDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        itemDto.setBeginDateEnd(DateUtil.format((Date)new Date(), (String)"yyyy-MM") + "-01");
        Page result = this.activityDetailPlanItemSdkService.findForWithholding((Pageable)pageable, TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode(), itemDto);
        List<TpmWithholdingDetailActivityDetailPlanMqDto> sendMsgList = new ArrayList();
        while (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            List detailItemCodeList = result.getRecords().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList());
            List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(new HashSet(detailItemCodeList));
            for (DetailedForecastVo detailForecastVo : detailedForecastVoList) {
                Optional<ActivityDetailPlanItemVo> activityDetailPlanItem = result.getRecords().stream().filter(o -> o.getDetailPlanItemCode().equals(detailForecastVo.getActivityDetailItemCode())).findFirst();
                if (!activityDetailPlanItem.isPresent()) continue;
                TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                mqDto.setCode(activityDetailPlanItem.get().getDetailPlanItemCode());
                mqDto.setEnterAccountAmount(activityDetailPlanItem.get().getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.get().getAlreadyUpAccountAmount());
                mqDto.setAuditAmount(detailForecastVo.getEstimatedWriteOffAmount() == null ? BigDecimal.ZERO : detailForecastVo.getEstimatedWriteOffAmount());
                sendMsgList.add(mqDto);
            }
            if (!CollectionUtils.isEmpty(sendMsgList) && sendMsgList.size() >= 500) {
                try {
                    MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
                    mqMessage.setMsgBody(JSON.toJSONString(sendMsgList.subList(0, 500)));
                    mqMessage.setTag("WITHHOLDING_DETAIL_ACTIVITY_DETAIL_PLAN_TAG");
                    this.rocketMqProducer.sendMqMsg(mqMessage);
                    sendMsgList = sendMsgList.subList(500, sendMsgList.size());
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    log.error("\u9884\u63d0\u660e\u7ec6-\u6d3b\u52a8\u9884\u63d0\u63a8\u9001\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)e.getStackTrace()));
                }
            }
            if (result.getRecords().size() == pageSize) {
                pageable = PageRequest.of((int)(++page), (int)pageSize);
                result = this.activityDetailPlanItemSdkService.findForWithholding((Pageable)pageable, TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode(), itemDto);
                continue;
            }
            result = new Page();
        }
        if (!CollectionUtils.isEmpty(sendMsgList)) {
            MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
            mqMessage.setMsgBody(JSON.toJSONString(sendMsgList));
            mqMessage.setTag("WITHHOLDING_DETAIL_ACTIVITY_DETAIL_PLAN_TAG");
            this.rocketMqProducer.sendMqMsg(mqMessage);
        }
    }
}

