/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.withholding.detail.local.entity.TpmWithholdingDetailEntity;
import com.biz.crm.tpm.business.withholding.detail.local.mapper.TpmWithholdingDetailEntityMapper;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailConstant;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmLargeDateWithholdingMessageDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailFormulaPartService;
import com.biz.crm.tpm.business.withholding.detail.local.service.impl.TpmLargeDateWithholdingAsyncService;
import com.biz.crm.tpm.business.withholding.formula.sdk.constant.WithholdingTypeEnum;
import com.biz.crm.tpm.business.withholding.formula.sdk.dto.WithholdingFormulaMainDto;
import com.biz.crm.tpm.business.withholding.formula.sdk.service.WithholdingFormulaMainService;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaInfoVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaMainVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaROrgVo;
import com.biz.crm.tpm.business.withholding.formula.sdk.vo.WithholdingFormulaRProductVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TpmWithholdingDetailFormulaPartServiceImpl
implements TpmWithholdingDetailFormulaPartService {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailFormulaPartServiceImpl.class);
    @Autowired(required=false)
    private TpmWithholdingDetailEntityMapper tpmWithholdingDetailEntityMapper;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private WithholdingFormulaMainService withholdingFormulaMainService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private TpmLargeDateWithholdingAsyncService tpmLargeDateWithholdingAsyncService;

    @Transactional(rollbackFor={Exception.class})
    public void redoWithholding(TpmWithholdingDetailRedoWithholdingDto dto) {
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        WithholdingFormulaMainVo mainVo = this.withholdingFormulaMainService.findByCode(dto.getWithholdingRuleCode());
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, mainVo.getCustomerCode());
        List salesOrgAllParentVos = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(mainVo.getOrgVoList().stream().map(WithholdingFormulaROrgVo::getSalesOrgCode).collect(Collectors.toList()));
        Map salesOrgMap = null;
        if (CollectionUtils.isNotEmpty((Collection)salesOrgAllParentVos)) {
            salesOrgMap = salesOrgAllParentVos.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, Function.identity()));
        }
        ArrayList<TpmWithholdingDetailEntity> result = new ArrayList<TpmWithholdingDetailEntity>();
        if (TpmWithholdingDetailCategoryEnum.ONLINE_RETAILERS_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
            int pageNum = 0;
            int pageSize = 500;
            PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
            GeneralExpensesDto generalExpensesDto = new GeneralExpensesDto();
            generalExpensesDto.setActivityFormCode(mainVo.getEffectiveActivityFormCode());
            generalExpensesDto.setPlatformCode(mainVo.getPlatformCode());
            generalExpensesDto.setCustomerCode(mainVo.getCustomerCode());
            generalExpensesDto.setChannelCode(mainVo.getECommerceChannelCode());
            generalExpensesDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            generalExpensesDto.setPromotionPlanCode(dto.getDetailPlanCode());
            generalExpensesDto.setBeginDateEnd(DateUtil.format((Date)new Date(), (String)"yyyy-MM") + "-01");
            generalExpensesDto.setSalesOrgCodeList(mainVo.getOrgVoList().stream().map(WithholdingFormulaROrgVo::getSalesOrgCode).collect(Collectors.toList()));
            Page page = this.generalExpensesService.findByConditions((Pageable)pageable, generalExpensesDto);
            if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
                throw new UnsupportedOperationException("\u9884\u63d0\u89c4\u5219\u3010" + mainVo.getWithholdingFormulaName() + "\u3011\u65e0\u53ef\u9884\u63d0\u6570\u636e");
            }
            while (!CollectionUtils.isEmpty((Collection)page.getRecords())) {
                List customerVoList;
                Set customerCodeSet = page.getRecords().stream().map(ExpensesVo::getCustomerCode).collect(Collectors.toSet());
                Map customerVoMap = null;
                if (CollectionUtils.isNotEmpty(customerCodeSet) && CollectionUtils.isNotEmpty((Collection)(customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodeSet))))) {
                    customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                }
                if (customerVoMap == null) {
                    throw new UnsupportedOperationException("\u5ba2\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
                }
                List auditList = this.auditService.findAuditCustomerDetailCollectionByDetailPlanItemCodeList(page.getRecords().stream().map(ExpensesVo::getExpensesCode).collect(Collectors.toList()));
                Map<String, List<AuditCustomerDetailCollectionVo>> auditMap = auditList.stream().collect(Collectors.groupingBy(AuditCustomerDetailCollectionVo::getActivityDetailCode));
                int counter = 0;
                List promotionPlanList = this.promotionPlanService.findByCodeList(page.getRecords().stream().map(ExpensesVo::getPromotionPlanCode).collect(Collectors.toList()));
                Map promotionPlanMap = promotionPlanList.stream().collect(Collectors.toMap(PromotionPlanVo::getPromotionPlanCode, Function.identity()));
                String ruleCode = "YTMX";
                List withholdingCodeList = this.generateCodeService.generateCode(ruleCode, page.getRecords().size());
                for (GeneralExpensesVo vo : page.getRecords()) {
                    PromotionPlanVo promotionPlanVo = (PromotionPlanVo)promotionPlanMap.get(vo.getPromotionPlanCode());
                    if (promotionPlanVo == null) continue;
                    SalesOrgAllParentVo salesOrgAllParentVo = null;
                    SalesOrgVo salesOrgVo = null;
                    if (salesOrgMap != null && salesOrgMap.containsKey(promotionPlanVo.getSalesOrgCode())) {
                        salesOrgAllParentVo = (SalesOrgAllParentVo)salesOrgMap.get(promotionPlanVo.getSalesOrgCode());
                        salesOrgVo = salesOrgAllParentVo.getCurrSalesOrgVo();
                    }
                    CustomerVo expenseCustomerVo = (CustomerVo)customerVoMap.get(vo.getCustomerCode());
                    CalculateDto calculateDto = new CalculateDto();
                    calculateDto.setActivityFormCode(mainVo.getEffectiveActivityFormCode());
                    calculateDto.setSalesOrgCode(mainVo.getSalesOrgCode());
                    if (Objects.nonNull(salesOrgVo)) {
                        calculateDto.setSalesOrgErpCode(salesOrgVo.getErpCode());
                        calculateDto.setSalesOrganizationCode(salesOrgAllParentVo.getSalesInstitutionCode());
                        calculateDto.setSalesOrganizationErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
                    }
                    calculateDto.setCode(mainVo.getWithholdingFormulaCode());
                    calculateDto.setName(mainVo.getWithholdingFormulaName());
                    calculateDto.setCustomerCode(vo.getCustomerCode());
                    if (Objects.nonNull(expenseCustomerVo)) {
                        calculateDto.setCustomerErpCode(expenseCustomerVo.getErpCode());
                    }
                    calculateDto.setFormulaInfoDtoList(new ArrayList());
                    calculateDto.setProductCode(vo.getProductCode());
                    calculateDto.setPromotionPlanCode(vo.getPromotionPlanCode());
                    calculateDto.setWithHoldDate(new Date());
                    calculateDto.setStartTimeOrDate(promotionPlanVo.getStartDate());
                    calculateDto.setEndTimeOrDate(promotionPlanVo.getEndDate());
                    calculateDto.setYearMonthLy(vo.getYearMonthLy());
                    if (Objects.nonNull(customerVo)) {
                        calculateDto.setChannel(customerVo.getCustomerChannelCode());
                    }
                    calculateDto.setBusinessFormatCode(promotionPlanVo.getBusinessFormatCode());
                    for (WithholdingFormulaInfoVo infoVo : mainVo.getWithholdingFormulaInfoVoList()) {
                        FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                        formulaInfoDto.setFormulaCode(infoVo.getWithholdingFormulaCode());
                        formulaInfoDto.setFormula(infoVo.getWithholdingFormula());
                        formulaInfoDto.setFormulaCondition(infoVo.getWithholdingFormulaCondition());
                        formulaInfoDto.setFormulaConditionName(infoVo.getWithholdingFormulaConditionName());
                        formulaInfoDto.setFormulaName(infoVo.getWithholdingFormulaName());
                        calculateDto.getFormulaInfoDtoList().add(formulaInfoDto);
                    }
                    ArrayList<CalculateDto> calculateList = new ArrayList<CalculateDto>();
                    calculateList.add(calculateDto);
                    log.info("\u7535\u5546\u9884\u63d0===\u300b\u516c\u5f0f\u8ba1\u7b97===\u300b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)calculateDto));
                    List calculateVoList = this.variableService.allCalculateConditionAndExpression(calculateList);
                    List filterVos = calculateVoList.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
                    Validate.isTrue((filterVos.size() < 2 ? 1 : 0) != 0, (String)"\u9884\u63d0\u89c4\u5219\u516c\u5f0f\u7f16\u7801 [%s] \u8ba1\u7b97\u7ed3\u679c\uff1a\u591a\u4e2a\u6838\u9500\u516c\u5f0f\u6761\u4ef6\u540c\u65f6\u6ee1\u8db3\uff01", (Object[])new Object[]{mainVo.getWithholdingFormulaCode()});
                    if (CollectionUtils.isEmpty(filterVos)) {
                        return;
                    }
                    BigDecimal auditAmount = BigDecimal.ZERO;
                    if (auditMap.get(vo.getExpensesCode()) != null) {
                        for (AuditCustomerDetailCollectionVo auditVo : auditMap.get(vo.getExpensesCode())) {
                            if (auditVo.getReimburseUpAccount() == null) {
                                auditVo.setReimburseUpAccount(BigDecimal.ZERO);
                            }
                            if (auditVo.getDiscountUpAccount() == null) {
                                auditVo.setDiscountUpAccount(BigDecimal.ZERO);
                            }
                            auditAmount = auditVo.getReimburseUpAccount().add(auditVo.getDiscountUpAccount());
                        }
                    }
                    TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
                    entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
                    entity.setBusinessUnitCode(BusinessUnitEnum.ONLINE.getCode());
                    entity.setActivityName(promotionPlanVo.getPromotionPlanName());
                    entity.setSalesOrgCode(promotionPlanVo.getSalesOrgCode());
                    if (salesOrgVo != null) {
                        entity.setSalesOrgName(salesOrgVo.getSalesOrgName());
                        entity.setSalesOrgErpCode(salesOrgVo.getErpCode());
                        entity.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
                        entity.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
                        if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
                            entity.setSalesRegionCode(salesOrgVo.getSalesOrgCode());
                        }
                        if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
                            entity.setSalesRegionCode(salesOrgVo.getSalesOrgCode());
                            entity.setSalesGroupCode(salesOrgVo.getSalesOrgCode());
                        }
                    }
                    entity.setBusinessFormatCode(promotionPlanVo.getBusinessFormatCode());
                    entity.setFeeYearMonth(vo.getYearMonthLy());
                    entity.setActivityFormCode(vo.getActivityFormCode());
                    entity.setActivityFormName(vo.getActivityFormName());
                    entity.setActivityTypeCode(vo.getActivityTypeCode());
                    entity.setActivityTypeName(vo.getActivityTypeName());
                    entity.setBeginDate(vo.getStartDate());
                    entity.setEndDate(vo.getEndDate());
                    entity.setCustomerCode(vo.getCustomerCode());
                    if (expenseCustomerVo != null) {
                        entity.setCustomerName(expenseCustomerVo.getCustomerName());
                        entity.setCustomerErpCode(expenseCustomerVo.getErpCode());
                    }
                    entity.setActivityCode(vo.getPromotionPlanCode());
                    entity.setActivityDetailCode(vo.getExpensesCode());
                    entity.setWithholdingAmount(((CalculateVo)filterVos.get(0)).getFormulaValue().subtract(auditAmount));
                    entity.setAdjustAmount(BigDecimal.ZERO);
                    entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                    entity.setWithholdingYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
                    entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
                    entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
                    entity.setTenantCode(TenantUtils.getTenantCode());
                    entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.ONLINE_RETAILERS_WITHHOLDING.getCode());
                    Date date = new Date();
                    entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    entity.setCreateAccount(loginDetails.getAccount());
                    entity.setCreateName(loginDetails.getRealName());
                    entity.setModifyAccount(loginDetails.getAccount());
                    entity.setModifyName(loginDetails.getRealName());
                    entity.setCreateTime(date);
                    entity.setModifyTime(date);
                    entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
                    result.add(entity);
                    ++counter;
                }
                if (page.getRecords().size() == pageSize) {
                    pageable = PageRequest.of((int)(++pageNum), (int)pageSize);
                    page = this.generalExpensesService.findByConditions((Pageable)pageable, generalExpensesDto);
                    continue;
                }
                page.setRecords(new ArrayList());
            }
        } else if (TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
            log.info("\u5927\u65e5\u671f\u9884\u63d0\u5f00\u59cb\uff01");
            Date date = new Date();
            if (CollectionUtils.isEmpty((Collection)mainVo.getOrgVoList()) || CollectionUtils.isEmpty((Collection)mainVo.getProductVoList())) {
                log.info("\u5927\u65e5\u671f\u9884\u63d0===\u300b\u9884\u63d0\u516c\u5f0f[{}]\u7ec4\u7ec7\u4fe1\u606f\u6216\u4ea7\u54c1\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)mainVo.getWithholdingFormulaCode());
                return;
            }
            String formulaCacheId = UUID.randomUUID().toString().replace("-", "");
            this.redisService.set("tpm:withholding:largeDate:formula:" + formulaCacheId, (Object)JSONObject.toJSONString((Object)mainVo), TpmWithholdingDetailConstant.TPM_LARGE_DATE_WITHHOLDING_EXPIRE_TIME.longValue());
            for (WithholdingFormulaROrgVo orgVo : mainVo.getOrgVoList()) {
                log.info("\u5927\u65e5\u671f\u9884\u63d0===\u300b{}", (Object)orgVo.getSalesOrgCode());
                SalesOrgAllParentVo salesOrgAllParentVo = null;
                if (Objects.nonNull(salesOrgMap) && salesOrgMap.containsKey(orgVo.getSalesOrgCode())) {
                    salesOrgAllParentVo = (SalesOrgAllParentVo)salesOrgMap.get(orgVo.getSalesOrgCode());
                }
                int pageNum = 1;
                int pageSize = 500;
                PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
                TerminalPaginationDto paginationDto = new TerminalPaginationDto();
                paginationDto.setSalesInstitutionCode(orgVo.getSalesOrgCode());
                log.info("\u5927\u65e5\u671f\u9884\u63d0\u67e5\u95e8\u5e97===\u300b{}", (Object)orgVo.getSalesOrgCode());
                Page terminalVoPage = this.terminalVoService.findByTerminalPaginationDto((Pageable)pageable, paginationDto);
                ArrayList terminalVoList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)terminalVoPage.getRecords())) {
                    terminalVoList = new ArrayList(terminalVoPage.getRecords());
                }
                while (!CollectionUtils.isEmpty((Collection)terminalVoPage.getRecords())) {
                    if (CollectionUtils.isEmpty((Collection)(terminalVoPage = this.terminalVoService.findByTerminalPaginationDto((Pageable)(pageable = PageRequest.of((int)(++pageNum), (int)pageSize)), paginationDto)).getRecords())) continue;
                    terminalVoList.addAll(new ArrayList(terminalVoPage.getRecords()));
                }
                if (CollectionUtils.isEmpty(terminalVoList)) {
                    log.info("\u5927\u65e5\u671f\u9884\u63d0===\u300b\u9884\u63d0\u516c\u5f0f[{}]\u7ec4\u7ec7[{}]\u672a\u67e5\u8be2\u5230\u95e8\u5e97\u4fe1\u606f\uff01", (Object)mainVo.getWithholdingFormulaCode(), (Object)orgVo.getSalesOrgCode());
                    return;
                }
                List terminalCodeList = terminalVoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getTerminalCode())).map(TerminalVo::getTerminalCode).distinct().collect(Collectors.toList());
                log.info("\u5927\u65e5\u671f\u9884\u63d0===\u300b\u9500\u552e\u7ec4\u7ec7\u6570\u91cf[{}]\uff0c\u4ea7\u54c1\u6570\u91cf[{}]\uff0c\u95e8\u5e97\u6570\u91cf[{}]", new Object[]{mainVo.getOrgVoList().size(), mainVo.getProductVoList().size(), terminalCodeList.size()});
                for (List codes : Lists.partition(terminalCodeList, (int)200)) {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    TpmLargeDateWithholdingMessageDto messageDto = new TpmLargeDateWithholdingMessageDto();
                    messageDto.setUuid(uuid);
                    messageDto.setFormulaCacheId(formulaCacheId);
                    messageDto.setDate(date);
                    messageDto.setCustomerVo(customerVo);
                    messageDto.setSalesOrgAllParentVo(salesOrgAllParentVo);
                    this.redisService.set("tpm:withholding:largeDate:terminal:" + uuid, (Object)JSONObject.toJSONString((Object)codes), TpmWithholdingDetailConstant.TPM_LARGE_DATE_WITHHOLDING_EXPIRE_TIME.longValue());
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(JSONObject.toJSONString((Object)messageDto));
                    mqMessageVo.setTopic("TPM_WITHHOLDING_DETAIL_TOPIC" + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag("LARGE_DATE_WITHHOLDING_SAVE_OR_UPDATE_MQ_TAG");
                    this.rocketMqProducer.sendMqMsg(mqMessageVo);
                }
            }
        } else if (TpmWithholdingDetailCategoryEnum.VERTICAL_RECEIVABLE_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
            CalculateDto calculateDto = new CalculateDto();
            calculateDto.setActivityFormCode(mainVo.getEffectiveActivityFormCode());
            calculateDto.setCode(mainVo.getWithholdingFormulaCode());
            calculateDto.setName(mainVo.getWithholdingFormulaName());
            calculateDto.setCustomerCode(mainVo.getCustomerCode());
            if (Objects.nonNull(customerVo)) {
                calculateDto.setCustomerErpCode(customerVo.getErpCode());
            }
            calculateDto.setFormulaInfoDtoList(new ArrayList());
            for (WithholdingFormulaInfoVo infoVo : mainVo.getWithholdingFormulaInfoVoList()) {
                FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                formulaInfoDto.setFormulaCode(infoVo.getWithholdingFormulaCode());
                formulaInfoDto.setFormula(infoVo.getWithholdingFormula());
                formulaInfoDto.setFormulaCondition(infoVo.getWithholdingFormulaCondition());
                formulaInfoDto.setFormulaConditionName(infoVo.getWithholdingFormulaConditionName());
                formulaInfoDto.setFormulaName(infoVo.getWithholdingFormulaName());
                calculateDto.getFormulaInfoDtoList().add(formulaInfoDto);
            }
            ArrayList<CalculateDto> calculateDtoList = new ArrayList<CalculateDto>();
            calculateDtoList.add(calculateDto);
            log.info("\u5782\u76f4\u5e94\u6536\u9884\u63d0===\u300b\u516c\u5f0f\u8ba1\u7b97===\u300b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)calculateDto));
            List calculateVoList = this.variableService.allCalculateConditionAndExpression(calculateDtoList);
            Map calculateVoMap = calculateVoList.stream().collect(Collectors.toMap(CalculateVo::getCode, Function.identity()));
            String ruleCode = "YTMX";
            List withholdingCodeList = this.generateCodeService.generateCode(ruleCode, 1);
            CalculateVo calculateVo = (CalculateVo)calculateVoMap.get(mainVo.getWithholdingFormulaCode());
            TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
            entity.setWithholdingDetailCode((String)withholdingCodeList.get(0));
            entity.setBusinessFormatCode(mainVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(mainVo.getBusinessUnitCode());
            entity.setSalesOrgCode(mainVo.getSalesOrgCode());
            entity.setCustomerCode(mainVo.getCustomerCode());
            if (customerVo != null) {
                entity.setCustomerName(customerVo.getCustomerName());
                entity.setCustomerErpCode(customerVo.getErpCode());
            }
            entity.setWithholdingAmount(calculateVo.getFormulaValue());
            entity.setAdjustAmount(BigDecimal.ZERO);
            entity.setAfterAdjustAmount(entity.getWithholdingAmount());
            entity.setWithholdingYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
            entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.VERTICAL_RECEIVABLE_WITHHOLDING.getCode());
            Date date = new Date();
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entity.setCreateAccount(loginDetails.getAccount());
            entity.setCreateName(loginDetails.getRealName());
            entity.setModifyAccount(loginDetails.getAccount());
            entity.setModifyName(loginDetails.getRealName());
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            result.add(entity);
        }
        if (CollectionUtils.isNotEmpty(result)) {
            this.tpmWithholdingDetailEntityMapper.insertList(result);
        }
    }

    public void systemWithholding() {
        ArrayList<TpmWithholdingDetailEntity> entityList = new ArrayList<TpmWithholdingDetailEntity>();
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        entityList.addAll(this.eStoreWithholdingFormula(loginDetails));
        entityList.addAll(this.subComLargeDateWithholdingFormula(loginDetails));
        entityList.addAll(this.verticalWithholdingFormula(loginDetails));
        if (CollectionUtils.isNotEmpty(entityList)) {
            this.tpmWithholdingDetailEntityMapper.insertList(entityList);
        }
    }

    private List<TpmWithholdingDetailEntity> eStoreWithholdingFormula(FacturerUserDetails loginDetails) {
        int pageNum = 0;
        int pageSize = 500;
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        Page page = this.generalExpensesService.findForWithholding((Pageable)pageable, ProcessStatusEnum.PASS.getDictCode(), BooleanEnum.TRUE.getCapital());
        ArrayList<TpmWithholdingDetailEntity> result = new ArrayList<TpmWithholdingDetailEntity>();
        while (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            Set customerCodeSet = page.getRecords().stream().map(ExpensesVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList(customerCodeSet));
            Map customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            Set salesOrgCodeSet = page.getRecords().stream().map(GeneralExpensesVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet));
            Map salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            List auditList = this.auditService.findAuditCustomerDetailCollectionByDetailPlanItemCodeList(page.getRecords().stream().map(ExpensesVo::getExpensesCode).collect(Collectors.toList()));
            Map<String, List<AuditCustomerDetailCollectionVo>> auditMap = auditList.stream().collect(Collectors.groupingBy(AuditCustomerDetailCollectionVo::getActivityDetailCode));
            List promotionPlanList = this.promotionPlanService.findByCodeList(page.getRecords().stream().map(ExpensesVo::getPromotionPlanCode).collect(Collectors.toList()));
            Map promotionPlanMap = promotionPlanList.stream().collect(Collectors.toMap(PromotionPlanVo::getPromotionPlanCode, Function.identity()));
            String ruleCode = "YTMX";
            List withholdingCodeList = this.generateCodeService.generateCode(ruleCode, page.getRecords().size());
            int counter = 0;
            for (GeneralExpensesVo vo : page.getRecords()) {
                PromotionPlanVo promotionPlanVo = (PromotionPlanVo)promotionPlanMap.get(vo.getPromotionTypeCode());
                if (promotionPlanVo == null) continue;
                WithholdingFormulaMainDto dto = new WithholdingFormulaMainDto();
                dto.setEffectiveActivityFormCode(vo.getActivityFormCode());
                dto.setPlatformCode(vo.getPlatformCode());
                dto.setCustomerCode(vo.getCustomerCode());
                dto.setECommerceChannelCode(vo.getChannelCode());
                dto.setWithholdingType(WithholdingTypeEnum.E_STORE.getDictCode());
                dto.setSalesOrgCode(promotionPlanVo.getSalesOrgCode());
                List mainVoList = this.withholdingFormulaMainService.findForWithholdingDetail(dto);
                if (CollectionUtils.isEmpty((Collection)mainVoList)) {
                    log.error("\u4fc3\u9500\u89c4\u5212[" + vo.getPromotionPlanCode() + "]\u8d39\u7528\u660e\u7ec6[" + vo.getExpensesCode() + "]\u65e0\u5339\u914d\u7684\u9884\u63d0\u89c4\u5219");
                    continue;
                }
                WithholdingFormulaMainVo mainVo = (WithholdingFormulaMainVo)mainVoList.get(0);
                CalculateDto calculateDto = new CalculateDto();
                calculateDto.setActivityFormCode(mainVo.getEffectiveActivityFormCode());
                if (StringUtils.isNotEmpty((CharSequence)mainVo.getSalesOrgCode()) && salesOrgVoMap.containsKey(mainVo.getSalesOrgCode())) {
                    calculateDto.setSalesOrgErpCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getErpCode());
                }
                calculateDto.setSalesOrgCode(mainVo.getSalesOrgCode());
                calculateDto.setCode(mainVo.getWithholdingFormulaCode());
                calculateDto.setName(mainVo.getWithholdingFormulaName());
                calculateDto.setCustomerCode(mainVo.getCustomerCode());
                if (StringUtils.isNotEmpty((CharSequence)mainVo.getCustomerCode()) && customerVoMap.containsKey(mainVo.getCustomerCode())) {
                    calculateDto.setCustomerErpCode(((CustomerVo)customerVoMap.get(mainVo.getCustomerCode())).getErpCode());
                }
                calculateDto.setFormulaInfoDtoList(new ArrayList());
                calculateDto.setProductCode(vo.getProductCode());
                calculateDto.setPromotionPlanCode(vo.getPromotionPlanCode());
                calculateDto.setWithHoldDate(new Date());
                for (WithholdingFormulaInfoVo infoVo : mainVo.getWithholdingFormulaInfoVoList()) {
                    FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                    formulaInfoDto.setFormulaCode(infoVo.getWithholdingFormulaCode());
                    formulaInfoDto.setFormula(infoVo.getWithholdingFormula());
                    formulaInfoDto.setFormulaCondition(infoVo.getWithholdingFormulaCondition());
                    formulaInfoDto.setFormulaConditionName(infoVo.getWithholdingFormulaConditionName());
                    formulaInfoDto.setFormulaName(infoVo.getWithholdingFormulaName());
                    calculateDto.getFormulaInfoDtoList().add(formulaInfoDto);
                }
                ArrayList<CalculateDto> calculateList = new ArrayList<CalculateDto>();
                calculateList.add(calculateDto);
                log.info("\u7535\u5546\u9884\u63d0===\u300b\u516c\u5f0f\u8ba1\u7b97===\u300b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)calculateDto));
                List calculateVoList = this.variableService.allCalculateConditionAndExpression(calculateList);
                List filterVos = calculateVoList.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
                Validate.isTrue((filterVos.size() < 2 ? 1 : 0) != 0, (String)"\u4fc3\u9500\u89c4\u5212[%s]\u8d39\u7528\u660e\u7ec6[%s]\u9884\u63d0\u89c4\u5219\u516c\u5f0f\u7f16\u7801 [%s] \u8ba1\u7b97\u7ed3\u679c\uff1a\u591a\u4e2a\u6838\u9500\u516c\u5f0f\u6761\u4ef6\u540c\u65f6\u6ee1\u8db3\uff01", (Object[])new Object[]{promotionPlanVo.getPromotionPlanCode(), vo.getExpensesCode(), mainVo.getWithholdingFormulaCode()});
                if (CollectionUtils.isEmpty(filterVos)) continue;
                BigDecimal auditAmount = BigDecimal.ZERO;
                if (auditMap.get(vo.getExpensesCode()) != null) {
                    for (AuditCustomerDetailCollectionVo auditVo : auditMap.get(vo.getExpensesCode())) {
                        if (auditVo.getReimburseUpAccount() == null) {
                            auditVo.setReimburseUpAccount(BigDecimal.ZERO);
                        }
                        if (auditVo.getDiscountUpAccount() == null) {
                            auditVo.setDiscountUpAccount(BigDecimal.ZERO);
                        }
                        auditAmount = auditVo.getReimburseUpAccount().add(auditVo.getDiscountUpAccount());
                    }
                }
                TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
                entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
                entity.setBusinessUnitCode(BusinessUnitEnum.ONLINE.getCode());
                entity.setSalesOrgCode(promotionPlanVo.getSalesOrgCode());
                entity.setSalesOrgName(promotionPlanVo.getSalesOrgName());
                if (StringUtils.isNotEmpty((CharSequence)promotionPlanVo.getSalesOrgCode()) && salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode()) != null) {
                    entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getErpCode());
                    entity.setSalesOrgLevel(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesOrgLevel());
                    entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesInstitutionCode());
                    if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                    if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesOrgCode());
                        entity.setSalesGroupCode(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                }
                entity.setActivityName(promotionPlanVo.getPromotionPlanName());
                entity.setFeeYearMonth(vo.getYearMonthLy());
                if (StringUtils.isNotEmpty((CharSequence)promotionPlanVo.getSalesOrgCode()) && salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode()) != null) {
                    entity.setCustomerErpCode(((SalesOrgVo)salesOrgVoMap.get(promotionPlanVo.getSalesOrgCode())).getErpCode());
                }
                entity.setBusinessFormatCode(promotionPlanVo.getBusinessFormatCode());
                entity.setActivityFormCode(vo.getActivityFormCode());
                entity.setActivityFormName(vo.getActivityFormName());
                entity.setActivityTypeCode(vo.getActivityTypeCode());
                entity.setActivityTypeName(vo.getActivityTypeName());
                entity.setBeginDate(vo.getStartDate());
                entity.setEndDate(vo.getEndDate());
                entity.setCustomerCode(vo.getCustomerCode());
                entity.setCustomerName(vo.getCustomerName());
                if (StringUtils.isNotEmpty((CharSequence)promotionPlanVo.getCustomerCode()) && customerVoMap.get(promotionPlanVo.getCustomerCode()) != null) {
                    entity.setCustomerErpCode(((CustomerVo)customerVoMap.get(promotionPlanVo.getCustomerCode())).getErpCode());
                }
                entity.setProductCode(vo.getProductCode());
                entity.setProductName(vo.getProductName());
                entity.setActivityCode(vo.getPromotionPlanCode());
                entity.setActivityDetailCode(vo.getExpensesCode());
                entity.setWithholdingAmount(((CalculateVo)filterVos.get(0)).getFormulaValue().subtract(auditAmount));
                entity.setAdjustAmount(BigDecimal.ZERO);
                entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                entity.setWithholdingYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.ONLINE_RETAILERS_WITHHOLDING.getCode());
                Date date = new Date();
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setCreateAccount(loginDetails.getAccount());
                entity.setCreateName(loginDetails.getRealName());
                entity.setModifyAccount(loginDetails.getAccount());
                entity.setModifyName(loginDetails.getRealName());
                entity.setCreateTime(date);
                entity.setModifyTime(date);
                entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
                result.add(entity);
                ++counter;
            }
            if (page.getRecords().size() != pageSize) {
                pageable = PageRequest.of((int)(++pageNum), (int)pageSize);
                page = this.generalExpensesService.findForWithholding((Pageable)pageable, ProcessStatusEnum.PASS.getDictCode(), BooleanEnum.TRUE.getCapital());
                continue;
            }
            page.setRecords(new ArrayList());
        }
        return result;
    }

    private List<TpmWithholdingDetailEntity> subComLargeDateWithholdingFormula(FacturerUserDetails loginDetails) {
        ArrayList<CalculateDto> calculateList = new ArrayList<CalculateDto>();
        WithholdingFormulaMainDto dto = new WithholdingFormulaMainDto();
        dto.setWithholdingType(WithholdingTypeEnum.SUB_COM_LARGE_DATE.getDictCode());
        List mainVoList = this.withholdingFormulaMainService.findForWithholdingDetail(dto);
        Set customerCodeSet = mainVoList.stream().map(WithholdingFormulaMainVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList(customerCodeSet));
        Map customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        Set salesOrgCodeSet = mainVoList.stream().map(WithholdingFormulaMainVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet));
        Map salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        ArrayList<TpmWithholdingDetailEntity> result = new ArrayList<TpmWithholdingDetailEntity>();
        String ruleCode = "YTMX";
        for (WithholdingFormulaMainVo mainVo : mainVoList) {
            if (CollectionUtils.isEmpty((Collection)mainVo.getOrgVoList()) || CollectionUtils.isEmpty((Collection)mainVo.getProductVoList())) continue;
            List mdmProductList = this.productVoService.findByCodes(mainVo.getProductVoList().stream().map(WithholdingFormulaRProductVo::getProductCode).collect(Collectors.toList()));
            Map mdmProductMap = mdmProductList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            for (WithholdingFormulaROrgVo salesOrg : mainVo.getOrgVoList()) {
                for (WithholdingFormulaRProductVo product : mainVo.getProductVoList()) {
                    CalculateDto calculateDto = new CalculateDto();
                    calculateDto.setActivityFormCode(mainVo.getEffectiveActivityFormCode());
                    calculateDto.setCode(mainVo.getWithholdingFormulaCode());
                    calculateDto.setName(mainVo.getWithholdingFormulaName());
                    if (StringUtils.isNotEmpty((CharSequence)mainVo.getSalesOrgCode()) && salesOrgVoMap.containsKey(mainVo.getSalesOrgCode())) {
                        calculateDto.setSalesOrgErpCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getErpCode());
                    }
                    calculateDto.setSalesOrgCode(mainVo.getSalesOrgCode());
                    calculateDto.setCustomerCode(mainVo.getCustomerCode());
                    if (StringUtils.isNotEmpty((CharSequence)mainVo.getCustomerCode()) && customerVoMap.containsKey(mainVo.getCustomerCode())) {
                        calculateDto.setCustomerErpCode(((CustomerVo)customerVoMap.get(mainVo.getCustomerCode())).getErpCode());
                    }
                    calculateDto.setFormulaInfoDtoList(new ArrayList());
                    calculateDto.setSalesOrgCode(salesOrg.getSalesOrgCode());
                    calculateDto.setSalesGroupCode(salesOrg.getSalesOrgCode());
                    calculateDto.setProductCode(product.getProductCode());
                    for (WithholdingFormulaInfoVo infoVo : mainVo.getWithholdingFormulaInfoVoList()) {
                        FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                        formulaInfoDto.setFormulaCode(infoVo.getWithholdingFormulaCode());
                        formulaInfoDto.setFormula(infoVo.getWithholdingFormula());
                        formulaInfoDto.setFormulaCondition(infoVo.getWithholdingFormulaCondition());
                        formulaInfoDto.setFormulaConditionName(infoVo.getWithholdingFormulaConditionName());
                        formulaInfoDto.setFormulaName(infoVo.getWithholdingFormulaName());
                        calculateDto.getFormulaInfoDtoList().add(formulaInfoDto);
                    }
                    calculateList.add(calculateDto);
                    log.info("\u5206\u5b50\u516c\u53f8\u5927\u65e5\u671f\u9884\u63d0===\u300b\u516c\u5f0f\u8ba1\u7b97===\u300b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)calculateDto));
                    List calculateVoList = this.variableService.allCalculateConditionAndExpression(calculateList);
                    List filterVos = calculateVoList.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
                    List withholdingCodeList = this.generateCodeService.generateCode(ruleCode, 1);
                    TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
                    entity.setWithholdingDetailCode((String)withholdingCodeList.get(0));
                    entity.setBusinessFormatCode(mainVo.getBusinessFormatCode());
                    entity.setBusinessUnitCode(mainVo.getBusinessUnitCode());
                    entity.setSalesOrgCode(mainVo.getSalesOrgCode());
                    entity.setSalesOrgName(mainVo.getSalesOrgName());
                    entity.setProductCode(product.getProductCode());
                    if (mdmProductMap.get(product.getProductCode()) != null) {
                        entity.setProductName(((ProductVo)mdmProductMap.get(product.getProductCode())).getProductName());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)mainVo.getSalesOrgCode()) && salesOrgVoMap.get(mainVo.getSalesOrgCode()) != null) {
                        entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getErpCode());
                        entity.setSalesOrgLevel(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgLevel());
                        entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesInstitutionCode());
                        if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgLevel())) {
                            entity.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgCode());
                        }
                        if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgLevel())) {
                            entity.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgCode());
                            entity.setSalesGroupCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgCode());
                        }
                    }
                    entity.setCustomerCode(mainVo.getCustomerCode());
                    entity.setCustomerName(mainVo.getCustomerName());
                    if (StringUtils.isNotEmpty((CharSequence)mainVo.getCustomerCode()) && customerVoMap.get(mainVo.getCustomerCode()) != null) {
                        entity.setCustomerErpCode(((CustomerVo)customerVoMap.get(mainVo.getCustomerCode())).getErpCode());
                    }
                    entity.setWithholdingAmount(filterVos.stream().map(CalculateVo::getFormulaValue).reduce(BigDecimal.ZERO, BigDecimal::add));
                    entity.setAdjustAmount(BigDecimal.ZERO);
                    entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                    entity.setWithholdingYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
                    entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                    entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    entity.setTenantCode(TenantUtils.getTenantCode());
                    entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode());
                    Date date = new Date();
                    entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    entity.setCreateAccount(loginDetails.getAccount());
                    entity.setCreateName(loginDetails.getRealName());
                    entity.setModifyAccount(loginDetails.getAccount());
                    entity.setModifyName(loginDetails.getRealName());
                    entity.setCreateTime(date);
                    entity.setModifyTime(date);
                    entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
                    result.add(entity);
                }
            }
        }
        return result;
    }

    private List<TpmWithholdingDetailEntity> verticalWithholdingFormula(FacturerUserDetails loginDetails) {
        ArrayList<CalculateDto> calculateList = new ArrayList<CalculateDto>();
        WithholdingFormulaMainDto dto = new WithholdingFormulaMainDto();
        dto.setWithholdingType(WithholdingTypeEnum.SUB_COM_LARGE_DATE.getDictCode());
        List mainVoList = this.withholdingFormulaMainService.findForWithholdingDetail(dto);
        Set customerCodeSet = mainVoList.stream().map(WithholdingFormulaMainVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList(customerCodeSet));
        Map customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        Set salesOrgCodeSet = mainVoList.stream().map(WithholdingFormulaMainVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet));
        Map salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        for (WithholdingFormulaMainVo mainVo : mainVoList) {
            CalculateDto calculateDto = new CalculateDto();
            calculateDto.setActivityFormCode(mainVo.getEffectiveActivityFormCode());
            calculateDto.setCode(mainVo.getWithholdingFormulaCode());
            calculateDto.setName(mainVo.getWithholdingFormulaName());
            calculateDto.setCustomerCode(mainVo.getCustomerCode());
            if (StringUtils.isNotEmpty((CharSequence)mainVo.getCustomerCode()) && customerVoMap.containsKey(mainVo.getCustomerCode())) {
                calculateDto.setCustomerErpCode(((CustomerVo)customerVoMap.get(mainVo.getCustomerCode())).getErpCode());
            }
            calculateDto.setFormulaInfoDtoList(new ArrayList());
            for (WithholdingFormulaInfoVo infoVo : mainVo.getWithholdingFormulaInfoVoList()) {
                FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                formulaInfoDto.setFormulaCode(infoVo.getWithholdingFormulaCode());
                formulaInfoDto.setFormula(infoVo.getWithholdingFormula());
                formulaInfoDto.setFormulaCondition(infoVo.getWithholdingFormulaCondition());
                formulaInfoDto.setFormulaConditionName(infoVo.getWithholdingFormulaConditionName());
                formulaInfoDto.setFormulaName(infoVo.getWithholdingFormulaName());
                calculateDto.getFormulaInfoDtoList().add(formulaInfoDto);
            }
            calculateList.add(calculateDto);
        }
        log.info("\u5782\u76f4\u5e94\u6536\u9884\u63d0===\u300b\u516c\u5f0f\u8ba1\u7b97===\u300b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(calculateList));
        List calculateVoList = this.variableService.allCalculateConditionAndExpression(calculateList);
        Map calculateVoMap = calculateVoList.stream().collect(Collectors.toMap(CalculateVo::getCode, Function.identity()));
        ArrayList<TpmWithholdingDetailEntity> result = new ArrayList<TpmWithholdingDetailEntity>();
        String ruleCode = "YTMX";
        List withholdingCodeList = this.generateCodeService.generateCode(ruleCode, mainVoList.size());
        int counter = 0;
        for (WithholdingFormulaMainVo mainVo : mainVoList) {
            CalculateVo calculateVo = (CalculateVo)calculateVoMap.get(mainVo.getWithholdingFormulaCode());
            TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
            entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
            entity.setBusinessFormatCode(mainVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(mainVo.getBusinessUnitCode());
            entity.setSalesOrgCode(mainVo.getSalesOrgCode());
            entity.setSalesOrgName(mainVo.getSalesOrgName());
            if (StringUtils.isNotEmpty((CharSequence)mainVo.getSalesOrgCode()) && salesOrgVoMap.get(mainVo.getSalesOrgCode()) != null) {
                entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getErpCode());
                entity.setSalesOrgLevel(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgLevel());
                entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesInstitutionCode());
                if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgLevel())) {
                    entity.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgCode());
                }
                if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgLevel())) {
                    entity.setSalesRegionCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgCode());
                    entity.setSalesGroupCode(((SalesOrgVo)salesOrgVoMap.get(mainVo.getSalesOrgCode())).getSalesOrgCode());
                }
            }
            entity.setCustomerCode(mainVo.getCustomerCode());
            entity.setCustomerName(mainVo.getCustomerName());
            if (StringUtils.isNotEmpty((CharSequence)mainVo.getCustomerCode()) && customerVoMap.get(mainVo.getCustomerCode()) != null) {
                entity.setCustomerErpCode(((CustomerVo)customerVoMap.get(mainVo.getCustomerCode())).getErpCode());
            }
            entity.setWithholdingAmount(calculateVo.getFormulaValue());
            entity.setAdjustAmount(BigDecimal.ZERO);
            entity.setAfterAdjustAmount(entity.getWithholdingAmount());
            entity.setWithholdingYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.VERTICAL_RECEIVABLE_WITHHOLDING.getCode());
            Date date = new Date();
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entity.setCreateAccount(loginDetails.getAccount());
            entity.setCreateName(loginDetails.getRealName());
            entity.setModifyAccount(loginDetails.getAccount());
            entity.setModifyName(loginDetails.getRealName());
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            result.add(entity);
            ++counter;
        }
        return result;
    }
}

