/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.impl;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.prepayment.details.sdk.dto.PrepaymentDetailsDto;
import com.biz.crm.tpm.business.prepayment.details.sdk.service.PrepaymentDetailsService;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import com.biz.crm.tpm.business.withholding.detail.local.entity.TpmWithholdingDetailEntity;
import com.biz.crm.tpm.business.withholding.detail.local.mapper.TpmWithholdingDetailEntityMapper;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailPrepaymentDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailCostCenterUtil;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.MD5Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TpmWithholdingDetailPrepaymentDetailPartServiceImpl
implements TpmWithholdingDetailPrepaymentDetailPartService {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailPrepaymentDetailPartServiceImpl.class);
    @Autowired(required=false)
    private TpmWithholdingDetailEntityMapper tpmWithholdingDetailEntityMapper;
    @Autowired(required=false)
    private PrepaymentDetailsService prepaymentDetailsService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private TpmWithholdingDetailCostCenterUtil tpmWithholdingDetailCostCenterUtil;

    @Transactional(rollbackFor={Exception.class})
    public void systemWithholding() {
        TpmWithholdingDetailEntity entity;
        List withholdingCodeList;
        Date date = new Date();
        this.loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        String beginDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        calendar.add(2, 1);
        String endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        List prepaymentDetailsVoList = this.prepaymentDetailsService.findForWithholding(beginDate, endDate, null);
        Set salesOrgCodeSet = prepaymentDetailsVoList.stream().map(PrepaymentDetailsVo::getSalesOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        Map<Object, Object> salesOrgMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesOrgCodeSet)) {
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesOrgCodeSet));
            salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        ArrayList<TpmWithholdingDetailEntity> entityList = new ArrayList<TpmWithholdingDetailEntity>();
        int counter = 0;
        if (CollectionUtils.isEmpty((Collection)prepaymentDetailsVoList)) {
            withholdingCodeList = this.generateCodeService.generateCode("YTMX", prepaymentDetailsVoList.size());
            for (PrepaymentDetailsVo prepaymentVo : prepaymentDetailsVoList) {
                entity = new TpmWithholdingDetailEntity();
                entity.setActivityDetailCode(prepaymentVo.getActivityDetailNo());
                entity.setActivityName(prepaymentVo.getPrepaymentName());
                entity.setCustomerCode(prepaymentVo.getCustomerCode());
                entity.setCustomerName(prepaymentVo.getCustomerName());
                entity.setPayType(prepaymentVo.getPaymentMethod());
                entity.setBusinessFormatCode(prepaymentVo.getBusinessFormatCode());
                entity.setBusinessUnitCode(prepaymentVo.getBusinessUnitCode());
                entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
                entity.setActivityTypeCode(prepaymentVo.getActivityTypeCode());
                entity.setActivityTypeName(prepaymentVo.getActivityTypeName());
                entity.setActivityFormCode(prepaymentVo.getActivityFormCode());
                entity.setActivityFormName(prepaymentVo.getActivityFormName());
                entity.setSalesOrgCode(prepaymentVo.getSalesOrgCode());
                entity.setSalesOrgName(prepaymentVo.getSalesOrgName());
                entity.setResaleCommercialCode(prepaymentVo.getSystemCode());
                entity.setResaleCommercialName(prepaymentVo.getSystemName());
                entity.setRegion(prepaymentVo.getRegion());
                if (prepaymentVo.getSalesOrgCode() != null && salesOrgMap.get(prepaymentVo.getSalesOrgCode()) != null) {
                    entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getErpCode());
                    entity.setSalesOrgLevel(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel());
                    entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesInstitutionCode());
                    if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                    if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                        entity.setSalesGroupCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                }
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setCreateAccount(loginUser.getAccount());
                entity.setCreateName(loginUser.getRealName());
                entity.setModifyAccount(loginUser.getAccount());
                entity.setModifyName(loginUser.getRealName());
                entity.setCreateTime(date);
                entity.setModifyTime(date);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setWithholdingYearMonth(DateUtil.format((Date)date, (String)"yyyy-MM"));
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
                entity.setWithholdingAmount(prepaymentVo.getAmountWrittenOff());
                entity.setAdjustAmount(BigDecimal.ZERO);
                entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
                entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.PRE_PAY_WITHHOLDING.getCode());
                entity.setUniqueMd5Key(this.generateUniqueMd5KeyForPrepaidWithholding(entity, prepaymentVo));
                entityList.add(entity);
                ++counter;
            }
        }
        prepaymentDetailsVoList = this.prepaymentDetailsService.findUpwardForWithholding(beginDate, endDate, null);
        salesOrgCodeSet = prepaymentDetailsVoList.stream().map(PrepaymentDetailsVo::getSalesOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        salesOrgMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesOrgCodeSet)) {
            List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(new ArrayList(salesOrgCodeSet));
            salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        }
        if (CollectionUtils.isEmpty((Collection)prepaymentDetailsVoList)) {
            withholdingCodeList = this.generateCodeService.generateCode("YTMX", prepaymentDetailsVoList.size(), Integer.valueOf(8), 32L, TimeUnit.DAYS);
            counter = 0;
            for (PrepaymentDetailsVo prepaymentVo : prepaymentDetailsVoList) {
                entity = new TpmWithholdingDetailEntity();
                entity.setActivityDetailCode(prepaymentVo.getActivityDetailNo());
                entity.setActivityName(prepaymentVo.getPrepaymentName());
                entity.setCustomerCode(prepaymentVo.getCustomerCode());
                entity.setCustomerName(prepaymentVo.getCustomerName());
                entity.setPayType(prepaymentVo.getPaymentMethod());
                entity.setBusinessFormatCode(prepaymentVo.getBusinessFormatCode());
                entity.setBusinessUnitCode(prepaymentVo.getBusinessUnitCode());
                entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
                entity.setActivityTypeCode(prepaymentVo.getActivityTypeCode());
                entity.setActivityTypeName(prepaymentVo.getActivityTypeName());
                entity.setActivityFormCode(prepaymentVo.getActivityFormCode());
                entity.setActivityFormName(prepaymentVo.getActivityFormName());
                entity.setSalesOrgCode(prepaymentVo.getSalesOrgCode());
                entity.setSalesOrgName(prepaymentVo.getSalesOrgName());
                entity.setResaleCommercialCode(prepaymentVo.getSystemCode());
                entity.setResaleCommercialName(prepaymentVo.getSystemName());
                entity.setRegion(prepaymentVo.getRegion());
                if (prepaymentVo.getSalesOrgCode() != null && salesOrgMap.get(prepaymentVo.getSalesOrgCode()) != null) {
                    entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getErpCode());
                    entity.setSalesOrgLevel(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel());
                    entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesInstitutionCode());
                    if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                    if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                        entity.setSalesGroupCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                }
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setCreateAccount(loginUser.getAccount());
                entity.setCreateName(loginUser.getRealName());
                entity.setModifyAccount(loginUser.getAccount());
                entity.setModifyName(loginUser.getRealName());
                entity.setCreateTime(date);
                entity.setModifyTime(date);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setWithholdingYearMonth(DateUtil.format((Date)date, (String)"yyyy-MM"));
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setWithholdingAmount(prepaymentVo.getCurrentAmount());
                entity.setAdjustAmount(BigDecimal.ZERO);
                entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.UPWARD.getCode());
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.PRE_PAY_WITHHOLDING.getCode());
                entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
                entity.setUniqueMd5Key(this.generateUniqueMd5KeyForPrepaidWithholding(entity, prepaymentVo));
                entityList.add(entity);
                ++counter;
            }
        }
        if (CollectionUtils.isNotEmpty(entityList)) {
            this.tpmWithholdingDetailEntityMapper.insertList(entityList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void redoWithholding(TpmWithholdingDetailRedoWithholdingDto dto) {
        List prepaymentDetailsVoList;
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            throw new UnsupportedOperationException("\u4e3b\u4f53\u65e0\u9884\u4ed8\u9884\u63d0");
        }
        Date date = new Date();
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String beginDate = dto.getStartDate();
        String endDate = dto.getEndDate();
        PrepaymentDetailsDto prepaymentDetailsDto = new PrepaymentDetailsDto();
        prepaymentDetailsDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        prepaymentDetailsDto.setCustomerCode(dto.getCustomerCode());
        prepaymentDetailsDto.setSystemCode(dto.getResaleCommercialCode());
        prepaymentDetailsDto.setSalesOrgCode(dto.getSalesOrgCode());
        int counter = 0;
        ArrayList<TpmWithholdingDetailEntity> entityList = new ArrayList<TpmWithholdingDetailEntity>();
        if (!BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode()) || !TpmWithholdingDetailTargetEnum.UPWARD.getCode().equals(dto.getWithholdingTarget())) {
            prepaymentDetailsVoList = this.prepaymentDetailsService.findForWithholding(beginDate, endDate, prepaymentDetailsDto);
            if (CollectionUtils.isEmpty((Collection)prepaymentDetailsVoList)) {
                throw new UnsupportedOperationException("\u4e0d\u5b58\u5728\u53ef\u9884\u63d0\u9884\u4ed8\u660e\u7ec6\u6570\u636e");
            }
            Set customerCodeSet = prepaymentDetailsVoList.stream().map(PrepaymentDetailsVo::getCustomerCode).collect(Collectors.toSet());
            Map<Object, Object> customerMap = new HashMap();
            if (CollectionUtils.isNotEmpty(customerCodeSet)) {
                List customerList = this.customerVoService.findCustomerAndContactByCustomerCodes(new ArrayList(customerCodeSet));
                customerMap = customerList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
            Set salesOrgCodeSet = prepaymentDetailsVoList.stream().map(PrepaymentDetailsVo::getSalesOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            Map<Object, Object> salesOrgMap = new HashMap();
            if (CollectionUtils.isNotEmpty(salesOrgCodeSet)) {
                List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet));
                salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            }
            List withholdingCodeList = this.generateCodeService.generateCode("YTMX", prepaymentDetailsVoList.size());
            for (PrepaymentDetailsVo prepaymentVo : prepaymentDetailsVoList) {
                if (prepaymentVo.getActivityApplicationAmount() == null) {
                    prepaymentVo.setActivityApplicationAmount(BigDecimal.ZERO);
                }
                TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
                entity.setActivityDetailCode(prepaymentVo.getActivityDetailNo());
                entity.setActivityName(prepaymentVo.getPrepaymentName());
                entity.setCustomerCode(prepaymentVo.getCustomerCode());
                if (StringUtils.isNotEmpty((String)prepaymentVo.getCustomerCode()) && customerMap.get(prepaymentVo.getCustomerCode()) != null) {
                    entity.setCustomerName(((CustomerVo)customerMap.get(prepaymentVo.getCustomerCode())).getCustomerName());
                    entity.setCustomerErpCode(((CustomerVo)customerMap.get(prepaymentVo.getCustomerCode())).getErpCode());
                }
                entity.setPayType(prepaymentVo.getPaymentMethod());
                entity.setBusinessFormatCode(prepaymentVo.getBusinessFormatCode());
                entity.setBusinessUnitCode(prepaymentVo.getBusinessUnitCode());
                entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
                entity.setActivityTypeCode(prepaymentVo.getActivityTypeCode());
                entity.setActivityTypeName(prepaymentVo.getActivityTypeName());
                entity.setActivityFormCode(prepaymentVo.getActivityFormCode());
                entity.setActivityFormName(prepaymentVo.getActivityFormName());
                entity.setResaleCommercialCode(prepaymentVo.getSystemCode());
                entity.setResaleCommercialName(prepaymentVo.getSystemName());
                entity.setRegion(prepaymentVo.getRegion());
                entity.setSalesOrgCode(prepaymentVo.getSalesOrgCode());
                if (prepaymentVo.getSalesOrgCode() != null && salesOrgMap.get(prepaymentVo.getSalesOrgCode()) != null) {
                    entity.setSalesOrgName(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgName());
                    entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getErpCode());
                    entity.setSalesOrgLevel(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel());
                    entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesInstitutionCode());
                    if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                    if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                        entity.setSalesGroupCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                }
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setCreateAccount(loginDetails.getAccount());
                entity.setCreateName(loginDetails.getRealName());
                entity.setModifyAccount(loginDetails.getAccount());
                entity.setModifyName(loginDetails.getRealName());
                entity.setCreateTime(date);
                entity.setModifyTime(date);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setWithholdingYearMonth(dto.getWithholdingYearMonth());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
                entity.setWithholdingAmount(prepaymentVo.getCurrentAmount());
                entity.setAdjustAmount(BigDecimal.ZERO);
                entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
                entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.PRE_PAY_WITHHOLDING.getCode());
                entity.setUniqueMd5Key(this.generateUniqueMd5KeyForPrepaidWithholding(entity, prepaymentVo));
                entityList.add(entity);
                ++counter;
            }
        } else {
            prepaymentDetailsVoList = this.prepaymentDetailsService.findUpwardForWithholding(beginDate, endDate, prepaymentDetailsDto);
            Set salesOrgCodeSet = prepaymentDetailsVoList.stream().map(PrepaymentDetailsVo::getSalesOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            Map<Object, Object> salesOrgMap = new HashMap();
            if (CollectionUtils.isNotEmpty(salesOrgCodeSet)) {
                List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCodeSet));
                salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            }
            if (CollectionUtils.isEmpty((Collection)prepaymentDetailsVoList)) {
                throw new UnsupportedOperationException("\u4e0d\u5b58\u5728\u53ef\u9884\u63d0\u9884\u4ed8\u660e\u7ec6\u6570\u636e");
            }
            List withholdingCodeList = this.generateCodeService.generateCode("YTMX", prepaymentDetailsVoList.size());
            for (PrepaymentDetailsVo prepaymentVo : prepaymentDetailsVoList) {
                TpmWithholdingDetailEntity entity = new TpmWithholdingDetailEntity();
                entity.setActivityDetailCode(prepaymentVo.getActivityDetailNo());
                entity.setActivityName(prepaymentVo.getPrepaymentName());
                entity.setCustomerCode(prepaymentVo.getCustomerCode());
                entity.setCustomerName(prepaymentVo.getCustomerName());
                entity.setPayType(prepaymentVo.getPaymentMethod());
                entity.setBusinessFormatCode(prepaymentVo.getBusinessFormatCode());
                entity.setBusinessUnitCode(prepaymentVo.getBusinessUnitCode());
                entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
                entity.setActivityTypeCode(prepaymentVo.getActivityTypeCode());
                entity.setActivityTypeName(prepaymentVo.getActivityTypeName());
                entity.setActivityFormCode(prepaymentVo.getActivityFormCode());
                entity.setActivityFormName(prepaymentVo.getActivityFormName());
                entity.setSalesOrgCode(prepaymentVo.getSalesOrgCode());
                entity.setSalesOrgName(prepaymentVo.getSalesOrgName());
                entity.setResaleCommercialCode(prepaymentVo.getSystemCode());
                entity.setResaleCommercialName(prepaymentVo.getSystemName());
                entity.setRegion(prepaymentVo.getRegion());
                if (prepaymentVo.getSalesOrgCode() != null && salesOrgMap.get(prepaymentVo.getSalesOrgCode()) != null) {
                    entity.setSalesOrgErpCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getErpCode());
                    entity.setSalesOrgLevel(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel());
                    entity.setSalesInstitutionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesInstitutionCode());
                    if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                    if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgLevel())) {
                        entity.setSalesRegionCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                        entity.setSalesGroupCode(((SalesOrgVo)salesOrgMap.get(prepaymentVo.getSalesOrgCode())).getSalesOrgCode());
                    }
                }
                entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                entity.setCreateAccount(loginDetails.getAccount());
                entity.setCreateName(loginDetails.getRealName());
                entity.setModifyAccount(loginDetails.getAccount());
                entity.setModifyName(loginDetails.getRealName());
                entity.setCreateTime(date);
                entity.setModifyTime(date);
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setWithholdingYearMonth(dto.getWithholdingYearMonth());
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setWithholdingAmount(prepaymentVo.getCurrentAmount());
                entity.setAdjustAmount(BigDecimal.ZERO);
                entity.setAfterAdjustAmount(entity.getWithholdingAmount());
                entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.UPWARD.getCode());
                entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.PRE_PAY_WITHHOLDING.getCode());
                entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
                entity.setUniqueMd5Key(this.generateUniqueMd5KeyForPrepaidWithholding(entity, prepaymentVo));
                entityList.add(entity);
                ++counter;
            }
        }
        if (CollectionUtils.isNotEmpty(entityList)) {
            entityList.forEach(e -> e.setActivityDetailCode(UUID.randomUUID().toString().replace("-", "")));
            List dtoResultList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entityList, TpmWithholdingDetailEntity.class, TpmWithholdingDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, CostCenterRelationVo> costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(dtoResultList, null);
            entityList.forEach(v -> {
                if (costCenterMap.containsKey(v.getActivityDetailCode())) {
                    CostCenterRelationVo vo = (CostCenterRelationVo)costCenterMap.get(v.getActivityDetailCode());
                    v.setCostCenter(vo.getCostCenterCode());
                    v.setCostCenterName(vo.getCostCenterName());
                }
                v.setActivityDetailCode(null);
            });
            this.tpmWithholdingDetailEntityMapper.insertList(entityList);
        }
    }

    private String generateUniqueMd5KeyForPrepaidWithholding(TpmWithholdingDetailEntity entity, PrepaymentDetailsVo prepaymentVo) {
        return entity.getWithholdingYearMonth() + MD5Util.computeMD5((String)(entity.getWithholdingCategory() + "_" + prepaymentVo.getPrepaidCoding() + "_" + this.ifNull(entity.getActivityDetailCode())));
    }

    private String ifNull(String s) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        return s;
    }
}

