/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.businessunit.sdk.dto.MdmBusinessUnitDto;
import com.biz.crm.mdm.business.businessunit.sdk.service.MdmBusinessUnitVoService;
import com.biz.crm.mdm.business.businessunit.sdk.vo.MdmBusinessUnitVo;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.ICostCenterRelationVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.enums.WithholdingDetailSplitTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd187Service;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd121Vo;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmZmsd187Vo;
import com.biz.crm.tpm.business.withholding.detail.local.entity.TpmWithholdingDetailEntity;
import com.biz.crm.tpm.business.withholding.detail.local.mapper.TpmWithholdingDetailEntityMapper;
import com.biz.crm.tpm.business.withholding.detail.local.repository.TpmWithholdingDetailEntityRepository;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailActivityDetailPlanDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailAdjustDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailImportDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailLogDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailProtocolDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRefreshImportDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailSubmitDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailVerticalSplitDataDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.event.TpmWithholdingDetailLogEventListener;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailActivityDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailFormulaPartService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailPrepaymentDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailSubComActivityDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailActivityDetailPlanVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailSubmitSummaryRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailVerticalSplitDataRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailCostCenterUtil;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailVerticalFeeBalanceUtil;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.Assert;

@Service(value="tpmWithholdingDetailService")
public class TpmWithholdingDetailServiceImpl
extends MnPageCacheServiceImpl<TpmWithholdingDetailRespVo, TpmWithholdingDetailDto>
implements TpmWithholdingDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailServiceImpl.class);
    @Autowired(required=false)
    private TpmWithholdingDetailEntityMapper tpmWithholdingDetailEntityMapper;
    @Autowired(required=false)
    private TpmWithholdingDetailEntityRepository tpmWithholdingDetailEntityRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmWithholdingDetailActivityDetailPartService tpmWithholdingDetailActivityDetailPartService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private TpmWithholdingDetailLogEventListener tpmWithholdingDetailLogEventListener;
    @Autowired(required=false)
    private TpmWithholdingDetailSubComActivityDetailPartService tpmWithholdingDetailSubComActivityDetailPartService;
    @Autowired(required=false)
    private TpmWithholdingDetailPrepaymentDetailPartService tpmWithholdingDetailPrepaymentDetailPartService;
    @Autowired(required=false)
    private TpmWithholdingDetailFormulaPartService tpmWithholdingDetailFormulaPartService;
    @Autowired(required=false)
    private Zmsd187Service zmsd187Service;
    @Autowired(required=false)
    private Zmsd121Service zmsd121Service;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private MdmBusinessUnitVoService mdmBusinessUnitVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private TpmWithholdingDetailVerticalFeeBalanceUtil tpmWithholdingDetailVerticalFeeBalanceUtil;
    @Autowired(required=false)
    private TpmWithholdingDetailCostCenterUtil tpmWithholdingDetailCostCenterUtil;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private ICostCenterRelationVoService costCenterRelationVoService;
    @Autowired(required=false)
    private SalesPerformanceVoService salesPerformanceVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;

    public TpmWithholdingDetailRespVo queryById(String id) {
        TpmWithholdingDetailRespVo vo = this.tpmWithholdingDetailEntityMapper.queryByIdAndTenantCode(id, TenantUtils.getTenantCode());
        vo.setAfterAdjustAmountStr(vo.getAfterAdjustAmount().toString());
        return vo;
    }

    public Page<TpmWithholdingDetailRespVo> queryByPage(TpmWithholdingDetailDto tpmWithholdingDetail, Pageable pageable) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(tpmWithholdingDetail)) {
            tpmWithholdingDetail = new TpmWithholdingDetailDto();
        }
        tpmWithholdingDetail.setTerminalCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmWithholdingDetailEntityMapper.queryByPage((Page<TpmWithholdingDetailRespVo>)page, tpmWithholdingDetail);
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmWithholdingDetailRespVo insert(TpmWithholdingDetailDto tpmWithholdingDetail) {
        TpmWithholdingDetailEntity entity;
        if (!ObjectUtils.isNotEmpty((Object)tpmWithholdingDetail)) {
            throw new RuntimeException("\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String salesInstitutionCode = tpmWithholdingDetail.getSalesInstitutionCode();
        if (StringUtils.isNotEmpty((CharSequence)salesInstitutionCode)) {
            tpmWithholdingDetail.setSalesOrgCode(salesInstitutionCode);
            String salesRegionCode = tpmWithholdingDetail.getSalesRegionCode();
            if (StringUtils.isNotEmpty((CharSequence)salesRegionCode)) {
                tpmWithholdingDetail.setSalesOrgCode(salesRegionCode);
                String salesGroupCode = tpmWithholdingDetail.getSalesGroupCode();
                if (StringUtils.isNotEmpty((CharSequence)salesGroupCode)) {
                    tpmWithholdingDetail.setSalesOrgCode(salesGroupCode);
                }
            }
        }
        if (TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(tpmWithholdingDetail.getWithholdingCategory())) {
            TpmWithholdingDetailEntity entity2 = (TpmWithholdingDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmWithholdingDetail, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            this.generateSalesOrgInfo(entity2);
            entity2.setWithholdingDetailCode((String)this.generateCodeService.generateCode("YTMX", 1, Integer.valueOf(8), 32L, TimeUnit.DAYS).get(0));
            entity2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity2.setAfterAdjustAmount(entity2.getWithholdingAmount());
            entity2.setAdjustAmount(BigDecimal.ZERO);
            entity2.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity2.setWithholdingType(TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode());
            entity2.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode());
            entity2.setTenantCode(TenantUtils.getTenantCode());
            entity2.setUniqueMd5Key(entity2.generateUniqueMd5Key());
            if (this.tpmWithholdingDetailEntityMapper.findExistByUniqueKey(entity2.getUniqueMd5Key(), null) > 0) {
                throw new UnsupportedOperationException("\u5b58\u5728\u540c\u7eac\u5ea6\u9884\u63d0\u660e\u7ec6\u6570\u636e");
            }
            this.tpmWithholdingDetailEntityMapper.insert((Object)entity2);
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)tpmWithholdingDetail.getWithholdingCategory()) && !TpmWithholdingDetailCategoryEnum.MANUAL_WITHHOLDING.getCode().equals(tpmWithholdingDetail.getWithholdingCategory())) {
            throw new UnsupportedOperationException("\u624b\u5de5\u9884\u63d0\u65e0\u6cd5\u65b0\u589e\u9884\u63d0\u5206\u7c7b\u4e3a\u3010" + TpmWithholdingDetailCategoryEnum.codeToEnum((String)tpmWithholdingDetail.getWithholdingCategory()) + "\u3011\u7684\u9884\u63d0\u6570\u636e");
        }
        if (tpmWithholdingDetail.validate()) {
            TpmWithholdingDetailDto dto;
            Map<String, CostCenterRelationVo> costCenterMap;
            String code;
            List byOrgCode;
            String salesOrgCode;
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(tpmWithholdingDetail.getSalesOrgCode());
            if (salesOrgVo == null) {
                throw new UnsupportedOperationException("\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(tpmWithholdingDetail.getBusinessUnitCode()) && tpmWithholdingDetail.getNeedSplitFlag().booleanValue()) {
                if (CollectionUtils.isNotEmpty((Collection)tpmWithholdingDetail.getSplitDataDtoList())) {
                    AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
                    Date date = new Date();
                    ArrayList result = Lists.newArrayList();
                    for (TpmWithholdingDetailVerticalSplitDataDto splitDataDto : tpmWithholdingDetail.getSplitDataDtoList()) {
                        TpmWithholdingDetailEntity entity3 = (TpmWithholdingDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmWithholdingDetail, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                        entity3.setWithholdingDetailCode((String)this.generateCodeService.generateCode("YTMX", 1, Integer.valueOf(8), 32L, TimeUnit.DAYS).get(0));
                        entity3.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                        entity3.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        entity3.setWithholdingAmount(splitDataDto.getSplitAmount());
                        entity3.setAfterAdjustAmount(entity3.getWithholdingAmount());
                        entity3.setAdjustAmount(BigDecimal.ZERO);
                        entity3.setCostCenter(splitDataDto.getCostCenterCode());
                        entity3.setCostCenterName(splitDataDto.getCostCenterName());
                        entity3.setRegion(splitDataDto.getRegion());
                        entity3.setResaleCommercialCode(splitDataDto.getResaleCommercialCode());
                        entity3.setResaleCommercialName(splitDataDto.getResaleCommercialName());
                        entity3.setSalesOrgErpCode(salesOrgVo.getErpCode());
                        entity3.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
                        entity3.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
                        entity3.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                        entity3.setCreateAccount(userIdentity.getAccount());
                        entity3.setCreateName(userIdentity.getRealName());
                        entity3.setModifyAccount(userIdentity.getAccount());
                        entity3.setModifyName(userIdentity.getRealName());
                        entity3.setCreateTime(date);
                        entity3.setModifyTime(date);
                        entity3.setTenantCode(TenantUtils.getTenantCode());
                        entity3.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        entity3.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                        entity3.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                        entity3.setWithholdingType(TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode());
                        entity3.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.MANUAL_WITHHOLDING.getCode());
                        entity3.setTenantCode(TenantUtils.getTenantCode());
                        entity3.setUniqueMd5Key(entity3.generateUniqueMd5Key());
                        result.add(entity3);
                    }
                    this.tpmWithholdingDetailEntityMapper.insertList(result);
                }
                return null;
            }
            entity = (TpmWithholdingDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmWithholdingDetail, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            this.generateSalesOrgInfo(entity);
            entity.setWithholdingDetailCode((String)this.generateCodeService.generateCode("YTMX", 1, Integer.valueOf(8), 32L, TimeUnit.DAYS).get(0));
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setAfterAdjustAmount(entity.getWithholdingAmount());
            entity.setAdjustAmount(BigDecimal.ZERO);
            entity.setSalesOrgErpCode(salesOrgVo.getErpCode());
            entity.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
            entity.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
            if (StringUtils.isEmpty((CharSequence)tpmWithholdingDetail.getSalesRegionCode()) && StringUtils.isEmpty((CharSequence)tpmWithholdingDetail.getSalesGroupCode()) && BusinessUnitEnum.SON_COMPANY.getCode().equals(entity.getBusinessUnitCode()) && (salesOrgCode = entity.getSalesOrgCode()).length() >= 4 && CollectionUtils.isNotEmpty((Collection)(byOrgCode = this.salesOrgSubComOrgService.findByOrgCode(code = salesOrgCode.substring(salesOrgCode.length() - 4))))) {
                SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)byOrgCode.get(0);
                entity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                entity.setOrgName(salesOrgSubComOrgVo.getOrgName());
            }
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setWithholdingType(TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode());
            entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.MANUAL_WITHHOLDING.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            if (this.tpmWithholdingDetailEntityMapper.findExistByUniqueKey(entity.getUniqueMd5Key(), null) > 0) {
                throw new UnsupportedOperationException("\u5b58\u5728\u540c\u7eac\u5ea6\u9884\u63d0\u660e\u7ec6\u6570\u636e");
            }
            boolean useUuid = false;
            if (StringUtils.isEmpty((CharSequence)entity.getActivityDetailCode())) {
                entity.setActivityDetailCode(UUID.randomUUID().toString().replace("-", ""));
                useUuid = true;
            }
            if ((costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(Lists.newArrayList((Object[])new TpmWithholdingDetailDto[]{dto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmWithholdingDetailDto.class, HashSet.class, ArrayList.class, new String[0])}), null)).containsKey(entity.getActivityDetailCode())) {
                CostCenterRelationVo vo = costCenterMap.get(entity.getActivityDetailCode());
                entity.setCostCenter(vo.getCostCenterCode());
                entity.setCostCenterName(vo.getCostCenterName());
            }
            if (useUuid) {
                entity.setActivityDetailCode(null);
            }
        } else {
            throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e");
        }
        this.tpmWithholdingDetailEntityMapper.insert((Object)entity);
        return null;
    }

    private void generateSalesOrgInfo(TpmWithholdingDetailEntity entity) {
        SalesOrgVo salesOrgVo;
        String salesInstitutionCode = entity.getSalesInstitutionCode();
        if (StringUtils.isNotEmpty((CharSequence)salesInstitutionCode)) {
            entity.setSalesOrgCode(salesInstitutionCode);
            String salesRegionCode = entity.getSalesRegionCode();
            if (StringUtils.isNotEmpty((CharSequence)salesRegionCode)) {
                entity.setSalesOrgCode(salesRegionCode);
                String salesGroupCode = entity.getSalesGroupCode();
                if (StringUtils.isNotEmpty((CharSequence)salesGroupCode)) {
                    entity.setSalesOrgCode(salesGroupCode);
                }
            }
        }
        if ((salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(entity.getSalesOrgCode())) == null || StringUtils.isEmpty((CharSequence)salesOrgVo.getSalesInstitutionCode())) {
            throw new UnsupportedOperationException("\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        entity.setSalesOrgErpCode(salesOrgVo.getErpCode());
        entity.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
        entity.setSalesOrgName(salesOrgVo.getSalesOrgName());
        if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
            entity.setSalesGroupCode(salesOrgVo.getSalesOrgCode());
            entity.setSalesGroupErpCode(salesOrgVo.getErpCode());
            entity.setSalesRegionCode(salesOrgVo.getParentCode());
            entity.setSalesRegionErpCode(salesOrgVo.getParentErpCode());
        }
        if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
            entity.setSalesRegionCode(salesOrgVo.getSalesOrgCode());
            entity.setSalesRegionErpCode(salesOrgVo.getErpCode());
            entity.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
            entity.setSalesInstitutionErpCode(salesOrgVo.getParentErpCode());
        }
        entity.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
        String salesInstitutionCode1 = salesOrgVo.getSalesInstitutionCode();
        if (entity.getSalesInstitutionErpCode() == null && salesInstitutionCode1.length() >= 4) {
            entity.setSalesInstitutionErpCode(salesInstitutionCode1.substring(salesInstitutionCode1.length() - 4));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public TpmWithholdingDetailRespVo update(TpmWithholdingDetailDto tpmWithholdingDetail) {
        TpmWithholdingDetailDto dto;
        Map<String, CostCenterRelationVo> costCenterMap;
        TpmWithholdingDetailEntity entity;
        if (!StringUtils.isNotEmpty((CharSequence)tpmWithholdingDetail.getId())) throw new UnsupportedOperationException("\u7f3a\u5c11\u9884\u63d0\u660e\u7ec6\u4e3b\u952e");
        TpmWithholdingDetailEntity original = (TpmWithholdingDetailEntity)((Object)this.tpmWithholdingDetailEntityMapper.selectById((Serializable)((Object)tpmWithholdingDetail.getId())));
        if (ProcessStatusEnum.PASS.getDictCode().equals(original.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(original.getProcessStatus())) {
            throw new UnsupportedOperationException("\u6d41\u7a0b\u5904\u7406\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u6570\u636e\u4e0d\u53ef\u4fee\u6539");
        }
        if (TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode().equals(original.getWithholdingType())) {
            if (!tpmWithholdingDetail.validateForSystemUpdate()) throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e");
            entity = new TpmWithholdingDetailEntity();
            entity.setId(original.getId());
            entity.setAfterAdjustAmount(new BigDecimal(tpmWithholdingDetail.getAfterAdjustAmountStr()));
            entity.setAdjustAmount(entity.getAfterAdjustAmount().subtract(original.getWithholdingAmount()));
            entity.setAdjustReason(tpmWithholdingDetail.getAdjustReason());
        } else {
            if (!TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode().equals(original.getWithholdingType())) throw new UnsupportedOperationException("\u7f3a\u5c11\u9884\u63d0\u7c7b\u578b");
            if (tpmWithholdingDetail.validate()) {
                entity = (TpmWithholdingDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmWithholdingDetail, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                this.generateSalesOrgInfo(entity);
                entity.setAfterAdjustAmount(new BigDecimal(tpmWithholdingDetail.getAfterAdjustAmountStr()));
                entity.setAdjustAmount(entity.getAfterAdjustAmount().subtract(original.getWithholdingAmount()));
                entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            } else if (TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(tpmWithholdingDetail.getWithholdingCategory())) {
                entity = (TpmWithholdingDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)tpmWithholdingDetail, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                this.generateSalesOrgInfo(entity);
                entity.setAfterAdjustAmount(new BigDecimal(tpmWithholdingDetail.getAfterAdjustAmountStr()));
                entity.setAdjustAmount(entity.getAfterAdjustAmount().subtract(original.getWithholdingAmount()));
                entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            } else {
                if (!StringUtils.isNotEmpty((CharSequence)tpmWithholdingDetail.getWithholdingCategory()) || TpmWithholdingDetailCategoryEnum.MANUAL_WITHHOLDING.getCode().equals(tpmWithholdingDetail.getWithholdingCategory())) throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e");
                throw new UnsupportedOperationException("\u624b\u5de5\u9884\u63d0\u65e0\u6cd5\u65b0\u589e\u9884\u63d0\u5206\u7c7b\u4e3a\u3010" + TpmWithholdingDetailCategoryEnum.codeToEnum((String)tpmWithholdingDetail.getWithholdingCategory()) + "\u3011\u7684\u9884\u63d0\u6570\u636e");
            }
        }
        if (this.tpmWithholdingDetailEntityMapper.findExistByUniqueKey(entity.getUniqueMd5Key(), original.getId()) > 0) {
            throw new UnsupportedOperationException("\u5b58\u5728\u540c\u7eac\u5ea6\u9884\u63d0\u660e\u7ec6\u6570\u636e");
        }
        boolean useUuid = false;
        if (StringUtils.isEmpty((CharSequence)entity.getActivityDetailCode())) {
            entity.setActivityDetailCode(UUID.randomUUID().toString().replace("-", ""));
            useUuid = true;
        }
        if ((costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(Lists.newArrayList((Object[])new TpmWithholdingDetailDto[]{dto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmWithholdingDetailDto.class, HashSet.class, ArrayList.class, new String[0])}), null)).containsKey(entity.getActivityDetailCode())) {
            CostCenterRelationVo vo = costCenterMap.get(entity.getActivityDetailCode());
            entity.setCostCenter(vo.getCostCenterCode());
            entity.setCostCenterName(vo.getCostCenterName());
        }
        if (useUuid) {
            entity.setActivityDetailCode(null);
        }
        this.tpmWithholdingDetailEntityMapper.updateById((Object)entity);
        TpmWithholdingDetailLogDto logDto = new TpmWithholdingDetailLogDto();
        logDto.setOriginal((TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        logDto.setNewest((TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmWithholdingDetailLogEventListener.onUpdate(logDto);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> ids) {
        this.tpmWithholdingDetailEntityMapper.deleteByIds(ids, TenantUtils.getTenantCode());
        for (String id : ids) {
            TpmWithholdingDetailEntity original = (TpmWithholdingDetailEntity)((Object)this.tpmWithholdingDetailEntityMapper.selectById((Serializable)((Object)id)));
            TpmWithholdingDetailDto originalDto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            original.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            TpmWithholdingDetailDto newestDto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmWithholdingDetailLogDto logDto = new TpmWithholdingDetailLogDto();
            logDto.setNewest(newestDto);
            logDto.setOriginal(originalDto);
            this.tpmWithholdingDetailLogEventListener.onDelete(logDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> ids) {
        this.tpmWithholdingDetailEntityMapper.enable(ids, TenantUtils.getTenantCode());
        for (String id : ids) {
            TpmWithholdingDetailEntity original = (TpmWithholdingDetailEntity)((Object)this.tpmWithholdingDetailEntityMapper.selectById((Serializable)((Object)id)));
            TpmWithholdingDetailDto originalDto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmWithholdingDetailLogDto logDto = new TpmWithholdingDetailLogDto();
            logDto.setOriginal(originalDto);
            this.tpmWithholdingDetailLogEventListener.onEnable(logDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> ids) {
        this.tpmWithholdingDetailEntityMapper.disable(ids, TenantUtils.getTenantCode());
        for (String id : ids) {
            TpmWithholdingDetailEntity original = (TpmWithholdingDetailEntity)((Object)this.tpmWithholdingDetailEntityMapper.selectById((Serializable)((Object)id)));
            TpmWithholdingDetailDto originalDto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmWithholdingDetailLogDto logDto = new TpmWithholdingDetailLogDto();
            logDto.setOriginal(originalDto);
            this.tpmWithholdingDetailLogEventListener.onEnable(logDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitAndSetPass(List<String> ids) {
        this.tpmWithholdingDetailEntityMapper.submitAndSetPass(ids);
    }

    public String redoWithholding(TpmWithholdingDetailRedoWithholdingDto dto) {
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        String lock = "withholding:detail:redo:category:user:" + dto.getWithholdingType() + "_" + loginUser.getAccount();
        boolean lockSuccess = this.redisLockService.tryLock(lock, TimeUnit.SECONDS, 300L, 10L);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            Calendar calendar;
            Date date;
            if (TpmWithholdingDetailCategoryEnum.ACTIVITY_WITHHOLDING.getCode().equals(dto.getWithholdingType()) && BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u5bf9\u4e1a\u52a1\u5355\u5143\u4e3a\u4e3b\u4f53\u7684\u6570\u636e\u505a\u6d3b\u52a8\u9884\u63d0");
            }
            if (StringUtils.isNotEmpty((CharSequence)dto.getWithholdingYearMonth())) {
                date = DateUtil.parse((String)(dto.getWithholdingYearMonth() + "-01"), (String)"yyyy-MM-dd");
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(2, 1);
                dto.setEndDate(DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd"));
            } else if (StringUtils.isNotEmpty((CharSequence)dto.getStartYearMonth())) {
                dto.setStartDate(dto.getStartYearMonth() + "-01");
            } else if (StringUtils.isNotEmpty((CharSequence)dto.getEndYearMonth())) {
                date = DateUtil.parse((String)(dto.getEndYearMonth() + "-01"), (String)"yyyy-MM-dd");
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(2, 1);
                dto.setEndDate(DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd"));
                dto.setWithholdingYearMonth(dto.getEndYearMonth());
            } else {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.set(5, 1);
                dto.setEndDate(DateUtil.format((Date)calendar2.getTime(), (String)"yyyy-MM-dd"));
                dto.setWithholdingYearMonth(DateUtil.format((Date)calendar2.getTime(), (String)"yyyy-MM"));
            }
            if (TpmWithholdingDetailCategoryEnum.ACTIVITY_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
                if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
                    this.tpmWithholdingDetailSubComActivityDetailPartService.redoWithholding(dto);
                } else {
                    this.tpmWithholdingDetailActivityDetailPartService.redoWithholding(dto);
                }
            }
            if (TpmWithholdingDetailCategoryEnum.ONLINE_RETAILERS_WITHHOLDING.getCode().equals(dto.getWithholdingType()) || TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(dto.getWithholdingType()) || TpmWithholdingDetailCategoryEnum.VERTICAL_RECEIVABLE_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
                this.tpmWithholdingDetailFormulaPartService.redoWithholding(dto);
            }
            if (TpmWithholdingDetailCategoryEnum.FEE_POOL_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
                String ds;
                FacturerUserDetails userDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
                if (StringUtils.isNotEmpty((CharSequence)dto.getWithholdingYearMonth())) {
                    Date withholdingYearMonth = DateUtil.parse((String)(dto.getWithholdingYearMonth() + "-01"), (String)"yyyy-MM-dd");
                    withholdingYearMonth = DateUtil.dateAddMonth((Date)withholdingYearMonth, (Integer)1);
                    ds = DateUtil.format((Date)withholdingYearMonth, (String)"yyyyMMdd");
                } else {
                    ds = DateUtil.format((Date)new Date(), (String)"yyyyMM") + "01";
                    dto.setWithholdingYearMonth(DateUtil.format((Date)DateUtil.dateAddMonth((Date)new Date(), (Integer)-1), (String)"yyyy-MM"));
                }
                this.saveFeePoolWithholding(ds, JSON.parseObject((String)JSON.toJSONString((Object)userDetails)), dto);
            }
            if (TpmWithholdingDetailCategoryEnum.PRE_PAY_WITHHOLDING.getCode().equals(dto.getWithholdingType())) {
                this.tpmWithholdingDetailPrepaymentDetailPartService.redoWithholding(dto);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
        finally {
            if (lockSuccess) {
                log.info("\u7cfb\u7edf\u9884\u63d0\u9501\u91ca\u653e\uff01");
                this.redisLockService.unlock(lock);
            }
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }

    public String systemWithholding() {
        this.tpmWithholdingDetailActivityDetailPartService.systemWithholding();
        this.tpmWithholdingDetailSubComActivityDetailPartService.systemWithholding();
        this.tpmWithholdingDetailFormulaPartService.systemWithholding();
        this.tpmWithholdingDetailPrepaymentDetailPartService.systemWithholding();
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> saveImport(LinkedHashMap<Integer, TpmWithholdingDetailImportDto> data) {
        List supplierVos;
        Map resaleMap;
        List productList;
        List activityTypeList;
        List activityFormList;
        List terminalList;
        List salesOrgVoList;
        List customerVoList;
        List channelList;
        List budgetItemVoList;
        HashMap<Integer, List> errListMap = new HashMap<Integer, List>();
        ArrayList<TpmWithholdingDetailImportDto> importDtoList = new ArrayList<TpmWithholdingDetailImportDto>(data.values());
        for (Integer key : data.keySet()) {
            TpmWithholdingDetailImportDto dto = data.get(key);
            String salesInstitutionCode = dto.getSalesInstitutionCode();
            if (StringUtils.isNotEmpty((CharSequence)salesInstitutionCode)) {
                dto.setSalesOrgCode(salesInstitutionCode);
                String salesRegionCode = dto.getSalesRegionCode();
                if (StringUtils.isNotEmpty((CharSequence)salesRegionCode)) {
                    dto.setSalesOrgCode(salesRegionCode);
                    String salesGroupCode = dto.getSalesGroupCode();
                    if (StringUtils.isNotEmpty((CharSequence)salesGroupCode)) {
                        dto.setSalesOrgCode(salesGroupCode);
                    }
                }
            }
            if (dto.validate()) continue;
            if (CollectionUtils.isEmpty((Collection)((Collection)errListMap.get(key)))) {
                errListMap.put(key, new ArrayList());
            }
            ((List)errListMap.get(key)).add("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
        }
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        Set<Integer> keySet = data.keySet();
        Date date = new Date();
        ArrayList<TpmWithholdingDetailEntity> entityList = new ArrayList<TpmWithholdingDetailEntity>();
        List withholdingCodeList = this.generateCodeService.generateCode("YTMX", importDtoList.size());
        HashMap budgetItemVoMap = new HashMap();
        List budgetSubjectCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getBudgetSubjectCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(budgetSubjectCodeList) && CollectionUtils.isNotEmpty((Collection)(budgetItemVoList = this.budgetItemService.findByCodes(budgetSubjectCodeList)))) {
            budgetItemVoMap.putAll(budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity())));
        }
        HashMap channelVoMap = new HashMap();
        List channelCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getChannelCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(channelCodeList) && CollectionUtils.isNotEmpty((Collection)(channelList = this.customerChannelVoService.findByCodes(channelCodeList)))) {
            channelVoMap.putAll(channelList.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity())));
            log.info("TPM\u9884\u63d0\u660e\u7ec6\u5bfc\u5165\u6570\u636e:\u67e5\u8be2\u6e20\u9053\u6570\u636e{}", (Object)JSON.toJSONString(channelVoMap));
        }
        HashMap customerMap = new HashMap();
        List customerCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getCustomerCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(customerCodeList) && CollectionUtils.isNotEmpty((Collection)(customerVoList = this.customerVoService.findByErpCodeList(customerCodeList)))) {
            customerMap.putAll(customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity())));
        }
        ArrayList<String> salesOrgCodeList = new ArrayList<String>();
        int i = 0;
        for (TpmWithholdingDetailImportDto importDto : importDtoList) {
            ++i;
            String businessFormatCode = BusinessFormatEnum.descToEnum((String)importDto.getBusinessFormatName()).getCode();
            if (!StringUtils.isNotEmpty((CharSequence)importDto.getSalesInstitutionCode())) continue;
            if (StringUtils.isBlank((CharSequence)importDto.getChannelCode())) {
                if (CollectionUtils.isEmpty((Collection)((Collection)errListMap.get(i)))) {
                    errListMap.put(i, new ArrayList());
                }
                ((List)errListMap.get(i)).add("\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            String insCode = importDto.getChannelCode() + businessFormatCode + importDto.getSalesInstitutionCode();
            salesOrgCodeList.add(insCode);
            if (!StringUtils.isNotBlank((CharSequence)importDto.getSalesRegionCode())) continue;
            String regionCode = insCode + importDto.getSalesRegionCode();
            salesOrgCodeList.add(regionCode);
            if (!StringUtils.isNotBlank((CharSequence)importDto.getSalesOrgCode())) continue;
            String salesOrgCode = regionCode + importDto.getSalesOrgCode();
            salesOrgCodeList.add(salesOrgCode);
        }
        HashMap salesOrgMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesOrgCodeList) && CollectionUtils.isNotEmpty((Collection)(salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodeList)))) {
            salesOrgMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity())));
        }
        HashMap terminalMap = new HashMap();
        List terminalCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getTerminalCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(terminalCodeList) && CollectionUtils.isNotEmpty((Collection)(terminalList = this.terminalVoService.findTerminalAndContactByTerminalCodes(terminalCodeList)))) {
            terminalMap.putAll(terminalList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }
        HashMap activityFormMap = new HashMap();
        List activityFormCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(activityFormCodeList) && CollectionUtils.isNotEmpty((Collection)(activityFormList = this.activityFormService.findByCodes(activityFormCodeList)))) {
            activityFormMap.putAll(activityFormList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity())));
        }
        HashMap activityTypeMap = new HashMap();
        List activityTypeCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getActivityTypeCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(activityTypeCodeList) && CollectionUtils.isNotEmpty((Collection)(activityTypeList = this.activityTypeService.findByCodes(activityTypeCodeList)))) {
            activityTypeMap.putAll(activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, Function.identity())));
        }
        HashMap productMap = new HashMap();
        List productCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(productCodeList) && CollectionUtils.isNotEmpty((Collection)(productList = this.productVoService.findByProductCodes(productCodeList)))) {
            productMap.putAll(productList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
        }
        Map retailerMap = new HashMap();
        List resaleCommercialCodeList = importDtoList.stream().map(TpmWithholdingDetailImportDto::getResaleCommercialCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(resaleCommercialCodeList) && (resaleMap = this.customerRetailerVoService.getRetailerByCodes(resaleCommercialCodeList)) != null) {
            retailerMap = resaleMap;
        }
        HashMap supplierVoMap = new HashMap();
        List supplyCodes = importDtoList.stream().map(TpmWithholdingDetailImportDto::getSupplierCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(supplyCodes) && CollectionUtils.isNotEmpty((Collection)(supplierVos = this.supplierVoService.findBySupplierCodes(supplyCodes)))) {
            supplierVoMap.putAll(supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity())));
        }
        int counter = 0;
        for (Integer key : keySet) {
            if (CollectionUtils.isEmpty((Collection)((Collection)errListMap.get(key)))) {
                errListMap.put(key, new ArrayList());
            }
            try {
                TpmWithholdingDetailImportDto importDto = data.get(key);
                TpmWithholdingDetailEntity withholdingDetailEntity = (TpmWithholdingDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)importDto, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                withholdingDetailEntity.setWithholdingAmount(new BigDecimal(importDto.getWithholdingAmountStr()));
                withholdingDetailEntity.setAdjustAmount(BigDecimal.ZERO);
                withholdingDetailEntity.setAfterAdjustAmount(withholdingDetailEntity.getWithholdingAmount());
                String businessFormatCode = BusinessFormatEnum.descToEnum((String)importDto.getBusinessFormatName()).getCode();
                withholdingDetailEntity.setBusinessFormatCode(businessFormatCode);
                withholdingDetailEntity.setBusinessUnitCode(BusinessUnitEnum.descToEnum((String)importDto.getBusinessUnitName()).getCode());
                withholdingDetailEntity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.descToEnum((String)importDto.getWithholdingTarget()).getCode());
                SalesOrgVo salesInstitutionOrgVo = null;
                if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesOrgCode())) {
                    String insCode = importDto.getChannelCode() + businessFormatCode + importDto.getSalesInstitutionCode();
                    salesInstitutionOrgVo = (SalesOrgVo)salesOrgMap.get(insCode);
                    if (salesInstitutionOrgVo == null) {
                        ((List)errListMap.get(key)).add("\u6240\u5c5e\u9500\u552e\u673a\u6784\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setSalesOrgErpCode(salesInstitutionOrgVo.getErpCode());
                        withholdingDetailEntity.setSalesOrgCode(salesInstitutionOrgVo.getSalesOrgCode());
                        withholdingDetailEntity.setSalesOrgName(salesInstitutionOrgVo.getSalesOrgName());
                        withholdingDetailEntity.setSalesOrgLevel(salesInstitutionOrgVo.getSalesOrgLevel());
                        withholdingDetailEntity.setSalesInstitutionCode(salesInstitutionOrgVo.getSalesOrgCode());
                        withholdingDetailEntity.setSalesInstitutionErpCode(salesInstitutionOrgVo.getErpCode());
                        if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesRegionCode())) {
                            String regionCode = insCode + importDto.getSalesRegionCode();
                            SalesOrgVo salesRegionOrgVo = (SalesOrgVo)salesOrgMap.get(regionCode);
                            if (salesRegionOrgVo == null) {
                                String code;
                                List byOrgCode;
                                String salesOrgCode;
                                if (BusinessUnitEnum.SON_COMPANY.getCode().equals(withholdingDetailEntity.getBusinessUnitCode()) && (salesOrgCode = withholdingDetailEntity.getSalesOrgCode()).length() >= 4 && CollectionUtils.isNotEmpty((Collection)(byOrgCode = this.salesOrgSubComOrgService.findByOrgCode(code = salesOrgCode.substring(salesOrgCode.length() - 4))))) {
                                    SalesOrgSubComOrgVo salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)byOrgCode.get(0);
                                    withholdingDetailEntity.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                                    withholdingDetailEntity.setOrgName(salesOrgSubComOrgVo.getOrgName());
                                }
                            } else {
                                String groupOrgCode;
                                SalesOrgVo salesGroupOrgVo;
                                withholdingDetailEntity.setSalesOrgErpCode(salesRegionOrgVo.getErpCode());
                                withholdingDetailEntity.setSalesOrgCode(salesRegionOrgVo.getSalesOrgCode());
                                withholdingDetailEntity.setSalesOrgName(salesRegionOrgVo.getSalesOrgName());
                                withholdingDetailEntity.setSalesOrgLevel(salesRegionOrgVo.getSalesOrgLevel());
                                withholdingDetailEntity.setSalesRegionCode(salesRegionOrgVo.getSalesOrgCode());
                                withholdingDetailEntity.setSalesRegionErpCode(salesRegionOrgVo.getErpCode());
                                if (StringUtils.isNotEmpty((CharSequence)importDto.getSalesOrgCode()) && (salesGroupOrgVo = (SalesOrgVo)salesOrgMap.get(groupOrgCode = regionCode + importDto.getSalesGroupCode())) != null) {
                                    withholdingDetailEntity.setSalesOrgErpCode(salesGroupOrgVo.getErpCode());
                                    withholdingDetailEntity.setSalesOrgCode(salesGroupOrgVo.getSalesOrgCode());
                                    withholdingDetailEntity.setSalesOrgName(salesGroupOrgVo.getSalesOrgName());
                                    withholdingDetailEntity.setSalesOrgLevel(salesGroupOrgVo.getSalesOrgLevel());
                                    withholdingDetailEntity.setSalesGroupCode(salesGroupOrgVo.getSalesOrgCode());
                                    withholdingDetailEntity.setSalesGroupErpCode(salesGroupOrgVo.getErpCode());
                                }
                            }
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getCustomerCode()) && salesInstitutionOrgVo != null) {
                    String customerCode = importDto.getCustomerCode() + salesInstitutionOrgVo.getErpCode() + importDto.getChannelCode() + businessFormatCode;
                    CustomerVo customerVo = (CustomerVo)customerMap.get(customerCode);
                    if (customerVo == null) {
                        ((List)errListMap.get(key)).add("\u5ba2\u6237\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setCustomerName(customerVo.getCustomerName());
                        withholdingDetailEntity.setCustomerErpCode(customerVo.getErpCode());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getChannelCode())) {
                    CustomerChannelVo customerChannelVo = (CustomerChannelVo)channelVoMap.get(importDto.getChannelCode());
                    log.info("TPM\u9884\u63d0\u660e\u7ec6\u5bfc\u5165\u6570\u636e:\u5355\u4e2a\u6e20\u9053\u6570\u636e{}", (Object)JSON.toJSONString((Object)customerChannelVo));
                    if (customerChannelVo == null) {
                        ((List)errListMap.get(key)).add("\u6e20\u9053\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setChannelName(customerChannelVo.getCustomerChannelName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getTerminalCode())) {
                    TerminalVo terminal = (TerminalVo)terminalMap.get(importDto.getTerminalCode());
                    if (terminal == null) {
                        ((List)errListMap.get(key)).add("\u95e8\u5e97\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setTerminalName(terminal.getTerminalName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getActivityFormCode())) {
                    ActivityFormVo activityForm = (ActivityFormVo)activityFormMap.get(importDto.getActivityFormCode());
                    if (activityForm == null) {
                        ((List)errListMap.get(key)).add("\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setActivityFormName(activityForm.getActivityFormName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getActivityTypeCode())) {
                    ActivityTypeVo activityType = (ActivityTypeVo)activityTypeMap.get(importDto.getActivityTypeCode());
                    if (activityType == null) {
                        ((List)errListMap.get(key)).add("\u6d3b\u52a8\u7c7b\u578b\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setActivityTypeName(activityType.getActivityTypeName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getProductCode())) {
                    ProductVo product = (ProductVo)productMap.get(importDto.getProductCode());
                    if (product == null) {
                        ((List)errListMap.get(key)).add("\u4ea7\u54c1\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setProductName(product.getProductName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getResaleCommercialCode())) {
                    String resaleCommercialName = (String)retailerMap.get(importDto.getResaleCommercialCode());
                    if (resaleCommercialName == null) {
                        ((List)errListMap.get(key)).add("\u96f6\u552e\u5546\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setResaleCommercialName(resaleCommercialName);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getSupplierCode())) {
                    SupplierVo supplierVo = (SupplierVo)supplierVoMap.get(importDto.getSupplierCode());
                    if (supplierVo == null) {
                        ((List)errListMap.get(key)).add("\u4f9b\u5e94\u5546\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setSupplierName(supplierVo.getSupplierName());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importDto.getBudgetSubjectCode())) {
                    BudgetItemVo budgetItemVo = (BudgetItemVo)budgetItemVoMap.get(importDto.getBudgetSubjectCode());
                    if (budgetItemVo == null) {
                        ((List)errListMap.get(key)).add("\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u6570\u636e\u4e0d\u5b58\u5728");
                    } else {
                        withholdingDetailEntity.setBudgetSubjectName(budgetItemVo.getBudgetItemName());
                    }
                }
                withholdingDetailEntity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                withholdingDetailEntity.setWithholdingDetailCode((String)withholdingCodeList.get(counter++));
                withholdingDetailEntity.setCreateAccount(loginDetails.getUsername());
                withholdingDetailEntity.setCreateName(loginDetails.getRealName());
                withholdingDetailEntity.setModifyAccount(loginDetails.getUsername());
                withholdingDetailEntity.setModifyName(loginDetails.getRealName());
                withholdingDetailEntity.setCreateTime(date);
                withholdingDetailEntity.setModifyTime(date);
                withholdingDetailEntity.setTenantCode(TenantUtils.getTenantCode());
                withholdingDetailEntity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                withholdingDetailEntity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.MANUAL_WITHHOLDING.getCode());
                withholdingDetailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                withholdingDetailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                withholdingDetailEntity.setWithholdingType(TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode());
                withholdingDetailEntity.setUniqueMd5Key(withholdingDetailEntity.generateUniqueMd5Key());
                entityList.add(withholdingDetailEntity);
                try {
                    this.tpmWithholdingDetailEntityMapper.insert((Object)withholdingDetailEntity);
                }
                catch (Exception e) {
                    ((List)errListMap.get(key)).add("\u6570\u636e\u63d2\u5165\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u552f\u4e00");
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        errListMap.forEach((k, v) -> {
            if (v.size() > 0) {
                errMap.put((Integer)k, String.join((CharSequence)",", v));
            }
        });
        if (errMap.size() > 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return errMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveImport(List<TpmWithholdingDetailDto> data) {
        Integer count = this.tpmWithholdingDetailEntityRepository.findUniqueKey(data.get(0).getUniqueKeyDsList());
        Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e", (Object[])new Object[0]);
        List entities = (List)this.nebulaToolkitService.copyCollectionByWhiteList(data, TpmWithholdingDetailDto.class, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List withholdingCodeList = this.generateCodeService.generateCode("YTMX", entities.size());
        for (int i = 0; i < entities.size(); ++i) {
            ((TpmWithholdingDetailEntity)((Object)entities.get(i))).setWithholdingDetailCode((String)withholdingCodeList.get(i));
        }
        this.tpmWithholdingDetailEntityRepository.saveBatch(entities);
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> saveRefreshImport(LinkedHashMap<Integer, TpmWithholdingDetailRefreshImportDto> data) {
        HashMap<Integer, List> errListMap = new HashMap<Integer, List>();
        data.forEach((k, v) -> {
            if (!v.validate()) {
                if (CollectionUtils.isEmpty((Collection)((Collection)errListMap.get(k)))) {
                    errListMap.put((Integer)k, new ArrayList());
                }
                ((List)errListMap.get(k)).add("\u7f3a\u5c11\u5fc5\u586b\u6570\u636e");
            }
        });
        ArrayList currentPage = new ArrayList();
        data.forEach((k, v) -> {
            if (CollectionUtils.isEmpty((Collection)((Collection)errListMap.get(k)))) {
                errListMap.put((Integer)k, new ArrayList());
            }
            currentPage.add(v);
            if (k != 0 && k % 499 == 0 || k + 1 == data.size()) {
                List<String> withholdingDetailCodeList = currentPage.stream().map(TpmWithholdingDetailRefreshImportDto::getWithholdingDetailCode).filter(Objects::nonNull).collect(Collectors.toList());
                List<TpmWithholdingDetailEntity> entityList = this.tpmWithholdingDetailEntityMapper.findByWithholdingDetailCodeList(withholdingDetailCodeList, TenantUtils.getTenantCode());
                ArrayList<TpmWithholdingDetailEntity> resultEntityList = new ArrayList<TpmWithholdingDetailEntity>();
                for (TpmWithholdingDetailRefreshImportDto dto : currentPage) {
                    Optional<TpmWithholdingDetailEntity> optionalEntity = entityList.stream().filter(o -> dto.getWithholdingDetailCode().equals(o.getWithholdingDetailCode())).findAny();
                    if (optionalEntity.isPresent()) {
                        TpmWithholdingDetailEntity original = optionalEntity.get();
                        if (ProcessStatusEnum.PASS.getDictCode().equals(original.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(original.getProcessStatus())) {
                            ((List)errListMap.get(k)).add("\u6d41\u7a0b\u5904\u7406\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u6570\u636e\u4e0d\u53ef\u4fee\u6539");
                            continue;
                        }
                        TpmWithholdingDetailEntity newEntity = new TpmWithholdingDetailEntity();
                        newEntity.setId(original.getId());
                        newEntity.setAfterAdjustAmount(new BigDecimal(dto.getAfterAdjustAmountStr()));
                        newEntity.setAdjustAmount(newEntity.getAfterAdjustAmount().subtract(original.getWithholdingAmount()));
                        newEntity.setAdjustReason(dto.getAdjustReason());
                        resultEntityList.add(newEntity);
                        continue;
                    }
                    ((List)errListMap.get(k)).add("\u9884\u63d0\u7f16\u7801\u4e0d\u5b58\u5728\u5339\u914d\u6570\u636e");
                }
                this.tpmWithholdingDetailEntityRepository.updateBatchById(resultEntityList);
            }
        });
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        errListMap.forEach((k, v) -> {
            if (v.size() > 0) {
                errMap.put((Integer)k, String.join((CharSequence)",", v));
            }
        });
        if (errMap.size() > 0) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return errMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(TpmWithholdingDetailSubmitDto submitDto) {
        Validate.isTrue((boolean)Objects.nonNull(submitDto.getProcessBusiness()), (String)"\u6d41\u7a0b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entityList = this.tpmWithholdingDetailEntityMapper.selectBatchIds(submitDto.getIds());
        Validate.notNull((Object)entityList, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9884\u63d0\u660e\u7ec6", (Object[])new Object[0]);
        boolean hasProcessData = entityList.stream().anyMatch(o -> ProcessStatusEnum.COMMIT.getDictCode().equals(o.getProcessStatus()) || ProcessStatusEnum.PASS.getDictCode().equals(o.getProcessStatus()));
        if (hasProcessData) {
            throw new UnsupportedOperationException("\u5b58\u5728\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        ProcessBusinessDto processBusiness = submitDto.getProcessBusiness();
        processBusiness.setBusinessNo(UUID.randomUUID().toString().replaceAll("-", ""));
        processBusiness.setBusinessNoList(entityList.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        processBusiness.setBusinessCode("withholding_detail_process");
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)submitDto);
        processBusiness.setBusinessFormJson(jsonObject.toJSONString());
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        ArrayList<TpmWithholdingDetailEntity> changeProcessStatusEntityList = new ArrayList<TpmWithholdingDetailEntity>();
        for (TpmWithholdingDetailEntity entity : entityList) {
            TpmWithholdingDetailEntity changeProcessStatusEntity = new TpmWithholdingDetailEntity();
            changeProcessStatusEntity.setId(entity.getId());
            changeProcessStatusEntity.setProcessNo(processBusinessVo.getProcessNo());
            changeProcessStatusEntity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            changeProcessStatusEntityList.add(changeProcessStatusEntity);
        }
        this.tpmWithholdingDetailEntityRepository.updateBatchById(changeProcessStatusEntityList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertList(List<TpmWithholdingDetailDto> dtoList) {
        ArrayList<TpmWithholdingDetailEntity> entityList = new ArrayList<TpmWithholdingDetailEntity>(this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, TpmWithholdingDetailDto.class, TpmWithholdingDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmWithholdingDetailEntityMapper.insertList(entityList);
    }

    public TpmWithholdingDetailSubmitSummaryRespVo summaryForSubmit(List<String> ids) {
        Optional<MdmBusinessUnitVo> unitOptional;
        TpmWithholdingDetailSubmitSummaryRespVo result = new TpmWithholdingDetailSubmitSummaryRespVo();
        this.initSummary(result);
        result.setIdList(ids);
        HashMap<String, BigDecimal> eachTypeAmountMap = new HashMap<String, BigDecimal>();
        int pageNum = 0;
        int pageSize = 500;
        while (pageNum * pageSize < ids.size()) {
            List<String> currentPage = pageNum * pageSize + pageSize >= ids.size() ? ids.subList(pageNum * pageSize, ids.size()) : ids.subList(pageNum * pageSize, pageNum * pageSize + pageSize);
            List<TpmWithholdingDetailRespVo> withholdingDetailList = this.tpmWithholdingDetailEntityMapper.findByIdList(currentPage);
            if (pageNum == 0) {
                TpmWithholdingDetailRespVo template = withholdingDetailList.get(0);
                result.setBusinessFormatCode(template.getBusinessFormatCode());
                result.setBusinessUnitCode(template.getBusinessUnitCode());
                result.setWithholdingYearMonth(template.getWithholdingYearMonth());
                result.setSalesOrgName(template.getSalesOrgName());
                result.setSalesOrgCode(template.getSalesOrgCode());
            }
            for (TpmWithholdingDetailRespVo respVo : withholdingDetailList) {
                String type;
                if (TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode().equals(respVo.getWithholdingType())) {
                    if (TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                        result.setUnHandledAmount(result.getUnHandledAmount().add(respVo.getAfterAdjustAmount()));
                    } else {
                        result.setOtherAmount(result.getOtherAmount().add(respVo.getAfterAdjustAmount()));
                    }
                } else if (TpmWithholdingDetailCategoryEnum.ACTIVITY_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                    if (TpmWithholdingDetailTargetEnum.UPWARD.getCode().equals(respVo.getWithholdingTarget())) {
                        result.setBaseUnHandledAmount(result.getBaseUnHandledAmount().add(respVo.getAfterAdjustAmount().multiply(new BigDecimal(-1))));
                    } else {
                        result.setUnHandledAmount(result.getUnHandledAmount().add(respVo.getAfterAdjustAmount()));
                    }
                } else if (TpmWithholdingDetailCategoryEnum.FEE_POOL_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                    if (TpmWithholdingDetailTargetEnum.UPWARD.getCode().equals(respVo.getWithholdingTarget())) {
                        result.setBaseHandledUnDiscountAmount(result.getBaseHandledUnDiscountAmount().add(respVo.getAfterAdjustAmount().multiply(new BigDecimal(-1))));
                    } else {
                        result.setHandledUnDiscountAmount(result.getHandledUnDiscountAmount().add(respVo.getAfterAdjustAmount()));
                    }
                } else if (TpmWithholdingDetailCategoryEnum.PRE_PAY_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                    if (TpmWithholdingDetailTargetEnum.UPWARD.getCode().equals(respVo.getWithholdingTarget())) {
                        result.setBaseUnHandledAmount(result.getBaseUnHandledAmount().add(respVo.getAfterAdjustAmount()));
                    } else {
                        result.setUnHandledAmount(result.getUnHandledAmount().add(respVo.getAfterAdjustAmount().multiply(new BigDecimal(-1))));
                    }
                } else {
                    result.setUnHandledAmount(result.getUnHandledAmount().add(respVo.getAfterAdjustAmount()));
                }
                if (TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                    type = "\u9884\u63d0\u89c4\u5219\u7c7b\u578b=\u5927\u65e5\u671f\u9884\u63d0";
                } else if (TpmWithholdingDetailCategoryEnum.VERTICAL_RECEIVABLE_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                    type = "\u9884\u63d0\u89c4\u5219\u7c7b\u578b=\u5e94\u6536\u8ba1\u63d0\u5229\u606f";
                } else {
                    String string = type = respVo.getActivityTypeName() == null ? "" : respVo.getActivityTypeName();
                }
                if (TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode().equals(respVo.getWithholdingType()) && !TpmWithholdingDetailCategoryEnum.FEE_POOL_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) {
                    if (eachTypeAmountMap.containsKey(type)) {
                        eachTypeAmountMap.put(type, ((BigDecimal)eachTypeAmountMap.get(type)).add(respVo.getAfterAdjustAmount()));
                    } else {
                        eachTypeAmountMap.put(type, respVo.getAfterAdjustAmount());
                    }
                }
                if (!TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode().equals(respVo.getWithholdingType()) || !TpmWithholdingDetailCategoryEnum.LARGE_DATE_WITHHOLDING.getCode().equals(respVo.getWithholdingCategory())) continue;
                if (eachTypeAmountMap.containsKey(type)) {
                    eachTypeAmountMap.put(type, ((BigDecimal)eachTypeAmountMap.get(type)).add(respVo.getAfterAdjustAmount()));
                    continue;
                }
                eachTypeAmountMap.put(type, respVo.getAfterAdjustAmount());
            }
            ++pageNum;
        }
        PageRequest pageable = PageRequest.of((int)1, (int)50);
        MdmBusinessUnitDto unitDto = new MdmBusinessUnitDto();
        Page unitPage = this.mdmBusinessUnitVoService.findByConditions((Pageable)pageable, unitDto);
        BigDecimal taxRatio = BigDecimal.ONE;
        if (CollectionUtils.isNotEmpty((Collection)unitPage.getRecords()) && (unitOptional = unitPage.getRecords().stream().filter(o -> o.getBusinessUnitCode().equals(result.getBusinessUnitCode())).findAny()).isPresent() && Objects.nonNull(unitOptional.get().getTaxRatio())) {
            taxRatio = unitOptional.get().getTaxRatio();
        }
        result.setEachTypeAmountMap(eachTypeAmountMap);
        result.setBaseUnClearAmount(result.getBaseHandledUnDiscountAmount().add(result.getBaseUnHandledAmount()));
        result.setUnClearAmount(result.getOtherAmount().add(result.getBaseUnClearAmount()).add(result.getUnHandledAmount()));
        if (Objects.nonNull(taxRatio) && BigDecimal.ZERO.compareTo(taxRatio) != 0) {
            result.setWithholdingAmountSummaryExcludeTax(result.getUnClearAmount().subtract(result.getBaseUnClearAmount()).divide(taxRatio, 2, 4));
        }
        return result;
    }

    public void saveFeePoolWithholding(String ds, JSONObject userJsonObject, TpmWithholdingDetailRedoWithholdingDto dto) {
        if (dto == null) {
            return;
        }
        CustomerVo customerReqVo = null;
        SalesOrgVo salesOrgReqVo = null;
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) && (customerReqVo = this.customerVoService.findDetailsByIdOrCode(null, dto.getCustomerCode())) == null) {
            throw new UnsupportedOperationException("\u5ba2\u6237\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode()) && (salesOrgReqVo = this.salesOrgVoService.findBySalesOrgCode(dto.getSalesOrgCode())) == null) {
            throw new UnsupportedOperationException("\u9500\u552e\u7ec4\u7ec7\u6570\u636e\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        Date date = new Date();
        String yearMonth = StringUtils.isNotEmpty((CharSequence)dto.getWithholdingYearMonth()) ? dto.getWithholdingYearMonth() : DateUtil.format((Date)date, (String)"yyyy-MM");
        int pageNum = 1;
        int pageSize = 500;
        if (StringUtils.isEmpty((CharSequence)dto.getWithholdingTarget()) || TpmWithholdingDetailTargetEnum.UPWARD.getCode().equals(dto.getWithholdingTarget())) {
            int month = Integer.parseInt(ds.substring(4, 6));
            String accountingPeriod = String.format("%02d", month);
            ArrayList customerCodeList = new ArrayList();
            if (salesOrgReqVo != null) {
                List salesOrgSubComOrgVoList = this.salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgReqVo.getErpCode());
                customerCodeList.addAll(salesOrgSubComOrgVoList.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList()));
            }
            Integer total = this.zmsd187Service.findTotal(ds, accountingPeriod, customerReqVo, salesOrgReqVo, dto.getBusinessFormatCode(), customerCodeList);
            int totalPage = total / pageSize + 1;
            CustomerVo customerRevert = customerReqVo;
            SalesOrgVo salesOrgRevert = salesOrgReqVo;
            while (pageNum <= totalPage) {
                int pageNumRevert = pageNum++;
                log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d187\u62a5\u8868\u9884\u63d0\u6267\u884c\u4e2d,{},{}", (Object)pageNumRevert, (Object)pageSize);
                CompletableFuture.runAsync(() -> {
                    try {
                        this.task187(pageNumRevert, pageSize, dto, ds, accountingPeriod, customerRevert, salesOrgRevert, yearMonth, "YTMX", date, userJsonObject, loginUser, customerCodeList);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                });
            }
        }
        if (!StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)dto.getBusinessUnitCode()) && (StringUtils.isEmpty((CharSequence)dto.getWithholdingTarget()) || TpmWithholdingDetailTargetEnum.DOWNWARD.getCode().equals(dto.getWithholdingTarget()))) {
            Date dsDate = DateUtil.getDateByFormat((String)ds, (String)"yyyyMMdd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dsDate);
            calendar.add(2, -1);
            int month = calendar.get(2) + 1;
            String accountingPeriod = String.format("%02d", month);
            Integer total = this.zmsd121Service.findTotal(ds, accountingPeriod, customerReqVo, salesOrgReqVo, dto.getBusinessFormatCode());
            int totalPage = total / pageSize + 1;
            pageNum = 1;
            CustomerVo customerRevert = customerReqVo;
            SalesOrgVo salesOrgRevert = salesOrgReqVo;
            while (pageNum <= totalPage) {
                int pageNumRevert = pageNum++;
                log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d121\u62a5\u8868\u9884\u63d0\u6267\u884c\u4e2d,{},{}", (Object)pageNumRevert, (Object)pageSize);
                CompletableFuture.runAsync(() -> {
                    try {
                        this.task121(pageNumRevert, pageSize, dto, ds, accountingPeriod, customerRevert, salesOrgRevert, yearMonth, "YTMX", date, userJsonObject, loginUser);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                });
            }
        }
        if (StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)dto.getBusinessUnitCode()) && (StringUtils.isEmpty((CharSequence)dto.getWithholdingTarget()) || TpmWithholdingDetailTargetEnum.DOWNWARD.getCode().equals(dto.getWithholdingTarget()))) {
            String yearMonthStr = DateUtil.format((Date)DateUtils.addMonths((Date)DateUtil.parse((String)(dto.getWithholdingYearMonth() + "-01"), (String)"yyyy-MM"), (int)1), (String)"yyyy-MM");
            long total = this.tpmWithholdingDetailVerticalFeeBalanceUtil.getTotalBalance(yearMonthStr, dto.getResaleCommercialCode(), dto.getRegion(), dto.getBusinessFormatCode());
            log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d\u9884\u63d0\u6267\u884c\u4e2d,\u603b\u6570\uff1a{}", (Object)total);
            long totalPage = total / (long)pageSize + 1L;
            for (long pageNumber = 1L; pageNumber <= totalPage; ++pageNumber) {
                long offSet = (pageNumber - 1L) * (long)pageSize;
                log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d\u9884\u63d0\u6267\u884c\u4e2d,{},{}", (Object)offSet, (Object)pageSize);
                CompletableFuture.runAsync(() -> {
                    try {
                        this.tpmWithholdingDetailVerticalFeeBalanceUtil.feeBalance(offSet, Long.valueOf(pageSize), dto.getResaleCommercialCode(), dto.getRegion(), dto.getBusinessFormatCode(), yearMonthStr, "YTMX", date, userJsonObject, loginUser);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void task187(int pageNum, int pageSize, TpmWithholdingDetailRedoWithholdingDto dto, String ds, String accountingPeriod, CustomerVo customerReqVo, SalesOrgVo salesOrgReqVo, String yearMonth, String ruleCode, Date date, JSONObject userJsonObject, UserIdentity loginUser, List<String> customerCodeFilterList) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d187\u62a5\u8868\u9884\u63d0\u5904\u7406\u5f00\u59cb,{},{},{}", new Object[]{DateUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss"), pageNum, pageSize});
        Page page187 = new Page((long)pageNum, (long)pageSize);
        page187 = this.zmsd187Service.findByDs(page187, ds, accountingPeriod, customerReqVo, salesOrgReqVo, dto.getBusinessFormatCode(), customerCodeFilterList);
        if (CollectionUtils.isEmpty((Collection)page187.getRecords())) {
            log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d187\u62a5\u8868\u9884\u63d0\u6267\u884c\u7ed3\u675f,{},{}", (Object)page187.getCurrent(), (Object)page187.getSize());
            return;
        }
        ArrayList<TpmWithholdingDetailDto> result = new ArrayList<TpmWithholdingDetailDto>();
        List<String> customerCodeList = this.generateCustomerCode(page187.getRecords());
        List customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(customerCodeList);
        Map customerMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        List customerErpCodeList = page187.getRecords().stream().map(TpmZmsd187Vo::getCustomerCode).distinct().collect(Collectors.toList());
        List salesOrgSubComOrgVoList = this.salesOrgSubComOrgService.listBySubComOrgCodeList(customerErpCodeList);
        List salesOrgErpCodeList = salesOrgSubComOrgVoList.stream().map(SalesOrgSubComOrgVo::getSalesOrgCode).distinct().collect(Collectors.toList());
        List salesOrgVoList = this.salesOrgVoService.findByErpCodeList(salesOrgErpCodeList).stream().filter(o -> SalesOrgLevelTypeEnum.MECHANISM.getCode().equals(o.getSalesOrgLevel())).collect(Collectors.toList());
        HashMap<String, Object> salesOrgMap = new HashMap<String, Object>();
        for (SalesOrgSubComOrgVo salesOrgSubComOrgVo : salesOrgSubComOrgVoList) {
            List customerSalesOrgVoList = salesOrgVoList.stream().filter(o -> salesOrgSubComOrgVo.getSalesOrgCode().equals(o.getErpCode())).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(customerSalesOrgVoList)) continue;
            salesOrgMap.put(salesOrgSubComOrgVo.getSubComOrgCode(), customerSalesOrgVoList);
        }
        List withholdingCodeList = this.generateCodeService.generateCode("YTMX", page187.getRecords().size());
        int counter = 0;
        for (TpmZmsd187Vo zmsd187Vo : page187.getRecords()) {
            List salesOrgVos;
            if (BigDecimal.ZERO.compareTo(zmsd187Vo.getEndingBalance()) == 0) continue;
            TpmWithholdingDetailDto entity = new TpmWithholdingDetailDto();
            String customerCode = zmsd187Vo.getCustomerCode() + zmsd187Vo.getCompanyCode() + zmsd187Vo.getDistributionChannelCode() + zmsd187Vo.getProductTeamCode();
            CustomerVo customerVo = (CustomerVo)customerMap.get(customerCode);
            entity.setCustomerCode(customerCode);
            entity.setCustomerErpCode(zmsd187Vo.getCustomerCode());
            if (customerVo != null) {
                entity.setCustomerName(customerVo.getCustomerName());
            }
            if (CollectionUtils.isNotEmpty((Collection)(salesOrgVos = (List)salesOrgMap.get(zmsd187Vo.getCustomerCode())))) {
                SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVos.get(0);
                entity.setSalesOrgCode(salesOrgVo.getSalesOrgCode());
                entity.setSalesOrgErpCode(salesOrgVo.getErpCode());
                entity.setSalesOrgName(salesOrgVo.getSalesOrgName());
                entity.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
                entity.setBusinessUnitCode(salesOrgVo.getBusinessUnitCode());
                entity.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
            }
            entity.setBusinessFormatCode(zmsd187Vo.getProductTeamCode());
            entity.setWithholdingAmount(zmsd187Vo.getEndingBalance());
            entity.setAdjustAmount(BigDecimal.ZERO);
            entity.setAfterAdjustAmount(entity.getWithholdingAmount());
            if (StringUtils.isNotEmpty((CharSequence)zmsd187Vo.getAccountingPeriod()) && StringUtils.isNotEmpty((CharSequence)zmsd187Vo.getFiscalYear())) {
                String yearMonthStr = zmsd187Vo.getFiscalYear() + "-" + this.fullMonthStr(zmsd187Vo.getAccountingPeriod());
                entity.setWithholdingYearMonth(yearMonthStr);
                entity.setFeeYearMonth(yearMonthStr);
            } else {
                entity.setWithholdingYearMonth(yearMonth);
                entity.setFeeYearMonth(yearMonth);
            }
            entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
            entity.setCreateAccount(userJsonObject.getString("account"));
            entity.setCreateName(userJsonObject.getString("realName"));
            entity.setModifyAccount(userJsonObject.getString("account"));
            entity.setModifyName(userJsonObject.getString("realName"));
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.UPWARD.getCode());
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.FEE_POOL_WITHHOLDING.getCode());
            entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            result.add(entity);
            ++counter;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            Map<String, CostCenterRelationVo> costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(result, "1");
            result.forEach(v -> {
                if (costCenterMap.containsKey(v.getActivityDetailCode())) {
                    CostCenterRelationVo vo = (CostCenterRelationVo)costCenterMap.get(v.getActivityDetailCode());
                    v.setCostCenter(vo.getCostCenterCode());
                    v.setCostCenterName(vo.getCostCenterName());
                }
                v.setActivityDetailCode(null);
            });
            String lock = "withholding:detail:activity:detail:plan";
            boolean lockFlag = false;
            try {
                lockFlag = this.redisLockService.tryLock(lock, TimeUnit.SECONDS, 10L);
                if (lockFlag) {
                    this.insertList(result);
                    log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d187\u62a5\u8868\u9884\u63d0\u6267\u884c\u7ed3\u675f,{},{}", (Object)page187.getCurrent(), (Object)page187.getSize());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (lockFlag) {
                    this.redisLockService.unlock(lock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void task121(int pageNum, int pageSize, TpmWithholdingDetailRedoWithholdingDto dto, String ds, String accountingPeriod, CustomerVo customerReqVo, SalesOrgVo salesOrgReqVo, String yearMonth, String ruleCode, Date date, JSONObject userJsonObject, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d121\u62a5\u8868\u9884\u63d0\u5904\u7406\u5f00\u59cb,{},{},{}", new Object[]{DateUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss"), pageNum, pageSize});
        Page page121 = new Page((long)pageNum, (long)pageSize);
        page121 = this.zmsd121Service.findByDs(page121, ds, accountingPeriod, customerReqVo, salesOrgReqVo, dto.getBusinessFormatCode());
        if (CollectionUtils.isEmpty((Collection)page121.getRecords())) {
            log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d121\u62a5\u8868\u9884\u63d0\u6267\u884c\u7ed3\u675f,{},{}", (Object)page121.getCurrent(), (Object)page121.getSize());
            return;
        }
        ArrayList<TpmWithholdingDetailDto> result = new ArrayList<TpmWithholdingDetailDto>();
        Set customerErpCodeList = page121.getRecords().stream().map(TpmZmsd121Vo::getCustomerCode).collect(Collectors.toSet());
        List customerVoList = this.customerVoService.findByErpCodeList(new ArrayList(customerErpCodeList));
        Map<String, List<CustomerVo>> customerMap = customerVoList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getSalesInstitutionErpCode())).collect(Collectors.groupingBy(o -> o.getErpCode() + o.getSalesInstitutionErpCode()));
        Set salesOrgCode = customerVoList.stream().map(CustomerVo::getSalesInstitutionCode).collect(Collectors.toSet());
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(new ArrayList(salesOrgCode));
        Map salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        List withholdingCodeList = this.generateCodeService.generateCode("YTMX", page121.getRecords().size());
        int counter = 0;
        for (TpmZmsd121Vo zmsd121Vo : page121.getRecords()) {
            if (BigDecimal.ZERO.compareTo(zmsd121Vo.getEndingBalance()) == 0) continue;
            TpmWithholdingDetailDto entity = new TpmWithholdingDetailDto();
            entity.setCustomerErpCode(zmsd121Vo.getCustomerCode());
            entity.setSalesOrgErpCode(zmsd121Vo.getSaleOrgCode());
            entity.setBusinessFormatCode(zmsd121Vo.getProductTeamCode());
            entity.setWithholdingAmount(zmsd121Vo.getEndingBalance());
            entity.setAdjustAmount(BigDecimal.ZERO);
            entity.setAfterAdjustAmount(entity.getWithholdingAmount());
            String linkCustomerKey = zmsd121Vo.getCustomerCode() + zmsd121Vo.getCompanyCode();
            if (CollectionUtils.isNotEmpty((Collection)customerMap.get(linkCustomerKey))) {
                List customerList;
                CustomerVo customer = null;
                if (StringUtils.isNotEmpty((CharSequence)zmsd121Vo.getProductTeamCode().trim())) {
                    customerList = customerMap.get(linkCustomerKey).stream().filter(o -> o.getBusinessFormatCode().equals(zmsd121Vo.getProductTeamCode())).sorted(Comparator.comparing(CustomerVo::getCustomerCode)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(customerList)) {
                        customer = (CustomerVo)customerList.get(0);
                    }
                } else {
                    customerList = customerMap.get(linkCustomerKey).stream().sorted(Comparator.comparing(CustomerVo::getCustomerCode)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(customerList)) {
                        customer = (CustomerVo)customerList.get(0);
                    }
                }
                if (customer != null) {
                    entity.setCustomerCode(customer.getCustomerCode());
                    entity.setCustomerName(customer.getCustomerName());
                    SalesOrgVo salesOrg = (SalesOrgVo)salesOrgMap.get(customer.getSalesInstitutionCode());
                    if (salesOrg != null) {
                        entity.setSalesOrgCode(salesOrg.getSalesOrgCode());
                        entity.setSalesOrgName(salesOrg.getSalesOrgName());
                        entity.setBusinessFormatCode(salesOrg.getBusinessFormatCode());
                        entity.setBusinessUnitCode(salesOrg.getBusinessUnitCode());
                        entity.setSalesOrgLevel(salesOrg.getSalesOrgLevel());
                        entity.setSalesInstitutionCode(entity.getSalesInstitutionCode());
                        if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(salesOrg.getSalesOrgLevel())) {
                            entity.setSalesRegionCode(salesOrg.getSalesOrgCode());
                        }
                        if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(salesOrg.getSalesOrgLevel())) {
                            entity.setSalesRegionCode(salesOrg.getSalesOrgCode());
                            entity.setSalesGroupCode(salesOrg.getSalesOrgCode());
                        }
                    }
                }
            }
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            if (StringUtils.isNotEmpty((CharSequence)zmsd121Vo.getAccountingPeriod()) && StringUtils.isNotEmpty((CharSequence)zmsd121Vo.getFiscalYear())) {
                String yearMonthStr = zmsd121Vo.getFiscalYear() + "-" + this.fullMonthStr(zmsd121Vo.getAccountingPeriod());
                entity.setWithholdingYearMonth(yearMonthStr);
                entity.setFeeYearMonth(yearMonthStr);
            } else {
                entity.setWithholdingYearMonth(yearMonth);
                entity.setFeeYearMonth(yearMonth);
            }
            entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
            entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
            entity.setCreateAccount(userJsonObject.getString("account"));
            entity.setCreateName(userJsonObject.getString("realName"));
            entity.setModifyAccount(userJsonObject.getString("account"));
            entity.setModifyName(userJsonObject.getString("realName"));
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.FEE_POOL_WITHHOLDING.getCode());
            entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            result.add(entity);
            ++counter;
        }
        if (CollectionUtils.isNotEmpty(result)) {
            Map<String, CostCenterRelationVo> costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(result, "1");
            result.forEach(v -> {
                if (costCenterMap.containsKey(v.getActivityDetailCode())) {
                    CostCenterRelationVo vo = (CostCenterRelationVo)costCenterMap.get(v.getActivityDetailCode());
                    v.setCostCenter(vo.getCostCenterCode());
                    v.setCostCenterName(vo.getCostCenterName());
                }
                v.setActivityDetailCode(null);
            });
            String lock = "withholding:detail:activity:detail:plan";
            boolean lockFlag = false;
            try {
                lockFlag = this.redisLockService.tryLock(lock, TimeUnit.SECONDS, 10L);
                if (lockFlag) {
                    this.insertList(result);
                    log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d121\u62a5\u8868\u9884\u63d0\u6267\u884c\u7ed3\u675f,{},{}", (Object)page121.getCurrent(), (Object)page121.getSize());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (lockFlag) {
                    this.redisLockService.unlock(lock);
                }
            }
        }
    }

    private List<String> generateSalesOrgCode(List<TpmZmsd187Vo> records) {
        ArrayList salesOrgCodes = new ArrayList();
        records.forEach(o -> salesOrgCodes.add(o.getDistributionChannelCode() + o.getProductTeamCode() + o.getSaleOrgCode()));
        return salesOrgCodes.stream().distinct().collect(Collectors.toList());
    }

    private List<String> generateCustomerCode(List<TpmZmsd187Vo> records) {
        ArrayList customerCodes = new ArrayList();
        records.forEach(o -> customerCodes.add(o.getCustomerCode() + o.getCompanyCode() + o.getDistributionChannelCode() + o.getProductTeamCode()));
        return customerCodes.stream().distinct().collect(Collectors.toList());
    }

    public TpmWithholdingDetailRespVo getWithholdingDetailByCode(String detailCode) {
        if (StringUtils.isEmpty((CharSequence)detailCode)) {
            return null;
        }
        List<TpmWithholdingDetailEntity> list = this.tpmWithholdingDetailEntityRepository.getWithholdingDetailByDetailCode(detailCode);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List detailRespVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmWithholdingDetailEntity.class, TpmWithholdingDetailRespVo.class, HashSet.class, ArrayList.class, new String[0]);
        return (TpmWithholdingDetailRespVo)detailRespVoList.get(0);
    }

    public TpmWithholdingDetailSubmitSummaryRespVo summaryForSubmitByProcessNo(String processNo) {
        List<String> idList = this.tpmWithholdingDetailEntityRepository.findIdListByProcessNo(processNo);
        return this.summaryForSubmit(idList);
    }

    public List<String> findIdListByCondition(TpmWithholdingDetailDto reqVo) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reqVo.getBusinessUnitCode())) {
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(reqVo.getSalesOrgCode());
            if (salesOrgVo != null) {
                reqVo.setSalesOrgErpCode(salesOrgVo.getErpCode());
                reqVo.setSalesOrgCode(null);
            } else {
                throw new UnsupportedOperationException("\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            }
        }
        reqVo.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmWithholdingDetailEntityRepository.findIdListByCondition(reqVo);
    }

    public Page<TpmWithholdingDetailRespVo> findDetailPageForSubmit(Pageable pageable, TpmWithholdingDetailDto reqVo) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reqVo.getBusinessUnitCode())) {
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(reqVo.getSalesOrgCode());
            reqVo.setSalesOrgErpCode(salesOrgVo.getErpCode());
            reqVo.setSalesOrgCode(null);
        }
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.tpmWithholdingDetailEntityRepository.findDetailPageForSubmit(pageable, reqVo);
    }

    public TpmWithholdingDetailRespVo findTotalAmountForSubmit(TpmWithholdingDetailDto reqVo) {
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(reqVo.getBusinessUnitCode())) {
            SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(reqVo.getSalesOrgCode());
            reqVo.setSalesOrgErpCode(salesOrgVo.getErpCode());
            reqVo.setSalesOrgCode(null);
        }
        reqVo.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmWithholdingDetailEntityRepository.findTotalAmountForSubmit(reqVo);
    }

    public void addProtocol(TpmWithholdingDetailProtocolDto dto) {
        TpmWithholdingDetailEntity entity;
        if (CollectionUtils.isNotEmpty((Collection)dto.getFileList())) {
            if (dto.getFileList().size() > 5) {
                throw new UnsupportedOperationException("\u6700\u591a\u53ef\u4e0a\u4f205\u4e2a\u9644\u4ef6");
            }
            for (OrdinaryFileVo file : dto.getFileList()) {
                if (!StringUtils.isEmpty((CharSequence)file.getId())) continue;
                throw new UnsupportedOperationException("\u9644\u4ef6\u7f3a\u5c11\u6587\u4ef6\u7f16\u7801");
            }
        }
        if ((entity = (TpmWithholdingDetailEntity)((Object)this.tpmWithholdingDetailEntityRepository.getById((Serializable)((Object)dto.getId())))) == null || !DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag())) {
            throw new UnsupportedOperationException("\u672a\u67e5\u8be2\u5230\u9884\u63d0\u660e\u7ec6\u4fe1\u606f");
        }
        if (CollectionUtils.isEmpty((Collection)dto.getFileList())) {
            entity.setProtocolList("");
        } else {
            entity.setProtocolList(dto.getFileList().stream().map(OrdinaryFileVo::getId).collect(Collectors.joining(",")));
        }
        this.tpmWithholdingDetailEntityRepository.updateById((Object)entity);
    }

    public List<OrdinaryFileVo> findProtocolById(String id) {
        TpmWithholdingDetailEntity entity = (TpmWithholdingDetailEntity)((Object)this.tpmWithholdingDetailEntityRepository.getById((Serializable)((Object)id)));
        if (entity == null || !DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag())) {
            throw new UnsupportedOperationException("\u672a\u67e5\u8be2\u5230\u9884\u63d0\u660e\u7ec6\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)entity.getProtocolList())) {
            return new ArrayList<OrdinaryFileVo>();
        }
        ArrayList<OrdinaryFileVo> fileList = new ArrayList<OrdinaryFileVo>();
        for (String fileId : entity.getProtocolList().split(",")) {
            fileList.add(this.fileHandleService.findById(fileId));
        }
        return fileList;
    }

    public Page<TpmWithholdingDetailActivityDetailPlanVo> activityPlanPage(Pageable pageable, TpmWithholdingDetailActivityDetailPlanDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TpmWithholdingDetailActivityDetailPlanDto();
        }
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)PageRequest.of((int)dto.getPageNum(), (int)dto.getPageSize()), (Object)PageRequest.of((int)1, (int)50));
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithholdingYearMonth(), (String)"\u9884\u63d0\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(dto.getBusinessUnitCode())) {
            return this.tpmWithholdingDetailEntityMapper.activityPlanPageSubCom((Page<TpmWithholdingDetailActivityDetailPlanVo>)page, dto);
        }
        if (BusinessUnitEnum.ONLINE.getCode().equals(dto.getBusinessUnitCode())) {
            return this.tpmWithholdingDetailEntityMapper.activityPlanPageOnline((Page<TpmWithholdingDetailActivityDetailPlanVo>)page, dto);
        }
        return this.tpmWithholdingDetailEntityMapper.activityPlanPageHead((Page<TpmWithholdingDetailActivityDetailPlanVo>)page, dto);
    }

    public void createSplitData(TpmWithholdingDetailAdjustDto dto) {
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58[cacheKey]\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithholdingYearMonth(), (String)"\u9884\u63d0\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDetailPlanCode(), (String)"\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSplitType(), (String)"\u5206\u644a\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getWithholdingAmount(), (String)"\u9884\u63d0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TpmWithholdingDetailDto> detailList = this.tpmWithholdingDetailEntityMapper.findSplitDetailList(dto, TenantUtils.getTenantCode());
        Validate.notEmpty(detailList, (String)"\u5f53\u524d\u6761\u4ef6\u4e0b\uff0c\u672a\u83b7\u53d6\u5230\u5206\u644a\u6570\u636e\uff01", (Object[])new Object[0]);
        for (TpmWithholdingDetailDto v : detailList) {
            if (Objects.isNull(v.getWithholdingAmount())) {
                v.setWithholdingAmount(BigDecimal.ZERO);
            }
            if (Objects.isNull(v.getAdjustAmount())) {
                v.setAdjustAmount(BigDecimal.ZERO);
            }
            if (!Objects.isNull(v.getAfterAdjustAmount())) continue;
            v.setAfterAdjustAmount(BigDecimal.ZERO);
        }
        BigDecimal total = detailList.stream().filter(e -> Objects.nonNull(e.getWithholdingAmount())).map(TpmWithholdingDetailDto::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal withholdingAmount = dto.getWithholdingAmount();
        if (StringUtils.equals((CharSequence)WithholdingDetailSplitTypeEnum.AVERAGE.getCode(), (CharSequence)dto.getSplitType())) {
            BigDecimal averageAmount = withholdingAmount.divide(new BigDecimal(detailList.size()), 2, 1);
            BigDecimal averageAmountTotal = BigDecimal.ZERO;
            for (TpmWithholdingDetailDto v : detailList) {
                v.setAfterAdjustAmount(averageAmount);
                averageAmountTotal = averageAmountTotal.add(averageAmount);
            }
            detailList.get(0).setAfterAdjustAmount(detailList.get(0).getAfterAdjustAmount().add(withholdingAmount.subtract(averageAmountTotal)));
        } else if (BigDecimal.ZERO.compareTo(total) != 0) {
            for (TpmWithholdingDetailDto v : detailList) {
                BigDecimal currAdjustAmount = v.getWithholdingAmount().multiply(withholdingAmount).divide(total, 2, 1);
                v.setAfterAdjustAmount(currAdjustAmount);
            }
            BigDecimal amount = detailList.stream().map(TpmWithholdingDetailDto::getAfterAdjustAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            amount = detailList.get(0).getAfterAdjustAmount().add(withholdingAmount.subtract(amount));
            detailList.get(0).setAfterAdjustAmount(amount);
        }
        String splitRemark = "";
        if (StringUtils.isNotEmpty((CharSequence)dto.getRemark())) {
            splitRemark = dto.getRemark();
        }
        for (TpmWithholdingDetailDto v : detailList) {
            v.setAfterAdjustAmountStr(v.getAfterAdjustAmount().toString());
            v.setAdjustAmount(v.getAfterAdjustAmount().subtract(v.getWithholdingAmount()));
            v.setAdjustAmountStr(v.getAdjustAmount().toString());
            v.setAdjustReason((StringUtils.isNotEmpty((CharSequence)v.getAdjustReason()) ? v.getAdjustReason() + ";" : "") + splitRemark);
            v.setRemark((StringUtils.isNotEmpty((CharSequence)v.getRemark()) ? v.getRemark() + ";" : "") + splitRemark);
        }
        this.clearCache(dto.getCacheKey());
        this.addItemCache(dto.getCacheKey(), detailList);
    }

    @Transactional
    public void saveSplitData(TpmWithholdingDetailAdjustDto dto) {
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58[cacheKey]\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWithholdingYearMonth(), (String)"\u9884\u63d0\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDetailPlanCode(), (String)"\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSplitType(), (String)"\u5206\u644a\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getWithholdingAmount(), (String)"\u9884\u63d0\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailList = this.findCacheList(dto.getCacheKey());
        Validate.notEmpty((Collection)detailList, (String)"\u5f53\u524d\u6761\u4ef6\u4e0b\uff0c\u672a\u83b7\u53d6\u5230\u5206\u644a\u6570\u636e\uff01", (Object[])new Object[0]);
        BigDecimal itemTotalAmount = detailList.stream().filter(e -> Objects.nonNull(e.getAfterAdjustAmount())).map(TpmWithholdingDetailDto::getAfterAdjustAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((dto.getWithholdingAmount().compareTo(itemTotalAmount) == 0 ? 1 : 0) != 0, (String)"\u9884\u63d0\u91d1\u989d\u4e0d\u7b49\u4e8e\u8c03\u6574\u540e\u91d1\u989d\u603b\u548c\uff01", (Object[])new Object[0]);
        for (Object v2 : detailList) {
            Validate.notBlank((CharSequence)v2.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (Objects.isNull(v2.getWithholdingAmount())) {
                v2.setWithholdingAmount(BigDecimal.ZERO);
            }
            if (Objects.isNull(v2.getAdjustAmount())) {
                v2.setAdjustAmount(BigDecimal.ZERO);
            }
            if (!Objects.isNull(v2.getAfterAdjustAmount())) continue;
            v2.setAfterAdjustAmount(BigDecimal.ZERO);
        }
        String splitRemark = "";
        if (StringUtils.isNotEmpty((CharSequence)dto.getRemark())) {
            splitRemark = dto.getRemark();
        }
        for (TpmWithholdingDetailDto v3 : detailList) {
            v3.setAfterAdjustAmount(v3.getWithholdingAmount().add(v3.getAdjustAmount()));
            v3.setAfterAdjustAmountStr(v3.getAfterAdjustAmount().toString());
            v3.setAdjustAmountStr(v3.getAdjustAmount().toString());
            v3.setRemark((StringUtils.isNotEmpty((CharSequence)v3.getRemark()) ? v3.getRemark() + ";" : "") + splitRemark);
            v3.setAdjustReason((StringUtils.isNotEmpty((CharSequence)v3.getAdjustReason()) ? v3.getAdjustReason() + ";" : "") + splitRemark);
        }
        Map<String, TpmWithholdingDetailDto> map = detailList.stream().collect(Collectors.toMap(UuidDto::getId, v -> v));
        List ids = detailList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List entityList = this.tpmWithholdingDetailEntityMapper.selectBatchIds(ids);
        entityList.forEach(e -> {
            if (!map.containsKey(e.getId())) {
                return;
            }
            TpmWithholdingDetailDto detailDto = (TpmWithholdingDetailDto)map.get(e.getId());
            e.setSplitType(detailDto.getSplitType());
            e.setAdjustAmount(detailDto.getAdjustAmount());
            e.setAfterAdjustAmount(detailDto.getAfterAdjustAmount());
            e.setAdjustReason(detailDto.getAdjustReason());
            e.setRemark(detailDto.getRemark());
        });
        this.tpmWithholdingDetailEntityRepository.updateBatchById(entityList);
        this.clearCache(dto.getCacheKey());
    }

    public List<TpmWithholdingDetailVerticalSplitDataRespVo> findSplitDataByCostCenterCodeList(List<String> costCenterCodeList, String feeYearMonth) {
        if (CollectionUtils.isEmpty(costCenterCodeList)) {
            return new ArrayList<TpmWithholdingDetailVerticalSplitDataRespVo>();
        }
        CostCenterRelationDto dto = new CostCenterRelationDto();
        dto.setCostCenterCodeList(costCenterCodeList);
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        List costCenterRelationVoList = this.costCenterRelationVoService.findCostCenterRelationByCodeList(dto);
        Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        if (CollectionUtils.isNotEmpty((Collection)costCenterRelationVoList)) {
            ArrayList<TpmWithholdingDetailVerticalSplitDataRespVo> result = new ArrayList<TpmWithholdingDetailVerticalSplitDataRespVo>();
            for (CostCenterRelationVo costCenterRelationVo : costCenterRelationVoList) {
                SalesPerformanceDto salesPerformanceDto = new SalesPerformanceDto();
                salesPerformanceDto.setRegion((String)regionMap.get(costCenterRelationVo.getCustomerRetailerRegion()));
                salesPerformanceDto.setRetailer(costCenterRelationVo.getCustomerRetailerName());
                salesPerformanceDto.setSalesMonth(feeYearMonth.substring(0, 4) + feeYearMonth.substring(5, 7));
                SalesPerformanceVo salesPerformanceVo = this.salesPerformanceVoService.findSalesAmountAndOutNumber(salesPerformanceDto);
                TpmWithholdingDetailVerticalSplitDataRespVo respVo = new TpmWithholdingDetailVerticalSplitDataRespVo();
                respVo.setCostCenterCode(costCenterRelationVo.getCostCenterCode());
                respVo.setCostCenterName(costCenterRelationVo.getCostCenterName());
                respVo.setResaleCommercialCode(costCenterRelationVo.getCustomerRetailerCode());
                respVo.setResaleCommercialName(costCenterRelationVo.getCustomerRetailerName());
                respVo.setTotalAmount(salesPerformanceVo.getWarehsOutDiscountAmt());
                respVo.setRegion(costCenterRelationVo.getCustomerRetailerRegion());
                result.add(respVo);
            }
            if (CollectionUtils.isNotEmpty(result)) {
                BigDecimal totalSaleAmount = result.stream().map(TpmWithholdingDetailVerticalSplitDataRespVo::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (BigDecimal.ZERO.compareTo(totalSaleAmount) == 0) {
                    for (TpmWithholdingDetailVerticalSplitDataRespVo respVo : result) {
                        respVo.setSplitRatio(BigDecimal.ONE.divide(new BigDecimal(result.size()), 2, 4));
                    }
                } else {
                    for (TpmWithholdingDetailVerticalSplitDataRespVo respVo : result) {
                        respVo.setSplitRatio(respVo.getTotalAmount().divide(totalSaleAmount, 2, 4));
                    }
                }
            }
            return result;
        }
        return new ArrayList<TpmWithholdingDetailVerticalSplitDataRespVo>();
    }

    private void initSummary(TpmWithholdingDetailSubmitSummaryRespVo respVo) {
        respVo.setBaseHandledUnDiscountAmount(BigDecimal.ZERO);
        respVo.setBaseUnClearAmount(BigDecimal.ZERO);
        respVo.setBaseUnHandledAmount(BigDecimal.ZERO);
        respVo.setUnClearAmount(BigDecimal.ZERO);
        respVo.setUnHandledAmount(BigDecimal.ZERO);
        respVo.setHandledUnDiscountAmount(BigDecimal.ZERO);
        respVo.setOtherAmount(BigDecimal.ZERO);
        respVo.setUpwardWithholdingDetailList(new ArrayList());
        respVo.setDownwardWithholdingDetailList(new ArrayList());
        respVo.setIdList(new ArrayList());
    }

    private String fullMonthStr(String monthStr) {
        if (StringUtils.isNotEmpty((CharSequence)monthStr) && monthStr.length() == 1) {
            return "0" + monthStr;
        }
        return monthStr;
    }
}

