/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailActivityDetailPlanMqDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailSubComActivityDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailGenerateMqVoUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TpmWithholdingDetailSubComActivityDetailPartServiceImpl
implements TpmWithholdingDetailSubComActivityDetailPartService {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailSubComActivityDetailPartServiceImpl.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public String redoWithholding(TpmWithholdingDetailRedoWithholdingDto dto) {
        int subComPage = 1;
        int subComPageSize = 500;
        PageRequest subComPageable = PageRequest.of((int)subComPage, (int)subComPageSize);
        List<TpmWithholdingDetailActivityDetailPlanMqDto> sendMsgList = new ArrayList();
        if (TpmWithholdingDetailTargetEnum.UPWARD.getCode().equals(dto.getWithholdingTarget())) {
            subComPageable = PageRequest.of((int)subComPage, (int)subComPageSize);
            ActivityDetailPlanItemDto upwardDto = new ActivityDetailPlanItemDto();
            upwardDto.setSalesOrgCode(dto.getSalesOrgCode());
            upwardDto.setCustomerCode(dto.getCustomerCode());
            upwardDto.setSystemCode(dto.getResaleCommercialCode());
            upwardDto.setDetailPlanCode(dto.getDetailPlanCode());
            upwardDto.setBeginDateEnd(dto.getEndDate());
            Page upwardPageResult = this.activityDetailPlanItemSdkService.findUpwardDetailForWithholding((Pageable)subComPageable, upwardDto);
            if (CollectionUtils.isEmpty((Collection)upwardPageResult.getRecords())) {
                throw new UnsupportedOperationException("\u4e0d\u5b58\u5728\u53ef\u9884\u63d0\u6d3b\u52a8\u660e\u7ec6\u6570\u636e");
            }
            while (!CollectionUtils.isEmpty((Collection)upwardPageResult.getRecords())) {
                List detailItemCodeList = upwardPageResult.getRecords().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList());
                List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(new HashSet(detailItemCodeList));
                if (!CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
                    for (DetailedForecastVo detailForecastVo : detailedForecastVoList) {
                        Optional<ActivityDetailPlanItemVo> activityDetailPlanItem = upwardPageResult.getRecords().stream().filter(o -> o.getDetailPlanItemCode().equals(detailForecastVo.getActivityDetailItemCode())).findFirst();
                        if (!activityDetailPlanItem.isPresent()) continue;
                        TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                        mqDto.setCode(activityDetailPlanItem.get().getDetailPlanItemCode());
                        mqDto.setEnterAccountAmount(activityDetailPlanItem.get().getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.get().getAlreadyUpAccountAmount());
                        if (detailForecastVo.getEstimatedWriteOffAmount() == null || detailForecastVo.getEstimatedWriteOffAmount().compareTo(BigDecimal.ZERO) == 0) {
                            mqDto.setAuditAmount(activityDetailPlanItem.get().getFeeAmount());
                        } else {
                            mqDto.setAuditAmount(detailForecastVo.getEstimatedWriteOffAmount());
                        }
                        mqDto.setWithholdingTarget(TpmWithholdingDetailTargetEnum.UPWARD.getCode());
                        mqDto.setYearMonth(dto.getWithholdingYearMonth());
                        sendMsgList.add(mqDto);
                    }
                }
                if (sendMsgList.size() >= 500) {
                    try {
                        MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
                        mqMessage.setMsgBody(JSON.toJSONString(sendMsgList.subList(0, 500)));
                        mqMessage.setTag("WITHHOLDING_DETAIL_SUB_COM_ACTIVITY_DETAIL_PLAN_TAG");
                        this.rocketMqProducer.sendMqMsg(mqMessage);
                        sendMsgList = sendMsgList.subList(500, sendMsgList.size());
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        log.error("\u9884\u63d0\u660e\u7ec6-\u5206\u5b50\u6d3b\u52a8\u9884\u63d0\u63a8\u9001\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)e.getStackTrace()));
                    }
                }
                if (upwardPageResult.getRecords().size() == subComPageSize) {
                    subComPageable = PageRequest.of((int)(++subComPage), (int)subComPageSize);
                    upwardPageResult = this.activityDetailPlanItemSdkService.findUpwardDetailForWithholding((Pageable)subComPageable, upwardDto);
                    continue;
                }
                upwardPageResult = new Page();
            }
        } else {
            SubComActivityDetailPlanItemDto downwardDto = new SubComActivityDetailPlanItemDto();
            if (StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCode())) {
                SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(dto.getSalesOrgCode());
                if (salesOrgVo == null) {
                    throw new UnsupportedOperationException("\u9500\u552e\u7ec4\u7ec7\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                }
                ArrayList<String> salesOrgErpCodeList = new ArrayList<String>();
                salesOrgErpCodeList.add(salesOrgVo.getErpCode());
                List salesOrgVoList = this.salesOrgVoService.findByErpCodeList(salesOrgErpCodeList);
                downwardDto.setSalesOrgCodeList(salesOrgVoList.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList()));
            }
            downwardDto.setCustomerCode(dto.getCustomerCode());
            downwardDto.setResaleCommercialCode(dto.getResaleCommercialCode());
            downwardDto.setConstituentDetailPlanCode(dto.getDetailPlanCode());
            downwardDto.setBeginDateEnd(dto.getEndDate());
            Page downwardPageResult = this.subComActivityDetailPlanItemVoService.findForWithholding((Pageable)subComPageable, downwardDto);
            if (CollectionUtils.isEmpty((Collection)downwardPageResult.getRecords())) {
                throw new UnsupportedOperationException("\u4e0d\u5b58\u5728\u53ef\u9884\u63d0\u6d3b\u52a8\u660e\u7ec6\u6570\u636e");
            }
            while (!CollectionUtils.isEmpty((Collection)downwardPageResult.getRecords())) {
                List detailItemCodeList = downwardPageResult.getRecords().stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toList());
                List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(new HashSet(detailItemCodeList));
                if (!CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
                    for (DetailedForecastVo detailForecastVo : detailedForecastVoList) {
                        Optional<SubComActivityDetailPlanItemVo> subComActivityDetailPlanItem = downwardPageResult.getRecords().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getConstituentDetailPlanItemCode()) && o.getConstituentDetailPlanItemCode().equals(detailForecastVo.getActivityDetailItemCode())).findFirst();
                        if (!subComActivityDetailPlanItem.isPresent()) continue;
                        TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                        mqDto.setCode(subComActivityDetailPlanItem.get().getConstituentDetailPlanItemCode());
                        mqDto.setEnterAccountAmount(subComActivityDetailPlanItem.get().getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : subComActivityDetailPlanItem.get().getAlreadyUpAccountAmount());
                        if (detailForecastVo.getEstimatedWriteOffAmount() == null || detailForecastVo.getEstimatedWriteOffAmount().compareTo(BigDecimal.ZERO) == 0) {
                            mqDto.setAuditAmount(subComActivityDetailPlanItem.get().getTotalCost());
                        } else {
                            mqDto.setAuditAmount(detailForecastVo.getEstimatedWriteOffAmount());
                        }
                        mqDto.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
                        mqDto.setYearMonth(dto.getWithholdingYearMonth());
                        sendMsgList.add(mqDto);
                    }
                }
                if (sendMsgList.size() >= 500) {
                    try {
                        MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
                        mqMessage.setMsgBody(JSON.toJSONString(sendMsgList.subList(0, 500)));
                        mqMessage.setTag("WITHHOLDING_DETAIL_SUB_COM_ACTIVITY_DETAIL_PLAN_TAG");
                        this.rocketMqProducer.sendMqMsg(mqMessage);
                        sendMsgList = sendMsgList.subList(500, sendMsgList.size());
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        log.error("\u9884\u63d0\u660e\u7ec6-\u5206\u5b50\u6d3b\u52a8\u9884\u63d0\u63a8\u9001\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)e.getStackTrace()));
                    }
                }
                if (downwardPageResult.getRecords().size() == subComPageSize) {
                    subComPageable = PageRequest.of((int)(++subComPage), (int)subComPageSize);
                    downwardPageResult = this.subComActivityDetailPlanItemVoService.findForWithholding((Pageable)subComPageable, downwardDto);
                    continue;
                }
                downwardPageResult = new Page();
            }
        }
        if (sendMsgList.size() != 0) {
            MqMessageVo mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
            mqMessage.setMsgBody(JSON.toJSONString(sendMsgList));
            mqMessage.setTag("WITHHOLDING_DETAIL_SUB_COM_ACTIVITY_DETAIL_PLAN_TAG");
            this.rocketMqProducer.sendMqMsg(mqMessage);
        }
        return null;
    }

    public String systemWithholding() {
        MqMessageVo mqMessage;
        int subComPage = 1;
        int subComPageSize = 500;
        PageRequest subComPageable = PageRequest.of((int)subComPage, (int)subComPageSize);
        SubComActivityDetailPlanItemDto downwardDto = new SubComActivityDetailPlanItemDto();
        downwardDto.setBeginDateEnd(DateUtil.format((Date)new Date(), (String)"yyyy-MM") + "-01");
        Page downwardPageResult = this.subComActivityDetailPlanItemVoService.findForWithholding((Pageable)subComPageable, downwardDto);
        List<TpmWithholdingDetailActivityDetailPlanMqDto> sendMsgList = new ArrayList();
        while (!CollectionUtils.isEmpty((Collection)downwardPageResult.getRecords())) {
            List detailItemCodeList = downwardPageResult.getRecords().stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toList());
            List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(new HashSet(detailItemCodeList));
            for (DetailedForecastVo detailForecastVo : detailedForecastVoList) {
                Optional<SubComActivityDetailPlanItemVo> subComActivityDetailPlanItem = downwardPageResult.getRecords().stream().filter(o -> o.getConstituentDetailPlanItemCode().equals(detailForecastVo.getActivityDetailItemCode())).findFirst();
                if (!subComActivityDetailPlanItem.isPresent()) continue;
                TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                mqDto.setCode(subComActivityDetailPlanItem.get().getConstituentDetailPlanItemCode());
                mqDto.setEnterAccountAmount(subComActivityDetailPlanItem.get().getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : subComActivityDetailPlanItem.get().getAlreadyUpAccountAmount());
                mqDto.setAuditAmount(detailForecastVo.getEstimatedWriteOffAmount() == null ? BigDecimal.ZERO : detailForecastVo.getEstimatedWriteOffAmount());
                mqDto.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
                sendMsgList.add(mqDto);
            }
            if (sendMsgList.size() >= 500) {
                try {
                    mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
                    mqMessage.setMsgBody(JSON.toJSONString(sendMsgList.subList(0, 500)));
                    mqMessage.setTag("WITHHOLDING_DETAIL_SUB_COM_ACTIVITY_DETAIL_PLAN_TAG");
                    this.rocketMqProducer.sendMqMsg(mqMessage);
                    sendMsgList = sendMsgList.subList(500, sendMsgList.size());
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    log.error("\u9884\u63d0\u660e\u7ec6-\u5206\u5b50\u6d3b\u52a8\u9884\u63d0\u63a8\u9001\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)e.getStackTrace()));
                }
            }
            if (downwardPageResult.getRecords().size() == subComPageSize) {
                subComPageable = PageRequest.of((int)(++subComPage), (int)subComPageSize);
                downwardPageResult = this.subComActivityDetailPlanItemVoService.findForWithholding((Pageable)subComPageable, downwardDto);
                continue;
            }
            downwardPageResult = new Page();
        }
        subComPage = 1;
        subComPageSize = 500;
        subComPageable = PageRequest.of((int)subComPage, (int)subComPageSize);
        ActivityDetailPlanItemDto upwardDto = new ActivityDetailPlanItemDto();
        upwardDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        upwardDto.setBeginDateEnd(DateUtil.format((Date)new Date(), (String)"yyyy-MM") + "-01");
        Page upwardPageResult = this.activityDetailPlanItemSdkService.findUpwardDetailForWithholding((Pageable)subComPageable, upwardDto);
        while (!CollectionUtils.isEmpty((Collection)upwardPageResult.getRecords())) {
            List detailItemCodeList = upwardPageResult.getRecords().stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).collect(Collectors.toList());
            List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(new HashSet(detailItemCodeList));
            for (DetailedForecastVo detailForecastVo : detailedForecastVoList) {
                Optional<ActivityDetailPlanItemVo> activityDetailPlanItem = upwardPageResult.getRecords().stream().filter(o -> o.getDetailPlanItemCode().equals(detailForecastVo.getActivityDetailItemCode())).findFirst();
                if (!activityDetailPlanItem.isPresent()) continue;
                TpmWithholdingDetailActivityDetailPlanMqDto mqDto = new TpmWithholdingDetailActivityDetailPlanMqDto();
                mqDto.setCode(activityDetailPlanItem.get().getDetailPlanItemCode());
                mqDto.setEnterAccountAmount(activityDetailPlanItem.get().getAlreadyUpAccountAmount() == null ? BigDecimal.ZERO : activityDetailPlanItem.get().getAlreadyUpAccountAmount());
                mqDto.setAuditAmount(detailForecastVo.getEstimatedWriteOffAmount() == null ? BigDecimal.ZERO : detailForecastVo.getEstimatedWriteOffAmount());
                mqDto.setWithholdingTarget(TpmWithholdingDetailTargetEnum.UPWARD.getCode());
                sendMsgList.add(mqDto);
            }
            if (sendMsgList.size() >= 500) {
                try {
                    MqMessageVo mqMessage2 = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
                    mqMessage2.setMsgBody(JSON.toJSONString(sendMsgList.subList(0, 500)));
                    mqMessage2.setTag("WITHHOLDING_DETAIL_SUB_COM_ACTIVITY_DETAIL_PLAN_TAG");
                    this.rocketMqProducer.sendMqMsg(mqMessage2);
                    sendMsgList = sendMsgList.subList(500, sendMsgList.size());
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    log.error("\u9884\u63d0\u660e\u7ec6-\u5206\u5b50\u6d3b\u52a8\u9884\u63d0\u63a8\u9001\u5f02\u5e38\uff1a{},{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)e.getStackTrace()));
                }
            }
            if (upwardPageResult.getRecords().size() == subComPageSize) {
                subComPageable = PageRequest.of((int)(++subComPage), (int)subComPageSize);
                upwardPageResult = this.activityDetailPlanItemSdkService.findUpwardDetailForWithholding((Pageable)subComPageable, upwardDto);
                continue;
            }
            upwardPageResult = new Page();
        }
        if (sendMsgList.size() != 0) {
            mqMessage = TpmWithholdingDetailGenerateMqVoUtil.generateMqVo();
            mqMessage.setMsgBody(JSON.toJSONString(sendMsgList));
            mqMessage.setTag("WITHHOLDING_DETAIL_SUB_COM_ACTIVITY_DETAIL_PLAN_TAG");
            this.rocketMqProducer.sendMqMsg(mqMessage);
        }
        return null;
    }
}

