/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.service.process;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.WithholdingDetailEstoreImportVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WithholdingDetailEstoreImportProcess
implements ImportProcess<WithholdingDetailEstoreImportVo> {
    private static final Logger log = LoggerFactory.getLogger(WithholdingDetailEstoreImportProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private TpmWithholdingDetailService tpmWithholdingDetailService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";
    private static final String MDM_BUSINESS_UNIT = "mdm_business_unit";

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, WithholdingDetailEstoreImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        List productList;
        List customerVos;
        List orgVos;
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        ArrayList<TpmWithholdingDetailDto> list = new ArrayList<TpmWithholdingDetailDto>();
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> orgVoMap = new HashMap();
        Map<Object, Object> channelVoMap = new HashMap();
        Map<Object, Object> productMap = new HashMap();
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> channelCodeSet = new HashSet<String>();
        HashSet<String> orgCodeSet = new HashSet<String>();
        HashSet<String> productCodeSet = new HashSet<String>();
        HashSet<String> uniqueKeySet = new HashSet<String>();
        Collection<WithholdingDetailEstoreImportVo> voList = data.values();
        for (WithholdingDetailEstoreImportVo vo : voList) {
            channelCodeSet.add(vo.getChannelCode());
            orgCodeSet.add(vo.getSalesOrgCode());
            customerCodeSet.add(vo.getCustomerCode());
            if (!StringUtils.isNotBlank((CharSequence)vo.getProductCode())) continue;
            productCodeSet.add(vo.getProductCode());
        }
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList(MDM_BUSINESS_FORMAT, MDM_BUSINESS_UNIT));
        List channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet));
        if (!CollectionUtils.isEmpty((Collection)channelList)) {
            channelVoMap = channelList.stream().collect(Collectors.toMap(e -> e.getCustomerChannelCode(), Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)(orgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(orgCodeSet))))) {
            orgVoMap = orgVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.groupingBy(e -> e.getErpCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)(productList = this.productVoService.findByProductCodes(new ArrayList(productCodeSet))))) {
            productMap = productList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        }
        for (Map.Entry<Integer, WithholdingDetailEstoreImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            WithholdingDetailEstoreImportVo vo = row.getValue();
            DictDataVo businessFormat = ((List)dictDataMap.get(MDM_BUSINESS_FORMAT)).stream().filter(e -> e.getDictValue().equals(vo.getBusinessFormatCode())).findFirst().orElse(null);
            if (businessFormat != null) {
                vo.setBusinessFormatCode(businessFormat.getDictCode());
            } else {
                this.validateIsTrue(false, "\u4e1a\u6001\u3010" + vo.getBusinessFormatCode() + "\u3011\u9519\u8bef!");
            }
            DictDataVo businessUnit = ((List)dictDataMap.get(MDM_BUSINESS_UNIT)).stream().filter(e -> e.getDictValue().equals(vo.getBusinessUnitCode())).findFirst().orElse(null);
            if (businessUnit != null) {
                vo.setBusinessUnitCode(businessUnit.getDictCode());
            } else {
                this.validateIsTrue(false, "\u4e1a\u52a1\u5355\u5143\u3010" + vo.getBusinessUnitCode() + "\u3011\u9519\u8bef!");
            }
            if (channelVoMap.containsKey(vo.getChannelCode())) {
                vo.setChannelName(((CustomerChannelVo)channelVoMap.get(vo.getChannelCode())).getCustomerChannelName());
            } else {
                this.validateIsTrue(false, "\u6e20\u9053\u7f16\u7801\u3010" + vo.getChannelCode() + "\u3011\u9519\u8bef\uff01");
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getProductCode()) && productMap.containsKey(vo.getProductCode())) {
                vo.setProductName(((ProductVo)productMap.get(vo.getProductCode())).getProductName());
            } else {
                this.validateIsTrue(false, "\u4ea7\u54c1\u7f16\u7801\u3010" + vo.getProductCode() + "\u3011\u9519\u8bef\uff01");
            }
            SalesOrgVo salesOrgVo = null;
            if (orgVoMap.containsKey(vo.getSalesOrgCode())) {
                List orgList = (List)orgVoMap.get(vo.getSalesOrgCode());
                salesOrgVo = orgList.stream().filter(e -> vo.getChannelCode().equals(e.getChannelCode()) && vo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                if (salesOrgVo == null) {
                    this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u3010" + vo.getSalesOrgCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u9500\u552e\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    vo.setSalesOrgCode(salesOrgVo.getSalesOrgCode());
                    vo.setSalesOrgErpCode(salesOrgVo.getErpCode());
                    vo.setSalesOrgName(salesOrgVo.getSalesOrgName());
                }
            } else {
                this.validateIsTrue(false, "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u3010" + vo.getSalesOrgCode() + "\u3011\u9519\u8bef\uff01");
            }
            if (customerVoMap.containsKey(vo.getCustomerCode())) {
                SalesOrgVo finalSalesOrgVo = salesOrgVo;
                List customerList = (List)customerVoMap.get(vo.getCustomerCode());
                if (finalSalesOrgVo != null) {
                    CustomerVo customerVo = customerList.stream().filter(e -> vo.getChannelCode().equals(e.getCustomerChannelCode()) && finalSalesOrgVo.getErpCode().equals(e.getSalesInstitutionErpCode()) && vo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                    if (customerVo == null) {
                        this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + vo.getCustomerCode() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff0c\u8bf7\u68c0\u67e5\uff01");
                    } else {
                        vo.setCustomerCode(customerVo.getCustomerCode());
                        vo.setCustomerErpCode(customerVo.getErpCode());
                        vo.setCustomerName(customerVo.getCustomerName());
                    }
                }
            } else {
                this.validateIsTrue(false, "\u5ba2\u6237\u7f16\u7801\u3010" + vo.getCustomerCode() + "\u3011\u9519\u8bef\uff01");
            }
            String uniqueKey = vo.getBusinessUnitCode() + vo.getBusinessFormatCode() + vo.getChannelCode() + vo.getFeeYearMonth() + vo.getCustomerErpCode() + vo.getProductCode();
            if (uniqueKeySet.contains(uniqueKey)) {
                this.validateIsTrue(false, "\u8be5\u6761\u6570\u636e\u5728\u5f53\u524d\u5bfc\u5165\u6a21\u677f\u4e2d\u6709\u91cd\u590d\u6570\u636e\uff01");
            }
            uniqueKeySet.add(uniqueKey);
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                errMap.put(rowNum, errInfo);
            }
            TpmWithholdingDetailDto dto = (TpmWithholdingDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, TpmWithholdingDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            dto.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.ONLINE_RETAILERS_WITHHOLDING.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setWithholdingType(TpmWithholdingDetailTypeEnum.MANUAL_WITHHOLDING.getCode());
            dto.setWithholdingYearMonth(DateUtil.getDate((String)"yyyy-MM"));
            dto.generateUniqueMd5Key();
            dto.setUniqueKeyDs(uniqueKey);
            list.add(dto);
        }
        if (errMap.isEmpty()) {
            ((TpmWithholdingDetailDto)list.get(0)).setUniqueKeyDsList(new ArrayList(uniqueKeySet));
            this.tpmWithholdingDetailService.saveImport(list);
        }
        return errMap;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, WithholdingDetailEstoreImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, WithholdingDetailEstoreImportVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            WithholdingDetailEstoreImportVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessUnitCode()), "\u4e1a\u52a1\u5355\u5143\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesOrgCode()), "\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getFeeYearMonth()), "\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u5fc5\u586b!");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()), "\u5ba2\u6237\u7f16\u7801\u5fc5\u586b!");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Class<WithholdingDetailEstoreImportVo> findCrmExcelVoClass() {
        return WithholdingDetailEstoreImportVo.class;
    }

    public String getTemplateCode() {
        return "WITHHOLDING_DETAIL_ESTORE_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7535\u5546\u8d39\u7528\u6682\u4f30\u5bfc\u5165\u6a21\u677f";
    }

    public String getBusinessCode() {
        return "WITHHOLDING_DETAIL_IMPORTS";
    }

    public String getBusinessName() {
        return "TPM\u9884\u63d0\u660e\u7ec6\u5bfc\u5165";
    }
}

