/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.task;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailRedoWithholdingDto;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailActivityDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailPrepaymentDetailPartService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.service.TpmWithholdingDetailService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmWithholdingDetailTaskConfig {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailTaskConfig.class);
    @Autowired(required=false)
    private TpmWithholdingDetailActivityDetailPartService tpmWithholdingDetailActivityDetailPartService;
    @Autowired(required=false)
    private TpmWithholdingDetailPrepaymentDetailPartService tpmWithholdingDetailPrepaymentDetailPartService;
    @Autowired(required=false)
    private TpmWithholdingDetailService tpmWithholdingDetailService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @DynamicTaskService(cornExpression="0 0 12 1 * ?", taskDesc="\u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1")
    public void verticalTask() {
        log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1  start <----");
        TpmWithholdingDetailRedoWithholdingDto dto = new TpmWithholdingDetailRedoWithholdingDto();
        String withholdingYearMonth = DateUtil.format((Date)DateUtil.dateAddMonth((Date)new Date(), (Integer)-1), (String)"yyyy-MM");
        dto.setWithholdingYearMonth(withholdingYearMonth);
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        CompletableFuture.runAsync(() -> {
            log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 \u8d39\u7528\u6c60\u9884\u63d0  start <----");
            this.loginUserService.refreshAuthentication(null);
            FacturerUserDetails userDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            this.tpmWithholdingDetailService.saveFeePoolWithholding(withholdingYearMonth, JSON.parseObject((String)JSON.toJSONString((Object)userDetails)), dto);
            log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 \u8d39\u7528\u6c60\u9884\u63d0  end <----");
        });
        CompletableFuture.runAsync(() -> {
            log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 \u6d3b\u52a8\u9884\u63d0  start <----");
            this.loginUserService.refreshAuthentication(null);
            TpmWithholdingDetailRedoWithholdingDto actDto = new TpmWithholdingDetailRedoWithholdingDto();
            actDto.setWithholdingYearMonth(withholdingYearMonth);
            actDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            Date date = DateUtil.parse((String)(dto.getWithholdingYearMonth() + "-01"), (String)"yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(2, 1);
            actDto.setEndDate(DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd"));
            this.tpmWithholdingDetailActivityDetailPartService.redoWithholding(actDto);
            log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 \u6d3b\u52a8\u9884\u63d0  end <----");
        });
        CompletableFuture.runAsync(() -> {
            log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 \u9884\u4ed8\u9884\u63d0  start <----");
            this.loginUserService.refreshAuthentication(null);
            this.tpmWithholdingDetailPrepaymentDetailPartService.redoWithholding(dto);
            log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 \u9884\u4ed8\u9884\u63d0  end <----");
        });
        log.info("----> \u5782\u76f4\u7cfb\u7edf\u9884\u63d0\u5b9a\u65f6\u4efb\u52a1 end <----");
    }
}

