/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.util;

import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterWithholdingDetailDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.ICostCenterRelationVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TpmWithholdingDetailCostCenterUtil {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailCostCenterUtil.class);
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ICostCenterRelationVoService iCostCenterRelationVoService;

    public Map<String, CostCenterRelationVo> getCostCenter(List<TpmWithholdingDetailDto> detailDtos, String expenseCenter) {
        try {
            HashMap<String, CostCenterRelationVo> costCenterMap = new HashMap<String, CostCenterRelationVo>();
            Map<String, CostCenterRelationVo> verticalCostCenterMap = this.getVerticalCostCenter(detailDtos, expenseCenter);
            Map<String, CostCenterRelationVo> otherCostCenterMap = this.getOtherCostCenter(detailDtos);
            costCenterMap.putAll(verticalCostCenterMap);
            costCenterMap.putAll(otherCostCenterMap);
            return costCenterMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u6210\u672c\u4e2d\u5fc3\u5f02\u5e38\uff1a" + e.getMessage());
            return Maps.newHashMap();
        }
    }

    public Map<String, CostCenterRelationVo> getVerticalCostCenter(List<TpmWithholdingDetailDto> detailDtos, String expenseCenter) {
        List<TpmWithholdingDetailDto> filterVos = detailDtos.stream().filter(e -> StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterVos)) {
            return Maps.newHashMap();
        }
        filterVos = filterVos.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getRegion()) && StringUtils.isNotEmpty((CharSequence)item.getResaleCommercialCode()) && (StringUtils.isNotEmpty((CharSequence)expenseCenter) || StringUtils.isNotEmpty((CharSequence)item.getActivityTypeCode()))).collect(Collectors.toList());
        log.error("\u9884\u63d0\u660e\u7ec6\u6620\u5c04\u6210\u672c\u4e2d\u5fc3(\u5782\u76f4)=====\u300b\u533a\u57df+\u96f6\u552e\u5546+\u6d3b\u52a8\u7c7b\u578b\u8fc7\u6ee4======\u300b{}", (Object)filterVos.size());
        if (CollectionUtils.isEmpty(filterVos)) {
            return Maps.newHashMap();
        }
        if (StringUtils.isEmpty((CharSequence)expenseCenter)) {
            filterVos = this.filterCostCenterNull(filterVos);
            log.error("\u9884\u63d0\u660e\u7ec6\u6620\u5c04\u6210\u672c\u4e2d\u5fc3(\u5782\u76f4)=====\u300b\u8d39\u7528\u4e2d\u5fc3\u8fc7\u6ee4======\u300b{}", (Object)filterVos.size());
            if (CollectionUtils.isEmpty(filterVos)) {
                return Maps.newHashMap();
            }
        } else {
            filterVos.forEach(e -> e.setExpenseCenter(expenseCenter));
        }
        HashSet verticalMatchKeys = new HashSet();
        filterVos.forEach(e -> {
            String key = e.getRegion() + e.getResaleCommercialCode() + e.getExpenseCenter();
            verticalMatchKeys.add(key);
        });
        CostCenterWithholdingDetailDto detailDto = new CostCenterWithholdingDetailDto();
        detailDto.setBusinessFormatCode(filterVos.get(0).getBusinessFormatCode());
        detailDto.setBusinessUnitCode(filterVos.get(0).getBusinessUnitCode());
        detailDto.setVerticalMatchKeys(verticalMatchKeys);
        Map mmp = this.iCostCenterRelationVoService.withholdingDetailMap(detailDto);
        if (MapUtils.isEmpty((Map)mmp)) {
            log.error("\u9884\u63d0\u660e\u7ec6\u6620\u5c04\u6210\u672c\u4e2d\u5fc3(\u5782\u76f4)=====\u300b\u67e5\u8be2\u6210\u672c\u4e2d\u5fc3\u8fd4\u56de======\u300b\u7a7a");
            return Maps.newHashMap();
        }
        HashMap<String, CostCenterRelationVo> map = new HashMap<String, CostCenterRelationVo>();
        filterVos.forEach(e -> {
            CostCenterRelationVo vo;
            String key = e.getRegion() + e.getResaleCommercialCode() + e.getExpenseCenter();
            CostCenterRelationVo costCenterRelationVo = vo = mmp.containsKey(key) ? (CostCenterRelationVo)((List)mmp.get(key)).get(0) : null;
            if (Objects.nonNull(vo)) {
                map.put(e.getActivityDetailCode(), vo);
            }
        });
        return map;
    }

    public Map<String, CostCenterRelationVo> getOtherCostCenter(List<TpmWithholdingDetailDto> detailDtos) {
        List<TpmWithholdingDetailDto> filterVos = detailDtos.stream().filter(e -> !StringUtils.equals((CharSequence)BusinessUnitEnum.VERTICAL.getCode(), (CharSequence)e.getBusinessUnitCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterVos)) {
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty(filterVos = filterVos.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCustomerCode()) || StringUtils.isNotEmpty((CharSequence)item.getActivityTypeCode()) || StringUtils.isNotEmpty((CharSequence)item.getSalesGroupCode()) || StringUtils.isNotEmpty((CharSequence)item.getSalesRegionCode()) || StringUtils.isNotEmpty((CharSequence)item.getSalesInstitutionCode())).collect(Collectors.toList()))) {
            return Maps.newHashMap();
        }
        if (CollectionUtils.isEmpty(filterVos = this.filterCostCenterNull(filterVos))) {
            return Maps.newHashMap();
        }
        HashSet cusCostCenterKeys = new HashSet();
        HashSet customerCodeKeys = new HashSet();
        HashSet groupCodeKeys = new HashSet();
        HashSet departCodeKeys = new HashSet();
        HashSet institutionCodeKeys = new HashSet();
        filterVos.forEach(e -> {
            if (StringUtils.isNotEmpty((CharSequence)e.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)e.getExpenseCenter())) {
                cusCostCenterKeys.add(e.getCustomerCode() + e.getExpenseCenter());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())) {
                customerCodeKeys.add(e.getCustomerCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getSalesGroupCode())) {
                groupCodeKeys.add(e.getSalesGroupCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getSalesRegionCode())) {
                departCodeKeys.add(e.getSalesRegionCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)e.getSalesInstitutionCode())) {
                institutionCodeKeys.add(e.getSalesInstitutionCode());
            }
        });
        CostCenterWithholdingDetailDto detailDto = new CostCenterWithholdingDetailDto();
        detailDto.setBusinessFormatCode(filterVos.get(0).getBusinessFormatCode());
        detailDto.setBusinessUnitCode(filterVos.get(0).getBusinessUnitCode());
        detailDto.setCusCostCenterKeys(cusCostCenterKeys);
        detailDto.setCustomerCodeKeys(customerCodeKeys);
        detailDto.setGroupCodeKeys(groupCodeKeys);
        detailDto.setDepartCodeKeys(departCodeKeys);
        detailDto.setInstitutionCodeKeys(institutionCodeKeys);
        Map mmp = this.iCostCenterRelationVoService.withholdingDetailMap(detailDto);
        HashMap<String, CostCenterRelationVo> map = new HashMap<String, CostCenterRelationVo>();
        filterVos.forEach(e -> {
            String key = null;
            CostCenterRelationVo vo = null;
            if (StringUtils.isNotEmpty((CharSequence)e.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)e.getExpenseCenter())) {
                key = e.getCustomerCode() + e.getExpenseCenter();
                CostCenterRelationVo costCenterRelationVo = vo = mmp.containsKey(key) ? (CostCenterRelationVo)((List)mmp.get(key)).get(0) : null;
            }
            if (Objects.isNull(vo) && StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())) {
                key = e.getCustomerCode();
                CostCenterRelationVo costCenterRelationVo = vo = mmp.containsKey(key) ? (CostCenterRelationVo)((List)mmp.get(key)).get(0) : null;
            }
            if (Objects.isNull(vo) && StringUtils.isNotEmpty((CharSequence)e.getSalesGroupCode())) {
                key = e.getSalesGroupCode();
                CostCenterRelationVo costCenterRelationVo = vo = mmp.containsKey(key) ? (CostCenterRelationVo)((List)mmp.get(key)).get(0) : null;
            }
            if (Objects.isNull(vo) && StringUtils.isNotEmpty((CharSequence)e.getSalesRegionCode())) {
                key = e.getSalesRegionCode();
                CostCenterRelationVo costCenterRelationVo = vo = mmp.containsKey(key) ? (CostCenterRelationVo)((List)mmp.get(key)).get(0) : null;
            }
            if (Objects.isNull(vo) && StringUtils.isNotEmpty((CharSequence)e.getSalesInstitutionCode())) {
                key = e.getSalesInstitutionCode();
                CostCenterRelationVo costCenterRelationVo = vo = mmp.containsKey(key) ? (CostCenterRelationVo)((List)mmp.get(key)).get(0) : null;
            }
            if (Objects.nonNull(vo)) {
                map.put(e.getActivityDetailCode(), vo);
            }
        });
        return map;
    }

    public List<TpmWithholdingDetailDto> filterCostCenterNull(List<TpmWithholdingDetailDto> itemVos) {
        List activityTypeCodeList = itemVos.stream().map(TpmWithholdingDetailDto::getActivityTypeCode).distinct().collect(Collectors.toList());
        List activityTypeVoList = this.activityTypeService.findByCodes(activityTypeCodeList);
        Map<String, String> expenseCenterMap = activityTypeVoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getExpenseCenter())).collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getExpenseCenter, (v1, v2) -> v2));
        return itemVos.stream().filter(e -> expenseCenterMap.containsKey(e.getActivityTypeCode())).peek(e -> e.setExpenseCenter((String)expenseCenterMap.get(e.getActivityTypeCode()))).collect(Collectors.toList());
    }
}

