/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.detail.local.util;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.withholding.detail.local.entity.TpmWithholdingDetailEntity;
import com.biz.crm.tpm.business.withholding.detail.local.mapper.TpmWithholdingDetailEntityMapper;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailCategoryEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTargetEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.constant.TpmWithholdingDetailTypeEnum;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailDto;
import com.biz.crm.tpm.business.withholding.detail.local.util.TpmWithholdingDetailCostCenterUtil;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TpmWithholdingDetailVerticalFeeBalanceUtil {
    private static final Logger log = LoggerFactory.getLogger(TpmWithholdingDetailVerticalFeeBalanceUtil.class);
    @Autowired(required=false)
    private TpmWithholdingDetailEntityMapper tpmWithholdingDetailEntityMapper;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmWithholdingDetailCostCenterUtil tpmWithholdingDetailCostCenterUtil;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;

    public Long getTotalBalance(String yearMonthStr, String systemCode, String region, String businessFormatCode) {
        return this.tpmWithholdingDetailEntityMapper.findBalanceTotal(yearMonthStr, systemCode, region, businessFormatCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void feeBalance(Long offSet, Long pageSize, String systemCode, String region, String businessFormatCode, String yearMonthStr, String ruleCode, Date date, JSONObject userJsonObject, UserIdentity loginUser) {
        List salesOrgVoList;
        this.loginUserService.refreshAuthentication((Object)loginUser);
        List<TpmWithholdingDetailEntity> list = this.tpmWithholdingDetailEntityMapper.findBalanceList(yearMonthStr, systemCode, region, businessFormatCode, offSet, pageSize);
        log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d\u9884\u63d0\u6267\u884c\u4e2d,{},{},{}", new Object[]{offSet, (long)pageSize, list.size()});
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(e -> e.setActivityDetailCode(UUID.randomUUID().toString().replace("-", "")));
        List dtoResultList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmWithholdingDetailEntity.class, TpmWithholdingDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, CostCenterRelationVo> costCenterMap = this.tpmWithholdingDetailCostCenterUtil.getCostCenter(dtoResultList, "1");
        Set salesOrgCodeSet = costCenterMap.values().stream().map(CostCenterRelationVo::getSalesInstitutionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        HashMap salesOrgVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(salesOrgCodeSet) && !CollectionUtils.isEmpty((Collection)(salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost((List)Lists.newArrayList(salesOrgCodeSet))))) {
            salesOrgVoMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity())));
        }
        list.forEach(v -> {
            if (costCenterMap.containsKey(v.getActivityDetailCode())) {
                CostCenterRelationVo vo = (CostCenterRelationVo)costCenterMap.get(v.getActivityDetailCode());
                v.setCostCenter(vo.getCostCenterCode());
                v.setCostCenterName(vo.getCostCenterName());
                v.setSalesOrgCode(vo.getSalesInstitutionCode());
                if (salesOrgVoMap.get(vo.getSalesInstitutionCode()) != null) {
                    SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(vo.getSalesInstitutionCode());
                    v.setSalesOrgName(salesOrgVo.getSalesOrgName());
                    v.setSalesOrgErpCode(salesOrgVo.getErpCode());
                    v.setSalesOrgLevel(salesOrgVo.getSalesOrgLevel());
                    v.setSalesInstitutionCode(salesOrgVo.getSalesInstitutionCode());
                    if (SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
                        v.setSalesRegionCode(salesOrgVo.getSalesOrgCode());
                    }
                    if (SalesOrgLevelTypeEnum.GROUP.getCode().equals(salesOrgVo.getSalesOrgLevel())) {
                        v.setSalesRegionCode(salesOrgVo.getSalesOrgCode());
                        v.setSalesGroupCode(salesOrgVo.getSalesOrgCode());
                    }
                }
            }
            v.setActivityDetailCode(null);
        });
        List withholdingCodeList = this.generateCodeService.generateCode("YTMX", list.size());
        String withholdingYearMonth = DateUtil.format((Date)DateUtils.addMonths((Date)DateUtil.parse((String)(yearMonthStr + "-01"), (String)"yyyy-MM"), (int)-1), (String)"yyyy-MM");
        ArrayList<TpmWithholdingDetailEntity> dataList = new ArrayList<TpmWithholdingDetailEntity>();
        int counter = 0;
        for (TpmWithholdingDetailEntity entity : list) {
            if (Objects.isNull(entity.getWithholdingAmount()) || BigDecimal.ZERO.compareTo(entity.getWithholdingAmount()) == 0) {
                log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d\u9884\u63d0\u6267\u884c\u4e2d,\u91d1\u989d\u4e3a0\u4e3a\u7a7a\u8df3\u8fc7");
                continue;
            }
            entity.setAdjustAmount(BigDecimal.ZERO);
            entity.setAfterAdjustAmount(entity.getWithholdingAmount());
            entity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            entity.setWithholdingYearMonth(withholdingYearMonth);
            entity.setWithholdingType(TpmWithholdingDetailTypeEnum.SYSTEM_WITHHOLDING.getCode());
            entity.setWithholdingDetailCode((String)withholdingCodeList.get(counter));
            entity.setCreateAccount(userJsonObject.getString("account"));
            entity.setCreateName(userJsonObject.getString("realName"));
            entity.setModifyAccount(userJsonObject.getString("account"));
            entity.setModifyName(userJsonObject.getString("realName"));
            entity.setCreateTime(date);
            entity.setModifyTime(date);
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setWithholdingTarget(TpmWithholdingDetailTargetEnum.DOWNWARD.getCode());
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
            entity.setWithholdingCategory(TpmWithholdingDetailCategoryEnum.FEE_POOL_WITHHOLDING.getCode());
            entity.setUniqueMd5Key(entity.generateUniqueMd5Key());
            dataList.add(entity);
            ++counter;
        }
        log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d\u9884\u63d0\u6267\u884c\u7ed3\u679c\uff1a{}\u6761", (Object)dataList.size());
        if (!CollectionUtils.isEmpty(dataList)) {
            String lock = "withholding:detail:activity:detail:plan";
            boolean lockFlag = false;
            try {
                lockFlag = this.redisLockService.tryLock(lock, TimeUnit.SECONDS, 10L);
                if (lockFlag) {
                    this.tpmWithholdingDetailEntityMapper.insertList(dataList);
                    log.error("\u9884\u63d0\u660e\u7ec6-\u8d39\u7528\u6c60\u4f59\u989d\u9884\u63d0\u6267\u884c\u7ed3\u675f,{},{}", (Object)offSet, (Object)list.size());
                }
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            finally {
                if (lockFlag) {
                    this.redisLockService.unlock(lock);
                }
            }
        }
    }
}

