package com.biz.crm.tpm.business.withholding.detail.local.sdk.constant;

/**
 * @ClassName TpmWithholdingDetailCategoryEnum
 * @Description
 * @Author: jiangyin
 * @Date 2022/12/19
 */
public enum TpmWithholdingDetailCategoryEnum {

    ONLINE_RETAILERS_WITHHOLDING("1", "1", "电商预提规则"),
    LARGE_DATE_WITHHOLDING("2", "2", "分子公司大日期预提规则"),
    VERTICAL_RECEIVABLE_WITHHOLDING("3", "3", "垂直应收预提规则"),
    ACTIVITY_WITHHOLDING("4", "4", "活动预提"),
    FEE_POOL_WITHHOLDING("5", "5", "费用池预提"),
    PRE_PAY_WITHHOLDING("6", "6", "预付预提"),
    MANUAL_WITHHOLDING("7","7","手动预提");

    private String code;
    private String value;
    private String name;

    TpmWithholdingDetailCategoryEnum(String code, String value, String name){
        this.code = code;
        this.value = value;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }

    public static TpmWithholdingDetailCategoryEnum codeToEnum(String code) {
        TpmWithholdingDetailCategoryEnum category = null;
        TpmWithholdingDetailCategoryEnum[] categoryList = values();
        int var3 = categoryList.length;

        for (TpmWithholdingDetailCategoryEnum categoryEnum : categoryList) {
            if (categoryEnum.code.equals(code)) {
                category = categoryEnum;
            }
        }
        return category;
    }
}
