package com.biz.crm.tpm.business.withholding.detail.local.sdk.dto;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @ClassName TpmWithholdingDetailRefreshImportDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/12/26
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel(value = "预提明细更新导入数据传输类")
public class TpmWithholdingDetailRefreshImportDto extends CrmExcelVo {

    /**
     * 预提明细编号
     */
    @CrmExcelColumn(value = "预提明细编号", order = 0)
    @ApiModelProperty(value = "预提明细编号", notes = "")
    private String withholdingDetailCode;
    /**
     * 预提年月
     */
    @CrmExcelColumn(value = "预提年月", order = 1)
    @ApiModelProperty(value = "预提年月", notes = "")
    private String withholdingYearMonth;
    /**
     * 费用所属年月
     */
    @CrmExcelColumn(value = "费用所属年月", order = 2)
    @ApiModelProperty(value = "费用所属年月", notes = "")
    private String feeYearMonth;
    /**
     * 活动明细编码
     */
    @CrmExcelColumn(value = "活动明细编码", order = 3)
    @ApiModelProperty(value = "活动明细编码", notes = "")
    private String activityDetailCode;
    /**
     * 活动类型编码
     */
    @CrmExcelColumn(value = "活动类型编码", order = 4)
    @ApiModelProperty(value = "活动类型编码", notes = "")
    private String activityTypeCode;
    /**
     * 活动形式名称
     */
    @CrmExcelColumn(value = "活动形式名称", order = 5)
    @ApiModelProperty(value = "活动形式名称", notes = "")
    private String activityFormName;
    /**
     * 活动申请金额(字符串)
     */
    @CrmExcelColumn(value = "活动申请金额", order = 6)
    @ApiModelProperty(value = "活动申请金额(字符串)", notes = "")
    private String activityApplyAmountStr;
    /**
     * 细案预测金额(字符串)
     */
    @CrmExcelColumn(value = "细案预测金额", order = 7)
    @ApiModelProperty(value = "细案预测金额(字符串)", notes = "")
    private String predictAmountStr;
    /**
     * 本次预提金额(字符串)
     */
    @CrmExcelColumn(value = "本次预提金额", order = 8)
    @ApiModelProperty(value = "本次预提金额(字符串)", notes = "")
    private String withholdingAmountStr;
    /**
     * 调整后金额(字符串)
     */
    @CrmExcelColumn(value = "调整后金额", order = 9)
    @ApiModelProperty(value = "调整后金额(字符串)", notes = "")
    private String afterAdjustAmountStr;
    /**
     * 调整原因
     */
    @CrmExcelColumn(value = "调整原因", order = 10)
    @ApiModelProperty(value = "调整原因", notes = "")
    private String adjustReason;

    /**
     * 导入参数校验
     * @param
     * @author jiangyin
     * @date 2022/12/26 15:01
     * @return boolean
     */
    public boolean validate(){
        return StringUtils.isNotEmpty(this.withholdingDetailCode) && StringUtils.isNotEmpty(this.afterAdjustAmountStr) && StringUtils.isNotEmpty(this.adjustReason);
    }

}
