package com.biz.crm.tpm.business.withholding.detail.local.sdk.event;

import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.TpmWithholdingDetailLogDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @ClassName TpmWithholdingDetailLogEventListener
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/12
 */
public interface TpmWithholdingDetailLogEventListener extends NebulaEvent {

    /**
     * 当业务单元创建时触发
     *
     * @param dto
     */
    default void onCreate(TpmWithholdingDetailLogDto dto) {
    }

    /**
     * 当业务单元修改时触发
     *
     * @param dto
     */
    default void onUpdate(TpmWithholdingDetailLogDto dto) {
    }

    /**
     * 当业务单元禁用时触发
     *
     * @param dto
     */
    default void onDisable(TpmWithholdingDetailLogDto dto) {
    }

    /**
     * 当业务单元启用时触发
     *
     * @param dto
     */
    default void onEnable(TpmWithholdingDetailLogDto dto) {
    }

    /**
     * 当业务单元删除时触发
     *
     * @param dto
     */
    default void onDelete(TpmWithholdingDetailLogDto dto) {
    }
}
