package com.biz.crm.tpm.business.withholding.detail.local.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * @author: yaoyongming
 * @date: 2023/8/28 16:13
 */
@Data
@CrmExcelImport(startRow = 2)
@ApiModel("电商预提导入VO")
public class WithholdingDetailEstoreImportVo extends CrmExcelVo {


    /**
     * 业务单元
     */
    @CrmExcelColumn("*业务单元")
    private String businessUnitCode;

    /**
     * 业态
     */
    @CrmExcelColumn("*业态")
    private String businessFormatCode;

    /**
     * 渠道
     */
    @CrmExcelColumn("渠道")
    private String channelName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("*渠道编码")
    private String channelCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn("销售组织名称")
    private String salesOrgName;

    /**
     * 销售组织
     */
    @CrmExcelColumn("*销售组织编码")
    private String salesOrgCode;

    /**
     * 费用所属年月
     */
    @CrmExcelColumn("*费用所属年月")
    private String feeYearMonth;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;


    /**
     * 产品编码
     */
    @CrmExcelColumn("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;
    
    /**
     * 本次预提金额
     */
    @CrmExcelColumn("本次预提金额")
    private BigDecimal withholdingAmount;



    /**
     * 客户erp编码
     */
    private String customerErpCode;

    /**
     * 销售组织erp编码
     */
    private String salesOrgErpCode;
}
