package com.biz.crm.tpm.business.withholding.summary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Getter
@Setter
@ApiModel(value = "WithholdingSummaryDetailEntity", description = "预提汇总明细表")
@TableName("tpm_withholding_summary_detail")
@Entity(name = "tpm_withholding_summary_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_summary_detail", comment = "预提汇总明细表")
@Table(name = "tpm_withholding_summary_detail", indexes = {
        @Index(name = "index1", columnList = "withholding_upload_code"),
        @Index(name = "index2", columnList = "withholding_detail_code", unique = true)
})
public class WithholdingSummaryDetailEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "预提上传编码", notes = "预提上传编码")
    @Column(name = "withholding_upload_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提上传编码'")
    private String withholdingUploadCode;

    @ApiModelProperty(name = "预提明细编号", notes = "预提明细编号")
    @Column(name = "withholding_detail_code", length = 60, columnDefinition = "varchar(60) unique COMMENT '预提明细编号'")
    private String withholdingDetailCode;

    @ApiModelProperty(name = "业务细类编码", notes = "业务细类编码")
    @Column(name = "business_exp_item", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务细类编码'")
    private String businessExpItem;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sale_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String saleOrgName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 512, columnDefinition = "varchar(512) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 128, columnDefinition = "varchar(128) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "varchar(256) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "客商分类编码", notes = "客商分类编码")
    @Column(name = "customer_classify_code", length = 128, columnDefinition = "varchar(128) COMMENT '客商分类编码'")
    private String customerClassifyCode;

    @ApiModelProperty(name = "客商分类名称", notes = "客商分类名称")
    @Column(name = "customer_classify_name", length = 255, columnDefinition = "varchar(255) COMMENT '客商分类名称'")
    private String customerClassifyName;

    @ApiModelProperty(name = "客商编码", notes = "客商编码")
    @Column(name = "supplier_code", length = 128, columnDefinition = "varchar(128) COMMENT '客商编码'")
    private String supplierCode;

    @ApiModelProperty(name = "客商名称", notes = "客商名称")
    @Column(name = "supplier_name", length = 256, columnDefinition = "varchar(256) COMMENT '客商名称'")
    private String supplierName;

    @ApiModelProperty(name = "成本中心", notes = "成本中心")
    @Column(name = "cost_center", length = 128, columnDefinition = "VARCHAR(128) COMMENT '成本中心'")
    private String costCenter;

    @ApiModelProperty(name = "成本中心名称", notes = "成本中心名称")
    @Column(name = "cost_center_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '成本中心名称'")
    private String costCenterName;

    @ApiModelProperty(name = "不含税金额", notes = "不含税金额")
    @Column(name = "withholding_amount", columnDefinition = "decimal(16,6) COMMENT '不含税金额'")
    private BigDecimal withholdingAmount;

    @ApiModelProperty(name = "暂估税金", notes = "暂估税金")
    @Column(name = "estimate_tax_amount", columnDefinition = "decimal(16,6) COMMENT '暂估税金'")
    private BigDecimal estimateTaxAmount;

    @ApiModelProperty(name = "价税合计", notes = "价税合计")
    @Column(name = "withholding_tax_amount", columnDefinition = "decimal(16,6) COMMENT '价税合计'")
    private BigDecimal withholdingTaxAmount;

    @ApiModelProperty(name = "特别总账标识", notes = "特别总账标识")
    @Column(name = "special_tag", length = 64, columnDefinition = "VARCHAR(64) COMMENT '特别总账标识'")
    private String specialTag;

    @ApiModelProperty(name = "附件张数", notes = "附件张数")
    @Column(name = "attachment_num", columnDefinition = "decimal(16,0) COMMENT '附件张数'")
    private BigDecimal attachmentNum;

    @ApiModelProperty(value = "零售商编码", notes = "")
    @Column(name = "resale_commercial_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商编码'")
    private String resaleCommercialCode;

    @ApiModelProperty(value = "零售商名称", notes = "")
    @Column(name = "resale_commercial_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '零售商名称'")
    private String resaleCommercialName;

    @ApiModelProperty(value = "区域", notes = "")
    @Column(name = "region", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域'")
    private String region;

    @ApiModelProperty(value = "费用中心", notes = "")
    @Column(name = "fee_center", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用中心'")
    private String feeCenter;

    @ApiModelProperty(name = "数量", notes = "数量")
    @Column(name = "quantity", columnDefinition = "decimal(16,6) COMMENT '数量'")
    private BigDecimal quantity;

    @ApiModelProperty(name = "不含税单价", notes = "不含税单价")
    @Column(name = "price", columnDefinition = "decimal(16,8) COMMENT '不含税单价'")
    private BigDecimal price;

    @ApiModelProperty(name = "优惠金额", notes = "优惠金额")
    @Column(name = "promotion_amount", columnDefinition = "decimal(16,6) COMMENT '优惠金额'")
    private BigDecimal promotionAmount;

    @ApiModelProperty(value = "合同编号", notes = "")
    @Column(name = "contract_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合同编号'")
    private String contractCode;

    @ApiModelProperty(value = "合同名称", notes = "")
    @Column(name = "contract_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '合同名称'")
    private String contractName;
}
