package com.biz.crm.tpm.business.withholding.summary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Getter
@Setter
@ApiModel(value = "WithholdingSummaryEntity", description = "预提汇总主表")
@TableName("tpm_withholding_summary")
@Entity(name = "tpm_withholding_summary")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_summary", comment = "预提汇总主表")
@Table(name = "tpm_withholding_summary", indexes = {
        @Index(name = "index1", columnList = "withholding_formula_code"),
        @Index(name = "index2", columnList = "withholding_upload_code", unique = true)
})
public class WithholdingSummaryEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "预提汇总预提规则编码", notes = "预提汇总预提规则编码")
    @Column(name = "withholding_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提汇总预提规则编码'")
    private String withholdingFormulaCode;

    @ApiModelProperty(name = "预提汇总规则名称", notes = "预提汇总规则名称")
    @Column(name = "withholding_formula_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '预提汇总规则名称'")
    private String withholdingFormulaName;

    @ApiModelProperty(name = "state", notes = "状态")
    @Column(name = "state",  length = 64, columnDefinition = "VARCHAR(128) COMMENT '状态'")
    private String state;

    @ApiModelProperty(name = "预提上传编码", notes = "预提上传编码")
    @Column(name = "withholding_upload_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提上传编码'")
    private String withholdingUploadCode;

    @ApiModelProperty(name = "CE预提单号", notes = "CE预提单号")
    @Column(name = "withholding_ce_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT 'CE预提单号'")
    private String withholdingCeCode;

    @ApiModelProperty(name = "CE单据状态", notes = "CE单据状态")
    @Column(name = "ce_state",  length = 64, columnDefinition = "VARCHAR(128) COMMENT 'CE单据状态'")
    private String ceState;

    @ApiModelProperty(name = "会计凭证号", notes = "会计凭证号")
    @Column(name = "accounting_voucher_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '会计凭证号'")
    private String accountingVoucherCode;

    @ApiModelProperty(name = "利润中心", notes = "利润中心")
    @Column(name = "profit_center", length = 64, columnDefinition = "VARCHAR(64) COMMENT '利润中心 '")
    private String profitCenter;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "业务单元名称", notes = "业务单元名称")
    @Column(name = "business_unit_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '业务单元名称'")
    private String businessUnitName;

    @ApiModelProperty(value = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "varchar(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sale_org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String saleOrgName;

    @ApiModelProperty(name = "预提金额", notes = "预提金额")
    @Column(name = "withholding_amount",  columnDefinition = "decimal(24,6) COMMENT '预提金额'")
    private BigDecimal withholdingAmount;

    @ApiModelProperty(name = "预提年月", notes = "预提年月")
    @Column(name = "withholding_year_month", length = 20, columnDefinition = "varchar(20) COMMENT '预提年月'")
    private String withholdingYearMonth;

    @ApiModelProperty(name = "交易货币", notes = "交易货币")
    @Column(name = "trade_currency", length = 64, columnDefinition = "VARCHAR(64) COMMENT '交易货币'")
    private String tradeCurrency;

    @ApiModelProperty(name = "汇率", notes = "汇率")
    @Column(name = "exchange_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '汇率'")
    private BigDecimal exchangeRate;

    @ApiModelProperty(name = "业务大类", notes = "业务大类")
    @Column(name = "business_title", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务大类'")
    private String businessTitle;

    @ApiModelProperty(name = "业务大类", notes = "业务大类")
    @Column(name = "business_title_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务大类'")
    private String businessTitleName;

    @ApiModelProperty(name = "开支内容", notes = "开支内容")
    @Column(name = "expense_content", length = 400, columnDefinition = "varchar(400) COMMENT '开支内容'")
    private String expenseContent;

    @ApiModelProperty(name = "活动分类分组", notes = "活动分类分组")
    @Column(name = "activity_type_type", length = 64, columnDefinition = "varchar(64) COMMENT '活动分类分组'")
    private String activityTypeType;

    @ApiModelProperty(name = "费用中心", notes = "费用中心")
    @Column(name = "fee_center", length = 64, columnDefinition = "varchar(64) COMMENT '费用中心'")
    private String feeCenter;
    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;
}
