package com.biz.crm.tpm.business.withholding.summary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Getter
@Setter
@ApiModel(value = "WithholdingSummaryRDetailEntity", description = "预提汇总明细表")
@TableName("tpm_withholding_summary_r_detail")
@Entity(name = "tpm_withholding_summary_r_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_summary_r_detail", comment = "预提汇总明细关联预提明细表")
@Table(name = "tpm_withholding_summary_r_detail", indexes = {
        @Index(name = "index1", columnList = "withholding_upload_code"),
        @Index(name = "index2", columnList = "withholding_summary_detail_code"),
        @Index(name = "index3", columnList = "withholding_detail_code")
})
public class WithholdingSummaryRDetailEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "预提上传编码（预提汇总编码）", notes = "预提上传编码（预提汇总编码）")
    @Column(name = "withholding_upload_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提上传编码'")
    private String withholdingUploadCode;

    @ApiModelProperty(name = "预提汇总明细编号", notes = "预提汇总明细编号")
    @Column(name = "withholding_summary_detail_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提汇总明细编号'")
    private String withholdingSummaryDetailCode;

    @ApiModelProperty(name = "预提明细编号", notes = "预提明细编号")
    @Column(name = "withholding_detail_code", length = 60, columnDefinition = "varchar(60) COMMENT '预提明细编号'")
    private String withholdingDetailCode;

}
