package com.biz.crm.tpm.business.withholding.summary.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Getter
@Setter
@ApiModel(value = "WithholdingSummaryROrgEntity", description = "预提汇总关联销售组织表")
@TableName("tpm_withholding_summary_r_org")
@Entity(name = "tpm_withholding_summary_r_org")
@org.hibernate.annotations.Table(appliesTo = "tpm_withholding_summary_r_org", comment = "预提汇总关联销售组织表")
@Table(name = "tpm_withholding_summary_r_org", indexes = {
        @Index(name = "index1", columnList = "withholding_upload_code")
})
public class WithholdingSummaryROrgEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "预提上传编码", notes = "预提上传编码")
    @Column(name = "withholding_upload_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '预提上传编码'")
    private String withholdingUploadCode;

    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sale_org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String saleOrgName;
}
