package com.biz.crm.tpm.business.withholding.summary.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.TpmWithholdingDetailSummaryDetailRespVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import org.springframework.data.repository.query.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
public interface TpmWithholdingSummaryMapper extends BaseMapper<WithholdingSummaryEntity> {

    Page<WithholdingSummaryVo> findByConditions(@Param("page") Page<WithholdingSummaryVo> page, @Param("dto") WithholdingSummaryDto dto,
                                                @Param("tenantCode") String tenantCode);

    List<WithholdingSummaryFormulaVo> findHeadInfoByWithholdingFormulaCode(@Param("withholdingFormulaCode") String withholdingFormulaCode,
                                                                           @Param("tenantCode") String tenantCode);

    List<WithholdingSummaryROrgVo> findFormulaOrgInfoByWithholdingFormulaCode(@Param("withholdingFormulaCode") String withholdingFormulaCode,
                                                                              @Param("tenantCode") String tenantCode);

    List<TpmWithholdingDetailSummaryDetailRespVo> findWithholdingDetailByYearMonth(@Param("withholdingYearMonth") String withholdingYearMonth,
                                                                                   @Param("vo") WithholdingSummaryFormulaVo vo,
                                                                                   @Param("orgCodes") List<String> orgCodes,
                                                                                   @Param("tenantCode") String tenantCode);

    Page<WithholdingSummaryVo> findAutoSyncCeStateList(@Param("page") Page<WithholdingSummaryVo> page,
                                                       @Param("beginTime") Date beginTime,
                                                       @Param("endTime") Date endTime,
                                                       @Param("ids") List<String> ids,
                                                       @Param("tenantCode") String tenantCode);

    Long countSummaryDetail(@Param("dto") WithholdingSummaryDto dto,
                            @Param("vo") WithholdingSummaryFormulaVo vo,
                            @Param("orgCodes") List<String> orgCodes,
                            @Param("salesOrgLevel") String salesOrgLevel,
                            @Param("tenantCode") String tenantCode);

    List<TpmWithholdingDetailSummaryDetailRespVo> findWithholdingDetailList(@Param("dto") WithholdingSummaryDto dto,
                                                                            @Param("vo") WithholdingSummaryFormulaVo vo,
                                                                            @Param("orgCodes") List<String> orgCodes,
                                                                            @Param("salesOrgLevel") String salesOrgLevel,
                                                                            @Param("tenantCode") String tenantCode);
}
