package com.biz.crm.tpm.business.withholding.summary.local.process.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryConstant;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailExportVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Component
public class WithholdingSummaryDetailExportProcess implements ExportProcess<WithholdingSummaryDetailExportVo> {

    @Autowired(required = false)
    private WithholdingSummaryService withholdingSummaryService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        Integer total = withholdingSummaryService.getTotal((String) params.get("cacheKey"));
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull(params.get("cacheKey"), "缓存键，参数未传入");
        String cacheKey = (String) params.get("cacheKey");
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        Page<WithholdingSummaryDetailVo> cachePage = withholdingSummaryService.findCachePageList(pageable, cacheKey, null);
        if (cachePage.getSize() == 0) {
            return new JSONArray();
        }
        Collection<WithholdingSummaryDetailExportVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(cachePage.getRecords(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailExportVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        convertData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    @Override
    public Class<WithholdingSummaryDetailExportVo> findCrmExcelVoClass() {
        return WithholdingSummaryDetailExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "WITHHOLDING_SUMMARY_DETAIL_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM预提汇总明细导出";
    }

    //数据字典转换
    private void convertData(Collection<WithholdingSummaryDetailExportVo> data) {
        Map<String, String> businessExpItemMap = dictToolkitService.findMapByDictTypeCode(WithholdingSummaryConstant.TPM_ACCRUED_ACCOUNT);
        for (WithholdingSummaryDetailExportVo vo : data) {
            if (StringUtils.isNotBlank(vo.getBusinessExpItem())) {
                vo.setBusinessExpItem(businessExpItemMap.getOrDefault(vo.getBusinessExpItem(), vo.getBusinessExpItem()));
            }
        }
    }
}
