package com.biz.crm.tpm.business.withholding.summary.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 预提会中查询表单注册
 * @ClassName TpmWithholdingDetailReportRegister
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/9
 */
@Component
@Slf4j
public class TpmWithholdingDetailReportRegister implements DataviewRegister {

    @Override
    public String code() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String desc() {
        return "TPM-预提汇总查询表";
    }

    @Override
    public String buildSql() {
        return "select " +
                " t.*, " +
                " t1.summary_code, " +
                " case  " +
                " when t1.summary_code is null then 'N' " +
                " when t1.summary_code = '' then 'N' " +
                " else 'Y' end as summary_flag " +
                "from tpm_withholding_detail t " +
                "left join( " +
                "select  " +
                "trd.withholding_detail_code, " +
                "group_concat(trd.withholding_upload_code) summary_code " +
                "from tpm_withholding_summary_r_detail trd  " +
                "where trd.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "group by trd.withholding_detail_code " +
                ")t1 on t.withholding_detail_code = t1.withholding_detail_code " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
