package com.biz.crm.tpm.business.withholding.summary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryROrgEntity;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryDetailMapper;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryMapper;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.TpmWithholdingDetailSummaryDetailRespVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Component
public class TpmWithholdingSummaryDetailRepository extends ServiceImpl<TpmWithholdingSummaryDetailMapper, WithholdingSummaryDetailEntity> {

    @Autowired(required = false)
    private TpmWithholdingSummaryDetailMapper tpmWithholdingSummaryDetailMapper;

    /**
     * 批量生成关系表
     *
     * @param withholdingYearMonth
     * @param withholdingSummaryFormulaVo
     * @param orgCodes
     * @param salesOrgLevel
     * @param withholdingUploadCode
     * @param loginUser
     */
    public void insertRData(String withholdingYearMonth,
                            WithholdingSummaryFormulaVo withholdingSummaryFormulaVo,
                            List<String> orgCodes,
                            String salesOrgLevel,
                            String activityTypeType,
                            String withholdingUploadCode,
                            AbstractCrmUserIdentity loginUser) {
        tpmWithholdingSummaryDetailMapper.insertRData(withholdingYearMonth, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel, activityTypeType, TenantUtils.getTenantCode(), withholdingUploadCode, loginUser);
    }

    public List<WithholdingSummaryDetailEntity> findByWithholdingUploadCode(String withholdingUploadCode) {
        return this.lambdaQuery()
                .eq(WithholdingSummaryDetailEntity::getWithholdingUploadCode, withholdingUploadCode)
                .eq(WithholdingSummaryDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByAsc(WithholdingSummaryDetailEntity::getWithholdingDetailCode).list();
    }

    public void removeByWithholdingUploadCode(String withholdingUploadCode) {
        this.lambdaUpdate()
                .eq(WithholdingSummaryDetailEntity::getWithholdingUploadCode, withholdingUploadCode)
                .eq(WithholdingSummaryDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(WithholdingSummaryDetailEntity::getTenantCode, TenantUtils.getTenantCode())
                .remove();
    }
}
