package com.biz.crm.tpm.business.withholding.summary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryRDetailEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryROrgEntity;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryDetailMapper;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryRDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Component
public class TpmWithholdingSummaryRDetailRepository extends ServiceImpl<TpmWithholdingSummaryRDetailMapper, WithholdingSummaryRDetailEntity> {

    public void removeByWithholdingUploadCode(String withholdingUploadCode) {
        this.lambdaUpdate()
                .eq(WithholdingSummaryRDetailEntity::getWithholdingUploadCode, withholdingUploadCode)
                .eq(WithholdingSummaryRDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(WithholdingSummaryRDetailEntity::getTenantCode, TenantUtils.getTenantCode())
                .remove();
    }
}
