package com.biz.crm.tpm.business.withholding.summary.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryROrgEntity;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryROrgMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Component
public class TpmWithholdingSummaryROrgRepository extends ServiceImpl<TpmWithholdingSummaryROrgMapper, WithholdingSummaryROrgEntity> {

    public List<WithholdingSummaryROrgEntity> findByWithholdingUploadCode(String withholdingUploadCode) {
        return this.lambdaQuery()
                .eq(WithholdingSummaryROrgEntity::getWithholdingUploadCode, withholdingUploadCode)
                .eq(WithholdingSummaryROrgEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .orderByAsc(WithholdingSummaryROrgEntity::getSalesOrgCode).list();

    }

    public void removeByWithholdingUploadCode(String withholdingUploadCode) {
        this.lambdaUpdate()
                .eq(WithholdingSummaryROrgEntity::getWithholdingUploadCode, withholdingUploadCode)
                .eq(WithholdingSummaryROrgEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(WithholdingSummaryROrgEntity::getTenantCode, TenantUtils.getTenantCode())
                .remove();
    }
}
