package com.biz.crm.tpm.business.withholding.summary.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.withholding.summary.local.entity.WithholdingSummaryEntity;
import com.biz.crm.tpm.business.withholding.summary.local.mapper.TpmWithholdingSummaryMapper;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.TpmWithholdingDetailSummaryDetailRespVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Component
public class TpmWithholdingSummaryRepository extends ServiceImpl<TpmWithholdingSummaryMapper, WithholdingSummaryEntity> {

    @Autowired(required = false)
    private TpmWithholdingSummaryMapper tpmWithholdingSummaryMapper;

    public Page<WithholdingSummaryVo> findByConditions(Pageable pageable, WithholdingSummaryDto dto) {
        Page<WithholdingSummaryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<WithholdingSummaryVo> pageList = this.tpmWithholdingSummaryMapper.findByConditions(page, dto, TenantUtils.getTenantCode());
        return pageList;
    }

    /**
     * 通过汇总规则编码查汇总规则信息作为汇总数据基本信息
     *
     * @param withholdingFormulaCode
     * @return
     */
    public WithholdingSummaryFormulaVo findHeadInfoByWithholdingFormulaCode(String withholdingFormulaCode) {
        List<WithholdingSummaryFormulaVo> list = this.tpmWithholdingSummaryMapper.findHeadInfoByWithholdingFormulaCode(withholdingFormulaCode, TenantUtils.getTenantCode());
        WithholdingSummaryFormulaVo summaryFormulaVo = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        if (Objects.nonNull(summaryFormulaVo)) {
            List<WithholdingSummaryROrgVo> orgVoList = this.tpmWithholdingSummaryMapper.findFormulaOrgInfoByWithholdingFormulaCode(summaryFormulaVo.getWithholdingFormulaCode(), TenantUtils.getTenantCode());
            summaryFormulaVo.setOrgVoList(orgVoList);
        }
        return summaryFormulaVo;
    }

    /**
     * 通过年月查询已通过审批的预提明细数据
     *
     * @param withholdingYearMonth
     * @param withholdingSummaryFormulaVo
     * @return
     */
    public List<TpmWithholdingDetailSummaryDetailRespVo> findWithholdingDetailByYearMonth(String withholdingYearMonth, WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<String> orgCodes) {
        return this.tpmWithholdingSummaryMapper.findWithholdingDetailByYearMonth(withholdingYearMonth, withholdingSummaryFormulaVo, orgCodes, TenantUtils.getTenantCode());
    }

    /**
     * 定时任务同步CE单据状态分页查询已上传数据
     *
     * @param pageable
     * @param beginTime 提交开始时间
     * @param endTime   提交截止时间
     * @param ids       id集合
     * @return
     */
    public List<WithholdingSummaryVo> findAutoSyncCeStateList(Pageable pageable, Date beginTime, Date endTime, List<String> ids) {
        Page<WithholdingSummaryVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmWithholdingSummaryMapper.findAutoSyncCeStateList(page, beginTime, endTime, ids, TenantUtils.getTenantCode()).getRecords();
    }

    /**
     * 通过年月查询已通过审批的预提明细数据
     *
     * @param dto
     * @param withholdingSummaryFormulaVo
     * @param orgCodes
     * @param salesOrgLevel
     * @return
     */
    public Long countSummaryDetail(WithholdingSummaryDto dto, WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<String> orgCodes, String salesOrgLevel) {
        return this.tpmWithholdingSummaryMapper.countSummaryDetail(dto, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel, TenantUtils.getTenantCode());
    }

    /**
     * 通过年月查询已通过审批的预提明细数据，并进行汇总
     *
     * @param dto
     * @param withholdingSummaryFormulaVo
     * @return
     */
    public List<TpmWithholdingDetailSummaryDetailRespVo> findWithholdingDetailList(WithholdingSummaryDto dto, WithholdingSummaryFormulaVo withholdingSummaryFormulaVo, List<String> orgCodes, String salesOrgLevel) {
        return this.tpmWithholdingSummaryMapper.findWithholdingDetailList(dto, withholdingSummaryFormulaVo, orgCodes, salesOrgLevel, TenantUtils.getTenantCode());
    }

    public WithholdingSummaryEntity findByWithholdingUploadCode(String withholdingUploadCode) {
        return this.lambdaQuery()
                .eq(WithholdingSummaryEntity::getWithholdingUploadCode, withholdingUploadCode)
                .eq(WithholdingSummaryEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(WithholdingSummaryEntity::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }

    public Integer countSummarySize(String withholdingFormulaCode, String withholdingYearMonth) {
        return this.lambdaQuery()
                .eq(WithholdingSummaryEntity::getWithholdingFormulaCode, withholdingFormulaCode)
                .eq(WithholdingSummaryEntity::getWithholdingYearMonth, withholdingYearMonth)
                .eq(WithholdingSummaryEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(WithholdingSummaryEntity::getTenantCode, TenantUtils.getTenantCode())
                .count();
    }

    public void updateCeInfo(WithholdingSummaryVo vo, String state, String ceState) {
        this.update(
                Wrappers.lambdaUpdate(WithholdingSummaryEntity.class)
                        .eq(WithholdingSummaryEntity::getId, vo.getId())
                        .set(WithholdingSummaryEntity::getState, state)
                        .set(WithholdingSummaryEntity::getCeState, ceState)
                        .set(WithholdingSummaryEntity::getAccountingVoucherCode, vo.getAccountingVoucherCode())
        );
    }
}
