package com.biz.crm.tpm.business.withholding.summary.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.BcBpmCeWithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.local.entity.*;
import com.biz.crm.tpm.business.withholding.summary.local.repository.*;
import com.biz.crm.tpm.business.withholding.summary.local.util.WithholdingSummaryUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryActivityTypeTypeEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryConstant;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryStateEnum;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.log.WithholdingSummaryLogEventDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.event.WithholdingSummaryEventListener;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryFormulaVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryROrgVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 * 预提汇总异步处理
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-04
 */
@Service
public class WithholdingSummaryAsyncService {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private TpmWithholdingSummaryRepository tpmWithholdingSummaryRepository;

    @Autowired(required = false)
    private TpmWithholdingSummaryROrgRepository tpmWithholdingSummaryROrgRepository;

    @Autowired(required = false)
    private TpmWithholdingSummaryDetailRepository tpmWithholdingSummaryDetailRepository;

    @Autowired(required = false)
    private TpmWithholdingSummaryRDetailRepository tpmWithholdingSummaryRDetailRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private BcBpmCeWithholdingSummaryService bcBpmCeWithholdingSummaryService;

    @Autowired(required = false)
    private WithholdingSummaryUtil withholdingSummaryUtil;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private WithholdingSummaryService withholdingSummaryService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    /**
     * 异步汇总（上一步已经做完所有必要校验，这一步不做任何校验）
     * 1、生成汇总上传编码
     * 2、预提汇总规则
     * 3、汇总预提明细，并返回预提总金额
     * 4、预提汇总头表
     * 5、预提汇总明细表
     * 6、清除预提汇总明细临时表
     * 7、预提汇总管理销售组织表
     *
     * @param dto
     * @param userIdentity
     */
    @Async
    @Transactional
    public void create(WithholdingSummaryDto dto, AbstractCrmUserIdentity userIdentity) {
        try {
            loginUserService.refreshAuthentication(userIdentity);

            //2、预提汇总规则
            WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(dto.getWithholdingFormulaCode());

            //3、汇总预提明细，并返回预提总金额
            List<WithholdingSummaryVo> withholdingSummaryVos = withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);

            //获取业务单元字典
            Map<String, String> unitMap = dictToolkitService.findMapByDictTypeCode(WithholdingSummaryConstant.MDM_BUSINESS_UNIT);

            withholdingSummaryVos.forEach(withholdingSummaryVo->{
                //4、预提汇总头表
                WithholdingSummaryEntity withholdingSummaryEntity = this.nebulaToolkitService.copyObjectByWhiteList(withholdingSummaryFormulaVo, WithholdingSummaryEntity.class, null, null);
                withholdingSummaryEntity.setWithholdingUploadCode(withholdingSummaryVo.getWithholdingUploadCode());
                withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
                withholdingSummaryEntity.setBusinessUnitName(unitMap.get(withholdingSummaryEntity.getBusinessUnitCode()));
                withholdingSummaryEntity.setWithholdingYearMonth(dto.getWithholdingYearMonth());
                withholdingSummaryEntity.setTradeCurrency(WithholdingSummaryConstant.TRADE_CURRENCY);
                withholdingSummaryEntity.setBusinessTitle(withholdingSummaryVo.getBusinessTitle());
                withholdingSummaryEntity.setBusinessTitleName(withholdingSummaryVo.getBusinessTitleName());
                withholdingSummaryEntity.setExchangeRate(BigDecimal.ONE);
                withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                withholdingSummaryEntity.setTenantCode(TenantUtils.getTenantCode());
                this.tpmWithholdingSummaryRepository.save(withholdingSummaryEntity);

                //5、预提汇总明细表
                this.tpmWithholdingSummaryDetailRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class));

                //6、预提汇总关联预提明细表
                List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
                List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
                tpmWithholdingSummaryDetailRepository.insertRData(
                        withholdingSummaryEntity.getWithholdingYearMonth(),
                        withholdingSummaryFormulaVo,
                        orgCodes,
                        withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo),
                        withholdingSummaryEntity.getActivityTypeType(),
                        withholdingSummaryEntity.getWithholdingUploadCode(),
                        loginUserService.getAbstractLoginUser());

                //7、预提汇总管理销售组织表
                List<WithholdingSummaryROrgEntity> orgEntities =
                        (List<WithholdingSummaryROrgEntity>) nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class);
                orgEntities.forEach(v -> v.setWithholdingUploadCode(withholdingSummaryVo.getWithholdingUploadCode()));
                this.tpmWithholdingSummaryROrgRepository.saveBatch(orgEntities);

                //新增业务日志
                WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
                logEventDto.setOriginal(null);
                logEventDto.setNewest(dto);
                SerializableBiConsumer<WithholdingSummaryEventListener, WithholdingSummaryLogEventDto> onCreate =
                        WithholdingSummaryEventListener::onCreate;
                this.nebulaNetEventClient.publish(logEventDto, WithholdingSummaryEventListener.class, onCreate);
            });
        } finally {
            String lockKey = WithholdingSummaryConstant.WITHHOLDING_SUMMARY_CREATE + dto.getWithholdingFormulaCode() + ":" + dto.getWithholdingYearMonth();
            redisLockService.unlock(lockKey);
        }
    }

    /**
     * 异步更新（上一步已经做完所有必要校验，这一步不做任何校验）
     * 1、查询原始汇总数据
     * 2、删除历史
     * 3、预提汇总规则
     * 4、汇总预提明细，并返回预提总金额
     * 5、更新主表
     * 6、预提汇总明细表
     * 7、清除预提汇总明细临时表
     * 8、预提汇总管理销售组织表
     * 9、删除明细缓存
     *
     * @param id
     * @param userIdentity
     */
    @Async
    @Transactional
    public void refresh(String id, AbstractCrmUserIdentity userIdentity) {

        try {
            loginUserService.refreshAuthentication(userIdentity);

            //1、查询原始汇总数据
            WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.getById(id);
            WithholdingSummaryVo oldVo = withholdingSummaryService.findById(id);

            //2、删除历史
            this.tpmWithholdingSummaryDetailRepository.remove(
                    Wrappers.lambdaUpdate(WithholdingSummaryDetailEntity.class)
                            .eq(WithholdingSummaryDetailEntity::getWithholdingUploadCode, withholdingSummaryEntity.getWithholdingUploadCode())
            );
            this.tpmWithholdingSummaryRDetailRepository.remove(
                    Wrappers.lambdaUpdate(WithholdingSummaryRDetailEntity.class)
                            .eq(WithholdingSummaryRDetailEntity::getWithholdingUploadCode, withholdingSummaryEntity.getWithholdingUploadCode())
            );
            this.tpmWithholdingSummaryROrgRepository.remove(
                    Wrappers.lambdaUpdate(WithholdingSummaryROrgEntity.class)
                            .eq(WithholdingSummaryROrgEntity::getWithholdingUploadCode, withholdingSummaryEntity.getWithholdingUploadCode())
            );

            //3、预提汇总规则
            WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());

            //4、汇总预提明细，并返回预提总金额
            WithholdingSummaryDto dto = new WithholdingSummaryDto();
            dto.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
            dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
            dto.setActivityTypeType(withholdingSummaryEntity.getActivityTypeType());
            List<WithholdingSummaryVo> withholdingSummaryVos = withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);
            WithholdingSummaryVo withholdingSummaryVo = withholdingSummaryVos.get(0);
            //5、更新主表
            withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
            withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.tpmWithholdingSummaryRepository.updateById(withholdingSummaryEntity);

            //6、预提汇总明细表
            this.tpmWithholdingSummaryDetailRepository.saveBatch(
                    nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class));

            //7、预提汇总关联预提明细表
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
            List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            tpmWithholdingSummaryDetailRepository.insertRData(
                    withholdingSummaryEntity.getWithholdingYearMonth(),
                    withholdingSummaryFormulaVo,
                    orgCodes,
                    withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo),
                    withholdingSummaryEntity.getActivityTypeType(),
                    withholdingSummaryEntity.getWithholdingUploadCode(),
                    loginUserService.getAbstractLoginUser());

            //8、预提汇总管理销售组织表
            List<WithholdingSummaryROrgEntity> orgEntities =
                    (List<WithholdingSummaryROrgEntity>) nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class);
            orgEntities.forEach(v -> v.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode()));
            this.tpmWithholdingSummaryROrgRepository.saveBatch(orgEntities);

            //9、删除明细缓存
            String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(withholdingSummaryEntity.getWithholdingUploadCode());
            redisService.del(redisCacheKey);//删掉重新放

            //更新业务日志
            WithholdingSummaryVo newVo = withholdingSummaryService.findById(id);
            WithholdingSummaryDto newDto = nebulaToolkitService.copyObjectByWhiteList(newVo, WithholdingSummaryDto.class, HashSet.class, ArrayList.class);
            if (CollectionUtils.isNotEmpty(newDto.getDetailDtoList())) {
                Collection<WithholdingSummaryDetailDto> newDetailList = nebulaToolkitService.copyCollectionByWhiteList(newVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailDto.class, HashSet.class, ArrayList.class);
                newDto.setDetailDtoList(Lists.newArrayList(newDetailList));
            }
            WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(newDto);
            SerializableBiConsumer<WithholdingSummaryEventListener, WithholdingSummaryLogEventDto> onUpdate =
                    WithholdingSummaryEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, WithholdingSummaryEventListener.class, onUpdate);
        } finally {
            String lockKey = WithholdingSummaryConstant.WITHHOLDING_SUMMARY_LOCK + id;
            redisLockService.unlock(lockKey);
        }
    }
}
