package com.biz.crm.tpm.business.withholding.summary.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.WithholdingSummaryConstant;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryJobParamDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * 同步CE单据状态
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class WithholdingSummaryCeStateAutoSyncXxlJob {

    @Autowired(required = false)
    private WithholdingSummaryService withholdingSummaryService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 同步CE单据状态定时任务 每个月2号到5号，每天同步一次
     */
    @DynamicTaskService(cornExpression = "0 0 2 2-5 * ?", taskDesc = "同步CE单据状态定时任务")
    public void autoSyncCeState() {
        log.info("=====>    同步CE单据状态[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        String lockKey = WithholdingSummaryConstant.WITHHOLDING_SUMMARY_AUTO_LOCK;
        try {
            Pageable page = PageRequest.of(1, 50);
            int index = 1;
            boolean hasLock = redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 60 * 60 * 12);
            if (!hasLock) {
                log.error("同步CE单据状态进行中！");
                return;
            }
            WithholdingSummaryJobParamDto dto = new WithholdingSummaryJobParamDto();
            while (true) {
                List<WithholdingSummaryVo> list = withholdingSummaryService.findAutoSyncCeStateList(page, dto);
                log.info("同步CE单据状态：第[{}]页查询到[{}]条数据！", index, list.size());
                if (CollectionUtils.isEmpty(list)) {
                    break;
                }
                int k = 1;
                for (WithholdingSummaryVo v : list) {
                    try {
                        withholdingSummaryService.autoSyncCeState(v, false);
                        k++;
                    } catch (Exception e) {
                        e.printStackTrace();
                        log.error("同步CE单据状态失败！第[{}]页，第[{}]条,{}", index, k, e.getMessage());
                    }
                }
                index++;
                page = PageRequest.of(index, 50);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        } finally {
            redisLockService.unlock(lockKey);
        }
        log.info("=====>    同步CE单据状态[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
