package com.biz.crm.tpm.business.withholding.summary.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.BcBpmCeWithholdingSummaryDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.BcBpmCeWithholdingSummaryStateDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.BcBpmCeWithholdingSummaryService;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.BcBpmCeWithholdingSummaryStateVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.BcBpmCeWithholdingSummaryVo;
import com.biz.crm.tpm.business.withholding.summary.local.entity.*;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRDetailRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryROrgRepository;
import com.biz.crm.tpm.business.withholding.summary.local.repository.TpmWithholdingSummaryRepository;
import com.biz.crm.tpm.business.withholding.summary.local.util.WithholdingSummaryUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.constant.*;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryJobParamDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryROrgDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.log.WithholdingSummaryLogEventDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.event.WithholdingSummaryEventListener;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.*;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-13
 */
@Slf4j
@Service("withholdingSummaryService")
public class WithholdingSummaryServiceInternalImpl implements WithholdingSummaryService {

    @Autowired(required = false)
    private TpmWithholdingSummaryRepository tpmWithholdingSummaryRepository;

    @Autowired(required = false)
    private TpmWithholdingSummaryROrgRepository tpmWithholdingSummaryROrgRepository;

    @Autowired(required = false)
    private TpmWithholdingSummaryDetailRepository tpmWithholdingSummaryDetailRepository;

    @Autowired(required = false)
    private TpmWithholdingSummaryRDetailRepository tpmWithholdingSummaryRDetailRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private BcBpmCeWithholdingSummaryService bcBpmCeWithholdingSummaryService;

    @Autowired(required = false)
    private WithholdingSummaryUtil withholdingSummaryUtil;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Override
    public Page<WithholdingSummaryVo> findByConditions(Pageable pageable, WithholdingSummaryDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new WithholdingSummaryDto();
        }
        return this.tpmWithholdingSummaryRepository.findByConditions(pageable, dto);
    }

    @Override
    public WithholdingSummaryVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.getById(id);
        Validate.notNull(withholdingSummaryEntity, "未查询到预提汇总信息");
        WithholdingSummaryVo withholdingSummaryVo = this.nebulaToolkitService.copyObjectByWhiteList(withholdingSummaryEntity, WithholdingSummaryVo.class, null, null);
        List<WithholdingSummaryROrgEntity> orgEntities = this.tpmWithholdingSummaryROrgRepository.findByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        if (!CollectionUtils.isEmpty(orgEntities)) {
            Collection<WithholdingSummaryROrgVo> orgVoList = this.nebulaToolkitService.copyCollectionByBlankList(orgEntities, WithholdingSummaryROrgEntity.class, WithholdingSummaryROrgVo.class, LinkedHashSet.class, ArrayList.class);
            withholdingSummaryVo.setOrgVoList((List<WithholdingSummaryROrgVo>) orgVoList);
        }
        List<WithholdingSummaryDetailEntity> detailEntities = tpmWithholdingSummaryDetailRepository.findByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        if (!CollectionUtils.isEmpty(detailEntities)) {
            Collection<WithholdingSummaryDetailVo> detailVoList = this.nebulaToolkitService.copyCollectionByBlankList(detailEntities, WithholdingSummaryDetailEntity.class, WithholdingSummaryDetailVo.class, LinkedHashSet.class, ArrayList.class);
            withholdingSummaryVo.setDetailVoList((List<WithholdingSummaryDetailVo>) detailVoList);
        }
        withholdingSummaryVo.setCacheKey(UuidCrmUtil.general() + ":" + withholdingSummaryVo.getWithholdingUploadCode());
        return withholdingSummaryVo;
    }

    @Override
    public WithholdingSummaryVo findMainByCode(String uploadCode) {
        if (StringUtils.isBlank(uploadCode)) {
            return null;
        }
        WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.findByWithholdingUploadCode(uploadCode);
        Validate.notNull(withholdingSummaryEntity, "未查询到预提汇总信息");
        return this.nebulaToolkitService.copyObjectByWhiteList(withholdingSummaryEntity, WithholdingSummaryVo.class, null, null);
    }

    /**
     * 1、验证
     * 2、验重复
     * 3、获取汇总规则信息
     * 4、生成汇总上传编码
     * 5、构建汇总明细数据
     * 6、构建汇总数据并保存
     *
     * @param dto
     */
    @Transactional
    @Override
    public void create(WithholdingSummaryDto dto) {
        this.checkCreate(dto);

        //2、预提汇总规则
        WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(dto.getWithholdingFormulaCode());

        //3、汇总预提明细
        List<WithholdingSummaryVo> withholdingSummaryVos = withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);

        //获取业务单元字典
        Map<String, String> unitMap = dictToolkitService.findMapByDictTypeCode(WithholdingSummaryConstant.MDM_BUSINESS_UNIT);

        withholdingSummaryVos.forEach(withholdingSummaryVo->{
            //4、预提汇总头表
            WithholdingSummaryEntity withholdingSummaryEntity = this.nebulaToolkitService.copyObjectByWhiteList(withholdingSummaryFormulaVo, WithholdingSummaryEntity.class, null, null);
            withholdingSummaryEntity.setWithholdingUploadCode(withholdingSummaryVo.getWithholdingUploadCode());
            withholdingSummaryEntity.setActivityTypeType(withholdingSummaryVo.getActivityTypeType());
            withholdingSummaryEntity.setBusinessTitle(withholdingSummaryVo.getBusinessTitle());
            withholdingSummaryEntity.setBusinessTitleName(withholdingSummaryVo.getBusinessTitleName());
            withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
            withholdingSummaryEntity.setBusinessUnitName(unitMap.get(withholdingSummaryEntity.getBusinessUnitCode()));
            withholdingSummaryEntity.setWithholdingYearMonth(dto.getWithholdingYearMonth());
            withholdingSummaryEntity.setTradeCurrency(WithholdingSummaryConstant.TRADE_CURRENCY);
            withholdingSummaryEntity.setExchangeRate(BigDecimal.ONE);
            withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            withholdingSummaryEntity.setTenantCode(TenantUtils.getTenantCode());
            this.tpmWithholdingSummaryRepository.save(withholdingSummaryEntity);

            //5、预提汇总明细表
            this.tpmWithholdingSummaryDetailRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class));

            //6、预提汇总关联预提明细表
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
            List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            tpmWithholdingSummaryDetailRepository.insertRData(
                    withholdingSummaryEntity.getWithholdingYearMonth(),
                    withholdingSummaryFormulaVo,
                    orgCodes,
                    withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo),
                    withholdingSummaryEntity.getActivityTypeType(),
                    withholdingSummaryEntity.getWithholdingUploadCode(),
                    loginUserService.getAbstractLoginUser());

            //7、预提汇总管理销售组织表
            this.tpmWithholdingSummaryROrgRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class));

            //新增业务日志
            WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<WithholdingSummaryEventListener, WithholdingSummaryLogEventDto> onCreate =
                    WithholdingSummaryEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, WithholdingSummaryEventListener.class, onCreate);
        });
    }

    @Transactional
    @Override
    public void update(WithholdingSummaryDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        withholdingSummaryUtil.valUpdate(dto);
        String lockKey = WithholdingSummaryConstant.WITHHOLDING_SUMMARY_LOCK + dto.getId();
        boolean hasLock = redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 60 * 5);
        Validate.isTrue(hasLock, "预提汇总数据正在被操作中，请稍后！");
        try {
            WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.getById(dto.getId());
            Validate.isTrue(Objects.nonNull(withholdingSummaryEntity) && StringUtils.equals(DelFlagStatusEnum.NORMAL.getCode(), withholdingSummaryEntity.getDelFlag()), "数据不存在，请刷新后重试！");
            Validate.isTrue(WithholdingSummaryStateEnum.editState(withholdingSummaryEntity.getState()), "当前状态不能编辑！");
            withholdingSummaryUtil.valUpdateExtend(dto.getDetailDtoList(), withholdingSummaryEntity.getActivityTypeType(), 1);
            dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
            dto.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
            WithholdingSummaryVo oldVo = this.findById(dto.getId());

            //构建编辑得汇总明细
            List<WithholdingSummaryDetailVo> detailList = withholdingSummaryUtil.buildUpdateDetailList(dto);
            BigDecimal withholdingAmount = detailList.stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Validate.isTrue(withholdingSummaryEntity.getWithholdingAmount().compareTo(withholdingAmount) == 0, "明细中[不含税金额]总和不等于预提金额！");
            withholdingSummaryEntity.setExpenseContent(dto.getExpenseContent());
            withholdingSummaryEntity.setProfitCenter(dto.getProfitCenter());
            withholdingSummaryEntity.setTradeCurrency(dto.getTradeCurrency());
            withholdingSummaryEntity.setExchangeRate(dto.getExchangeRate());
            this.tpmWithholdingSummaryRepository.updateById(withholdingSummaryEntity);

            //汇总明细
            this.tpmWithholdingSummaryDetailRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            this.tpmWithholdingSummaryDetailRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(detailList, WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class));

            //预提汇总管理销售组织表
            this.tpmWithholdingSummaryROrgRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
            this.tpmWithholdingSummaryROrgRepository.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(dto.getOrgVoList(), WithholdingSummaryROrgDto.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class));

            String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(withholdingSummaryEntity.getWithholdingUploadCode());
            redisService.del(redisCacheKey);//删掉重新放

            //更新业务日志
            WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<WithholdingSummaryEventListener, WithholdingSummaryLogEventDto> onUpdate =
                    WithholdingSummaryEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, WithholdingSummaryEventListener.class, onUpdate);
        } finally {
            redisLockService.unlock(lockKey);
        }
    }

    @Transactional
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");

        List<String> lockKeys = new ArrayList<>();
        idList.forEach(id -> {
            String lockKey = WithholdingSummaryConstant.WITHHOLDING_SUMMARY_LOCK + id;
            boolean hasLock = redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 60 * 5);
            Validate.isTrue(hasLock, "预提汇总数据正在被操作中，请稍后！");
            lockKeys.add(lockKey);
        });

        try {
            List<WithholdingSummaryEntity> withholdingSummaryEntityList1 = this.tpmWithholdingSummaryRepository.listByIds(idList);
            Validate.isTrue(!CollectionUtils.isEmpty(withholdingSummaryEntityList1), "删除时数据不能为空");
            List<WithholdingSummaryEntity> withholdingSummaryEntityList = new ArrayList<>();
            List<WithholdingSummaryLogEventDto> withholdingSummaryLogEventDtoList = new ArrayList<>();
            withholdingSummaryEntityList1.forEach(item -> {
                Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.PASS.getDictCode(), item.getState()),
                        "预提上传编码[%s]汇总状态[CE通过]，暂不支持删除！", item.getWithholdingUploadCode());
                WithholdingSummaryEntity withholdingSummaryEntity = new WithholdingSummaryEntity();
                withholdingSummaryEntity.setId(item.getId());
                withholdingSummaryEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                withholdingSummaryEntityList.add(withholdingSummaryEntity);

                //删除业务日志
                WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
                WithholdingSummaryVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingSummaryVo.class, null, null);
                logEventDto.setOriginal(oldVo);
                WithholdingSummaryDto withholdingSummaryDto = this.nebulaToolkitService.copyObjectByWhiteList(item, WithholdingSummaryDto.class, null, null);
                withholdingSummaryDto.setDelFlag(withholdingSummaryEntity.getDelFlag());
                logEventDto.setNewest(withholdingSummaryDto);
                withholdingSummaryLogEventDtoList.add(logEventDto);
            });
            SerializableBiConsumer<WithholdingSummaryEventListener, WithholdingSummaryLogEventDto> onDelete =
                    WithholdingSummaryEventListener::onDelete;
            withholdingSummaryLogEventDtoList.forEach(log -> {
                this.nebulaNetEventClient.publish(log, WithholdingSummaryEventListener.class, onDelete);
            });
            this.tpmWithholdingSummaryRepository.updateBatchById(withholdingSummaryEntityList);
        } finally {
            lockKeys.forEach(lockKey -> {
                redisLockService.unlock(lockKey);
            });
        }
    }

    @Transactional
    @Override
    public void refresh(String id) {
        this.checkRefresh(id);

        //1、查询原始汇总数据
        WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.getById(id);
        WithholdingSummaryVo oldVo = this.findById(id);

        //2、删除历史
        this.tpmWithholdingSummaryDetailRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        this.tpmWithholdingSummaryRDetailRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        this.tpmWithholdingSummaryROrgRepository.removeByWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());

        //3、预提汇总规则
        WithholdingSummaryFormulaVo withholdingSummaryFormulaVo = this.tpmWithholdingSummaryRepository.findHeadInfoByWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());

        //4、汇总预提明细，并返回预提总金额
        WithholdingSummaryDto dto = new WithholdingSummaryDto();
        dto.setWithholdingUploadCode(withholdingSummaryEntity.getWithholdingUploadCode());
        dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
        dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
        dto.setActivityTypeType(withholdingSummaryEntity.getActivityTypeType());
        List<WithholdingSummaryVo> withholdingSummaryVos = withholdingSummaryUtil.buildDetailList(withholdingSummaryFormulaVo, dto);
        WithholdingSummaryVo withholdingSummaryVo = withholdingSummaryVos.get(0);
        //5、更新主表
        withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.SUBMIT.getDictCode());
        withholdingSummaryEntity.setWithholdingAmount(withholdingSummaryVo.getDetailVoList().stream().map(WithholdingSummaryDetailVo::getWithholdingAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        this.tpmWithholdingSummaryRepository.updateById(withholdingSummaryEntity);

        //6、预提汇总明细表
        this.tpmWithholdingSummaryDetailRepository.saveBatch(
                nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailEntity.class, HashSet.class, ArrayList.class));

        //7、预提汇总关联预提明细表
        List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCodes(withholdingSummaryFormulaVo.getOrgVoList().stream().map(WithholdingSummaryROrgVo::getSalesOrgCode).collect(Collectors.toList()));
        List<String> orgCodes = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
        tpmWithholdingSummaryDetailRepository.insertRData(
                withholdingSummaryEntity.getWithholdingYearMonth(),
                withholdingSummaryFormulaVo,
                orgCodes,
                withholdingSummaryUtil.summaryOrgDimension(withholdingSummaryFormulaVo),
                withholdingSummaryEntity.getActivityTypeType(),
                withholdingSummaryEntity.getWithholdingUploadCode(),
                loginUserService.getAbstractLoginUser());

        //8、预提汇总管理销售组织表
        this.tpmWithholdingSummaryROrgRepository.saveBatch(
                nebulaToolkitService.copyCollectionByWhiteList(withholdingSummaryFormulaVo.getOrgVoList(), WithholdingSummaryROrgVo.class, WithholdingSummaryROrgEntity.class, HashSet.class, ArrayList.class));

        //9、删除明细缓存
        String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(withholdingSummaryEntity.getWithholdingUploadCode());
        redisService.del(redisCacheKey);//删掉重新放

        //更新业务日志
        WithholdingSummaryVo newVo = this.findById(id);
        WithholdingSummaryDto newDto = nebulaToolkitService.copyObjectByWhiteList(newVo, WithholdingSummaryDto.class, HashSet.class, ArrayList.class);
        if (CollectionUtils.isNotEmpty(newDto.getDetailDtoList())) {
            Collection<WithholdingSummaryDetailDto> newDetailList = nebulaToolkitService.copyCollectionByWhiteList(newVo.getDetailVoList(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailDto.class, HashSet.class, ArrayList.class);
            newDto.setDetailDtoList(Lists.newArrayList(newDetailList));
        }
        WithholdingSummaryLogEventDto logEventDto = new WithholdingSummaryLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer<WithholdingSummaryEventListener, WithholdingSummaryLogEventDto> onUpdate =
                WithholdingSummaryEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, WithholdingSummaryEventListener.class, onUpdate);
    }

    @Transactional
    @Override
    public void upload(String id, FacturerUserDetails loginDetails) {
        WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.getById(id);
        Validate.isTrue(Objects.nonNull(withholdingSummaryEntity) && StringUtils.equals(DelFlagStatusEnum.NORMAL.getCode(), withholdingSummaryEntity.getDelFlag()), "汇总上传编码[%s]数据不存在，请刷新后重试！", withholdingSummaryEntity.getWithholdingUploadCode());
        Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.UPLOAD.getDictCode(), withholdingSummaryEntity.getState()), "汇总上传编码[%s]，状态[已上传]，请勿重复上传！", withholdingSummaryEntity.getWithholdingUploadCode());
        Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.PASS.getDictCode(), withholdingSummaryEntity.getState()), "汇总上传编码[%s]，状态[CE通过]，请勿上传！", withholdingSummaryEntity.getWithholdingUploadCode());
        Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.REJECT.getDictCode(), withholdingSummaryEntity.getState()), "汇总上传编码[%s]，状态[CE驳回]，请勿上传！", withholdingSummaryEntity.getWithholdingUploadCode());

        //汇总传CE
        WithholdingSummaryVo withholdingSummaryVo = this.findById(id);
        withholdingSummaryUtil.validateUploadParam(withholdingSummaryVo);
        BcBpmCeWithholdingSummaryDto dto = withholdingSummaryUtil.buildUploadParam(withholdingSummaryVo, loginDetails);
        Result result = bcBpmCeWithholdingSummaryService.uploadSummary(dto);
        if (!result.isSuccess()) {
            throw new RuntimeException("汇总上传编码[" + withholdingSummaryEntity.getWithholdingUploadCode() + "]上传CE失败：" + result.getMessage());
        }
        BcBpmCeWithholdingSummaryVo ceResultVo = JSONArray.parseObject(result.getResult().toString(), BcBpmCeWithholdingSummaryVo.class);
        Validate.isTrue(StringUtils.equals("S", ceResultVo.getMSG_CODE()),
                "汇总上传编码[%s]上传CE失败：%s", withholdingSummaryEntity.getWithholdingUploadCode(), ceResultVo.getMSG());
        Validate.isTrue(Objects.nonNull(ceResultVo.getPROCESS_INSTANCEID()), "汇总上传编码[%s]上传CE失败：CE单据编号返回空", withholdingSummaryEntity.getWithholdingUploadCode());
        withholdingSummaryEntity.setWithholdingCeCode(ceResultVo.getPROCESS_INSTANCEID().toString());
        withholdingSummaryEntity.setState(WithholdingSummaryStateEnum.UPLOAD.getDictCode());
        this.tpmWithholdingSummaryRepository.updateById(withholdingSummaryEntity);
    }

    @Override
    public void addItemCache(String cacheKey, List<WithholdingSummaryDetailDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            saveList = Lists.newArrayList();
        }
        Collection<WithholdingSummaryDetailVo> detailVos = nebulaToolkitService.copyCollectionByWhiteList(saveList, WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class);
        String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        List<WithholdingSummaryDetailVo> newList = Lists.newArrayList(detailVos);
        WithholdingSummaryDetailVo detailVo = new WithholdingSummaryDetailVo();
        newList.add(detailVo);
        redisService.del(redisCacheKey);//删掉重新放
        redisService.lPushAll(redisCacheKey, WithholdingSummaryConstant.WITHHOLDING_SUMMARY_DETAIL_CACHE_EXPIRE_TIME, newList.toArray());//设置过期时间1天
    }

    @Override
    public void deleteItemCache(String cacheKey, List<WithholdingSummaryDetailDto> saveList) {
        saveList = saveList.stream().filter(e -> !StringUtils.equals("1", e.getChecked())).collect(Collectors.toList());
        Collection<WithholdingSummaryDetailVo> detailVos = nebulaToolkitService.copyCollectionByWhiteList(saveList, WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class);
        String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        List<WithholdingSummaryDetailVo> newList = Lists.newArrayList(detailVos);
        redisService.del(redisCacheKey);//删掉重新放
        redisService.lPushAll(redisCacheKey, WithholdingSummaryConstant.WITHHOLDING_SUMMARY_DETAIL_CACHE_EXPIRE_TIME, newList.toArray());//设置过期时间1天
    }

    @Override
    public void saveCurrentPageCache(String cacheKey, List<WithholdingSummaryDetailDto> saveList) {
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        Collection<WithholdingSummaryDetailVo> detailVos = nebulaToolkitService.copyCollectionByWhiteList(saveList, WithholdingSummaryDetailDto.class, WithholdingSummaryDetailVo.class, HashSet.class, ArrayList.class);
        String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        List<WithholdingSummaryDetailVo> newList = Lists.newArrayList(detailVos);
        redisService.del(redisCacheKey);//删掉重新放
        redisService.lPushAll(redisCacheKey, WithholdingSummaryConstant.WITHHOLDING_SUMMARY_DETAIL_CACHE_EXPIRE_TIME, newList.toArray());//设置过期时间1天
    }

    @Override
    public Page<WithholdingSummaryDetailVo> findCachePageList(Pageable pageable, String cacheKey, String withholdingUploadCode) {
        String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        Page<WithholdingSummaryDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page.setTotal(0);
        page.setRecords(Lists.newArrayList());

        if (redisService.hasKey(redisCacheKey)) {
            //redis里面有的话直接从redis里面取
            Long total = redisService.lSize(redisCacheKey);
            page.setTotal(total);
            List<Object> objects = redisService.lRange(redisCacheKey, page.offset(), page.offset() + page.getSize() - 1);
            if (!org.springframework.util.CollectionUtils.isEmpty(objects)) {
                List<WithholdingSummaryDetailVo> detailVos = (List<WithholdingSummaryDetailVo>) (List) objects;
                page.setRecords(detailVos);
            }
        } else {
            //redis里面没有
            if (StringUtils.isNotEmpty(withholdingUploadCode)) {
                //有策略编码，从数据库里面查出来放到缓存里面
                List<WithholdingSummaryDetailEntity> list = this.tpmWithholdingSummaryDetailRepository.findByWithholdingUploadCode(withholdingUploadCode);
                if (!CollectionUtils.isEmpty(list)) {
                    list.sort(Comparator.comparing(WithholdingSummaryDetailEntity::getWithholdingDetailCode));
                    Collection<WithholdingSummaryDetailVo> detailVoList = this.nebulaToolkitService.copyCollectionByBlankList(list, WithholdingSummaryDetailEntity.class, WithholdingSummaryDetailVo.class, LinkedHashSet.class, ArrayList.class);
                    redisService.lPushAll(redisCacheKey, WithholdingSummaryConstant.WITHHOLDING_SUMMARY_DETAIL_CACHE_EXPIRE_TIME, detailVoList.toArray());
                    page.setTotal(detailVoList.size());
                    page.setRecords((List<WithholdingSummaryDetailVo>) detailVoList);
                }
            }
        }
        //更新下VO里面的字段值
        return page;
    }

    @Override
    public List<WithholdingSummaryDetailVo> findCacheList(String cacheKey) {
        String redisCacheKey = withholdingSummaryUtil.getRedisCacheKey(cacheKey);
        if (!redisService.hasKey(redisCacheKey)) {
            return Lists.newArrayList();
        }
        List<Object> objects = redisService.lRange(redisCacheKey, 0, -1);
        return (List<WithholdingSummaryDetailVo>) (List) objects;
    }

    @Override
    public Integer getTotal(String cacheKey) {
        String redisCacheKey = WithholdingSummaryConstant.WITHHOLDING_SUMMARY_DETAIL_CACHE_PREFIX + cacheKey;
        return redisService.lSize(redisCacheKey).intValue();
    }

    @SneakyThrows
    @Override
    public List<WithholdingSummaryVo> findAutoSyncCeStateList(Pageable pageable, WithholdingSummaryJobParamDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DATE_ALL_PATTERN);
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.DEFAULT_DATE_ALL_PATTERN);
        if (Objects.isNull(dto.getBeginTime())) {
            dto.setBeginTime(sdf.parse(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).format(formatter)));
        }
        if (Objects.isNull(dto.getEndTime())) {
            dto.setEndTime(sdf.parse(LocalDateTime.now().format(formatter)));
        }
        return this.tpmWithholdingSummaryRepository.findAutoSyncCeStateList(pageable, dto.getBeginTime(), dto.getEndTime(), dto.getIds());
    }

    @Transactional
    @Override
    public void autoSyncCeState(WithholdingSummaryVo vo, Boolean throwError) {
        //throwError 为true会抛出异常，false只打印error日志
        BcBpmCeWithholdingSummaryStateDto dto = new BcBpmCeWithholdingSummaryStateDto();
        dto.setPROCESS_INSTANCEID(vo.getWithholdingCeCode());
        Result result = bcBpmCeWithholdingSummaryService.getSummaryState(dto);
        log.info("预提汇总上传编码[{}],同步CE单据状态返回：{}", vo.getWithholdingUploadCode(), JSONObject.toJSONString(result));
        if (!result.isSuccess()) {
            String msg = "预提汇总上传编码[" + vo.getWithholdingUploadCode() + "],同步CE单据状态失败：" + result.getMessage();
            Validate.isTrue(!throwError, msg);
            log.error(msg);
            return;
        }
        BcBpmCeWithholdingSummaryStateVo ceResultVo = JSONArray.parseObject(result.getResult().toString(), BcBpmCeWithholdingSummaryStateVo.class);
        if (!StringUtils.equals("S", ceResultVo.getMSG_CODE())) {
            String msg = "预提汇总上传编码[" + vo.getWithholdingUploadCode() + "],同步CE单据状态返回结果失败，CE错误信息：" + ceResultVo.getMSG();
            Validate.isTrue(!throwError, msg);
            log.error(msg);
            return;
        }
        if (Objects.isNull(ceResultVo.getITEM1()) || CollectionUtils.isEmpty(ceResultVo.getITEM1())) {
            String msg = "预提汇总上传编码[" + vo.getWithholdingUploadCode() + "],同步CE单据状态失败：[ITEM1] CE返回为空";
            Validate.isTrue(!throwError, msg);
            log.error(msg);
            return;
        }
        List<BcBpmCeWithholdingSummaryStateVo.ITEM1> item1 = ceResultVo.getITEM1();
        BcBpmCeWithholdingSummaryStateVo.ITEM1 item = item1.get(0);
        String processStatus =item.getPROCESS_STATUS();
        if (StringUtils.isEmpty(processStatus)) {
            String msg = "预提汇总上传编码[" + vo.getWithholdingUploadCode() + "],同步CE单据状态失败：[ITEM1.PROCESS_STATUS] CE返回为空";
            Validate.isTrue(!throwError, msg);
            log.error(msg);
            return;
        }

        WithholdingSummaryCeStateEnum summaryCeStateEnum = WithholdingSummaryCeStateEnum.codeToEnum(processStatus);
        if (Objects.isNull(summaryCeStateEnum)) {
            String msg = "预提汇总上传编码[" + vo.getWithholdingUploadCode() + "]，同步CE单据状态失败：[ITEM1.PROCESS_STATUS]状态值[" + processStatus + "]在TPM系统未定义";
            Validate.isTrue(!throwError, msg);
            log.error(msg);
            return;
        }

        String state;
        String accountingVoucherNumber = null;
        if (StringUtils.equals(WithholdingSummaryCeStateEnum.APPROVING.getDictCode(), summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.UPLOAD.getDictCode();
        } else if (StringUtils.equals(WithholdingSummaryCeStateEnum.FINISH.getDictCode(), summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.PASS.getDictCode();
            accountingVoucherNumber = item.getFY_VOUCHER_NO();
        } else if (StringUtils.equals(WithholdingSummaryCeStateEnum.REJECT.getDictCode(), summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.REJECT.getDictCode();
        }  else if (StringUtils.equals(WithholdingSummaryCeStateEnum.CANCEL.getDictCode(), summaryCeStateEnum.getDictCode())) {
            state = WithholdingSummaryStateEnum.CANCEL.getDictCode();
        } else {
            String msg = "预提汇总上传编码[" + vo.getWithholdingUploadCode() + "]，同步CE单据状态失败：TPM系统未定义CE单据状态[" + summaryCeStateEnum.getDictCode() + "]与TPM状态对应关系";
            Validate.isTrue(!throwError, msg);
            log.error(msg);
            return;
        }

        if (StringUtils.isNotEmpty(accountingVoucherNumber)) {
            String[] split = accountingVoucherNumber.split(":");
            accountingVoucherNumber = split.length == 2 ? split[1] : accountingVoucherNumber;
        }
        vo.setAccountingVoucherCode(accountingVoucherNumber);

        this.tpmWithholdingSummaryRepository.updateCeInfo(vo, state, summaryCeStateEnum.getDictCode());
    }

    @Override
    public void checkCreate(WithholdingSummaryDto dto) {
        //1、校验新增数据
        dto.setTenantCode(TenantUtils.getTenantCode());
        withholdingSummaryUtil.valCreate(dto);

        //2、是否已汇总
        int count = this.tpmWithholdingSummaryRepository.countSummarySize(dto.getWithholdingFormulaCode(), dto.getWithholdingYearMonth());
        Validate.isTrue(count == 0, "预提汇总规则[%s]，预提年月[%s]已存在汇总，无法新增！", dto.getWithholdingFormulaCode(), dto.getWithholdingYearMonth());

        //3、是否有汇总明细
        withholdingSummaryUtil.checkDetailCount(dto);
    }

    @Override
    public void checkRefresh(String id) {
        //1、汇总是否存在，是否允许刷新
        WithholdingSummaryEntity withholdingSummaryEntity = this.tpmWithholdingSummaryRepository.getById(id);
        Validate.isTrue(Objects.nonNull(withholdingSummaryEntity) && StringUtils.equals(DelFlagStatusEnum.NORMAL.getCode(), withholdingSummaryEntity.getDelFlag()), "数据不存在，请刷新后重试！");
        Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.UPLOAD.getDictCode(), withholdingSummaryEntity.getState()), "预提上传编码[%s]，状态[已上传]，暂不支持更新！", withholdingSummaryEntity.getWithholdingUploadCode());
        Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.PASS.getDictCode(), withholdingSummaryEntity.getState()), "预提上传编码[%s]，状态[CE通过]，暂不支持更新！", withholdingSummaryEntity.getWithholdingUploadCode());
        Validate.isTrue(!StringUtils.equals(WithholdingSummaryStateEnum.REJECT.getDictCode(), withholdingSummaryEntity.getState()), "预提上传编码[%s]，状态[CE驳回]，暂不支持更新！", withholdingSummaryEntity.getWithholdingUploadCode());

        WithholdingSummaryDto dto = new WithholdingSummaryDto();
        dto.setWithholdingFormulaCode(withholdingSummaryEntity.getWithholdingFormulaCode());
        dto.setWithholdingYearMonth(withholdingSummaryEntity.getWithholdingYearMonth());
        dto.setActivityTypeType(withholdingSummaryEntity.getActivityTypeType());
        //2、是否有汇总明细
        withholdingSummaryUtil.checkDetailCount(dto);
    }
}
