/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.withholding.summary.local.service.internal.WithholdingSummaryAsyncService;
import com.biz.crm.tpm.business.withholding.summary.local.service.internal.WithholdingSummaryCeStateAutoSyncXxlJob;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryJobParamDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/withholding/summary"})
@Api(tags={"TPM-\u9884\u63d0\u6c47\u603b\u5217\u8868\u63a5\u53e3"})
public class WithholdingSummaryController {
    private static final Logger log = LoggerFactory.getLogger(WithholdingSummaryController.class);
    @Autowired(required=false)
    private WithholdingSummaryService withholdingSummaryService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private WithholdingSummaryAsyncService withholdingSummaryAsyncService;
    @Autowired(required=false)
    private WithholdingSummaryCeStateAutoSyncXxlJob withholdingSummaryCeStateAutoSyncXxlJob;

    @PostMapping(value={"findByConditions"})
    @ApiOperation(value="\u5217\u8868\u5206\u9875\u67e5\u8be2")
    public Result<Page<WithholdingSummaryVo>> findByConditions(Pageable pageable, @RequestBody WithholdingSummaryDto dto) {
        try {
            return Result.ok((Object)this.withholdingSummaryService.findByConditions(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"detail"})
    @ApiOperation(value="\u8be6\u60c5")
    public Result<WithholdingSummaryVo> detail(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.withholdingSummaryService.findById(id));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"create"})
    @ApiOperation(value="\u65b0\u589e")
    public Result<?> create(@RequestBody WithholdingSummaryDto dto) {
        String lockKey = "tpm:withholding_summary_create:" + dto.getWithholdingFormulaCode() + ":" + dto.getWithholdingYearMonth();
        boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 1800L);
        Validate.isTrue((boolean)hasLock, (String)"\u9884\u63d0\u6c47\u603b\u89c4\u5219[%s]\uff0c\u9884\u63d0\u5e74\u6708[%s]\u6b63\u5728\u6c47\u603b\uff0c\u8bf7\u52ff\u91cd\u590d\u6c47\u603b\uff01", (Object[])new Object[]{dto.getWithholdingFormulaCode(), dto.getWithholdingYearMonth()});
        try {
            this.withholdingSummaryService.create(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u7f16\u8f91")
    public Result<?> update(@RequestBody WithholdingSummaryDto dto) {
        try {
            this.withholdingSummaryService.update(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.withholdingSummaryService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"refresh"})
    @ApiOperation(value="\u66f4\u65b0")
    public Result<?> refresh(@RequestBody ArrayList<String> ids) {
        ArrayList lockKeys = new ArrayList();
        try {
            Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u66f4\u65b0\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ids.forEach(id -> {
                String lockKey = "tpm:withholding_summary_lock:" + id;
                boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 1800L);
                Validate.isTrue((boolean)hasLock, (String)"\u9884\u63d0\u6c47\u603b\u6570\u636e\u6b63\u5728\u88ab\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
                lockKeys.add(lockKey);
            });
            ids.forEach(id -> this.withholdingSummaryService.refresh(id));
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtils.isNotEmpty(lockKeys)) {
                for (String lockKey : lockKeys) {
                    this.redisLockService.unlock(lockKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"upload"})
    @ApiOperation(value="\u4e0a\u4f20")
    public Result<?> upload(@RequestBody ArrayList<String> ids) {
        ArrayList lockKeys = new ArrayList();
        try {
            Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ids.forEach(id -> {
                String lockKey = "tpm:withholding_summary_lock:" + id;
                boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 3600L);
                Validate.isTrue((boolean)hasLock, (String)"\u9884\u63d0\u6c47\u603b\u6570\u636e\u6b63\u5728\u88ab\u64cd\u4f5c\u4e2d\uff0c\u8bf7\u7a0d\u540e\uff01", (Object[])new Object[0]);
                lockKeys.add(lockKey);
            });
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            ids.forEach(id -> this.withholdingSummaryService.upload(id, loginDetails));
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtils.isNotEmpty(lockKeys)) {
                for (String lockKey : lockKeys) {
                    this.redisLockService.unlock(lockKey);
                }
            }
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u660e\u7ec6\u5217\u8868\u7f13\u5b58\u5206\u9875\u63a5\u53e3")
    @GetMapping(value={"findCachePageList"})
    public Result<Page<WithholdingSummaryDetailVo>> findCachePageList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="matchCode", value="\u7b56\u7565\u7f16\u7801") @RequestParam(required=false) String matchCode) {
        try {
            Page page = this.withholdingSummaryService.findCachePageList(pageable, cacheKey, matchCode);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u4e00\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u63d2\u5165\u4e00\u6761\u6570\u636e\u5e76\u8fd4\u56de\u6570\u636e")
    @PostMapping(value={"addItemCache"})
    public Result<Page<WithholdingSummaryDetailVo>> addItemCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<WithholdingSummaryDetailDto> saveList) {
        try {
            this.withholdingSummaryService.addItemCache(cacheKey, saveList);
            Page page = this.withholdingSummaryService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u591a\u884c\u5220\u9664\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"deleteCacheList"})
    public Result<Page<WithholdingSummaryDetailVo>> deleteCacheList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u5220\u9664\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<WithholdingSummaryDetailDto> saveList) {
        try {
            this.withholdingSummaryService.deleteItemCache(cacheKey, saveList);
            Page page = this.withholdingSummaryService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u5230\u7f13\u5b58\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"saveCurrentPageCache"})
    public Result<Page<WithholdingSummaryDetailVo>> saveCurrentPageCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<WithholdingSummaryDetailDto> saveList) {
        try {
            this.withholdingSummaryService.saveCurrentPageCache(cacheKey, saveList);
            Page page = this.withholdingSummaryService.findCachePageList(pageable, cacheKey, null);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684\u6240\u6709\u660e\u7ec6\u884c")
    @PostMapping(value={"findCacheList"})
    public Result<List<WithholdingSummaryDetailVo>> findCacheList(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            return Result.ok((Object)this.withholdingSummaryService.findCacheList(cacheKey));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u540c\u6b65CE\u5355\u636e\u72b6\u6001")
    @PostMapping(value={"autoSyncCeState"})
    public Result<?> autoSyncCeState(@RequestBody WithholdingSummaryJobParamDto dto) {
        String lockKey = "tpm:withholding_summary_auto_lock";
        try {
            List list;
            PageRequest page = PageRequest.of((int)1, (int)50);
            int index = 1;
            boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 43200L);
            if (!hasLock) {
                log.error("\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u8fdb\u884c\u4e2d\uff01");
                Result result = Result.error((String)"\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u8fdb\u884c\u4e2d\uff01");
                return result;
            }
            while (!CollectionUtils.isEmpty((Collection)(list = this.withholdingSummaryService.findAutoSyncCeStateList((Pageable)page, dto)))) {
                int k = 1;
                for (WithholdingSummaryVo v : list) {
                    try {
                        this.withholdingSummaryService.autoSyncCeState(v, Boolean.valueOf(true));
                        ++k;
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\u7b2c[{}]\u9875\uff0c\u7b2c[{}]\u6761\uff1a{}", new Object[]{index, k, e.getMessage()});
                    }
                }
                page = PageRequest.of((int)(++index), (int)50);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
        return Result.ok();
    }

    @ApiOperation(value="\u6d4b\u8bd5\u540c\u6b65CE\u5355\u636e\u72b6\u6001\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"testAutoSyncXxlJob"})
    public Result<?> testAutoSyncXxlJob(@RequestBody WithholdingSummaryJobParamDto dto) {
        try {
            this.withholdingSummaryCeStateAutoSyncXxlJob.autoSyncCeState();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

