/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.process.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailExportVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class WithholdingSummaryDetailExportProcess
implements ExportProcess<WithholdingSummaryDetailExportVo> {
    @Autowired(required=false)
    private WithholdingSummaryService withholdingSummaryService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Integer total = this.withholdingSummaryService.getTotal((String)params.get("cacheKey"));
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page cachePage = this.withholdingSummaryService.findCachePageList((Pageable)pageable, cacheKey, null);
        if (cachePage.getSize() == 0L) {
            return new JSONArray();
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)cachePage.getRecords(), WithholdingSummaryDetailVo.class, WithholdingSummaryDetailExportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.convertData(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    public Class<WithholdingSummaryDetailExportVo> findCrmExcelVoClass() {
        return WithholdingSummaryDetailExportVo.class;
    }

    public String getBusinessCode() {
        return "WITHHOLDING_SUMMARY_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "TPM\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u5bfc\u51fa";
    }

    private void convertData(Collection<WithholdingSummaryDetailExportVo> data) {
        Map businessExpItemMap = this.dictToolkitService.findMapByDictTypeCode("tpm_accrued_account");
        for (WithholdingSummaryDetailExportVo vo : data) {
            if (!StringUtils.isNotBlank((CharSequence)vo.getBusinessExpItem())) continue;
            vo.setBusinessExpItem(businessExpItemMap.getOrDefault(vo.getBusinessExpItem(), vo.getBusinessExpItem()));
        }
    }
}

