/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.withholding.summary.local.process.imports;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.withholding.summary.local.util.WithholdingSummaryUtil;
import com.biz.crm.tpm.business.withholding.summary.sdk.dto.WithholdingSummaryDetailDto;
import com.biz.crm.tpm.business.withholding.summary.sdk.service.WithholdingSummaryService;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryDetailImportVo;
import com.biz.crm.tpm.business.withholding.summary.sdk.vo.WithholdingSummaryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WithholdingSummaryDetailImportProcess
implements ImportProcess<WithholdingSummaryDetailImportVo> {
    private static final Logger log = LoggerFactory.getLogger(WithholdingSummaryDetailImportProcess.class);
    @Autowired(required=false)
    private WithholdingSummaryService withholdingSummaryService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private WithholdingSummaryUtil withholdingSummaryUtil;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, WithholdingSummaryDetailImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull((Object)params.get("matchCode"), (String)"\u6c47\u603b\u4e0a\u4f20\u7f16\u7801\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u6761", (long)this.getBatchCount().intValue());
        String cacheKey = (String)params.get("cacheKey");
        String matchCode = (String)params.get("matchCode");
        log.info("\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u5bfc\u5165-\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u5bfc\u5165\u6821\u9a8c-----------------");
        List<WithholdingSummaryDetailDto> dtoList = this.val(data, matchCode);
        log.info("\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u5bfc\u5165-\u6267\u884c\u5927\u6279\u91cf\u5bfc\u5165\u6821\u9a8c\u7ed3\u675f-----------------");
        log.info("\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u5bfc\u5165-\u5f00\u59cb\u6267\u884c\u5927\u6279\u91cf\u5bfc\u5165\u4fdd\u5b58-----------------");
        this.withholdingSummaryService.saveCurrentPageCache(cacheKey, dtoList);
        log.info("\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u5bfc\u5165-\u7ed3\u675f\u6267\u884c\u5927\u6279\u91cf\u5bfc\u5165\u4fdd\u5b58-----------------");
        return null;
    }

    public Class<WithholdingSummaryDetailImportVo> findCrmExcelVoClass() {
        return WithholdingSummaryDetailImportVo.class;
    }

    public String getTemplateCode() {
        return "WITHHOLDING_SUMMARY_DETAIL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u8f91\u5bfc\u5165\u6a21\u677f";
    }

    public String getBusinessCode() {
        return "WITHHOLDING_SUMMARY_DETAIL_IMPORT";
    }

    public String getBusinessName() {
        return "TPM\u9884\u63d0\u6c47\u603b\u660e\u7ec6\u7f16\u8f91\u5bfc\u5165\u6a21\u677f";
    }

    public List<WithholdingSummaryDetailDto> val(LinkedHashMap<Integer, WithholdingSummaryDetailImportVo> data, String matchCode) {
        WithholdingSummaryVo withholdingSummaryVo = this.withholdingSummaryService.findMainByCode(matchCode);
        Map businessExpItemMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_accrued_account");
        Map merchantsMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_merchants_type");
        ActivityFormDto activityForm = new ActivityFormDto();
        activityForm.setBusinessUnitCode(withholdingSummaryVo.getBusinessUnitCode());
        List activityFormVos = this.activityFormService.getList(activityForm);
        Map<String, String> activityFormMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, ActivityFormVo::getActivityFormName, (v1, v2) -> v2));
        Map<String, CustomerVo> customerMap = this.getCustomerMap(data);
        Map<String, String> saleOrgMap = this.getOrgMap(data);
        Map<String, SupplierVo> supplierMap = this.getSupplierMap(data);
        Map<String, CostCenterVo> costCenterMap = this.getCostCenterMap(data);
        ArrayList<WithholdingSummaryDetailDto> dtoList = new ArrayList<WithholdingSummaryDetailDto>();
        for (Map.Entry<Integer, WithholdingSummaryDetailImportVo> entry : data.entrySet()) {
            Integer k = entry.getKey();
            WithholdingSummaryDetailImportVo v = entry.getValue();
            WithholdingSummaryDetailDto dto = (WithholdingSummaryDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)v, WithholdingSummaryDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            Validate.notBlank((CharSequence)v.getBusinessExpItem(), (String)"\u7b2c[%s]\u884c\uff0c\u4e1a\u52a1\u7ec6\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{k});
            Validate.isTrue((boolean)businessExpItemMap.containsKey(v.getBusinessExpItem()), (String)"\u4e1a\u52a1\u7ec6\u7c7b[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{v.getBusinessExpItem(), "tpm_accrued_account"});
            dto.setBusinessExpItem((String)businessExpItemMap.get(v.getBusinessExpItem()));
            Validate.notBlank((CharSequence)v.getSalesOrgCode(), (String)"\u7b2c[%s]\u884c\uff0c\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{k});
            Validate.isTrue((boolean)saleOrgMap.containsKey(v.getSalesOrgCode()), (String)"\u7b2c[%s]\u884c\uff0c\u9500\u552e\u7ec4\u7ec7\u7f16\u7801[%s]\u5df2\u7981\u7528\u6216\u5220\u9664\uff01", (Object[])new Object[]{k, v.getSalesOrgCode()});
            dto.setSaleOrgName(saleOrgMap.get(v.getSalesOrgCode()));
            if (StringUtils.isNotEmpty((CharSequence)v.getActivityFormCode())) {
                Validate.isTrue((boolean)activityFormMap.containsKey(v.getActivityFormCode()), (String)"\u7b2c[%s]\u884c\uff0c\u6d3b\u52a8\u5f62\u5f0f\u5e94\u7f16\u53f7[%s]\u5bf9\u5e94\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01", (Object[])new Object[]{k, v.getActivityFormCode()});
                dto.setActivityFormName(activityFormMap.get(v.getActivityFormCode()));
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getCustomerName())) {
                Validate.notEmpty((CharSequence)v.getCustomerCode(), (String)"\u7b2c[%s]\u884c\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{k});
            }
            if (StringUtils.isNotEmpty((CharSequence)v.getCustomerCode())) {
                Validate.isTrue((boolean)customerMap.containsKey(v.getCustomerCode()), (String)"\u7b2c[%s]\u884c\uff0c\u5ba2\u6237\u7f16\u7801[%s]\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01", (Object[])new Object[]{k, v.getCustomerCode()});
                dto.setCustomerName(customerMap.get(v.getCustomerCode()).getCustomerName());
            } else {
                dto.setCustomerName("");
            }
            if (StringUtils.isNotBlank((CharSequence)v.getCustomerClassifyName())) {
                Validate.isTrue((boolean)merchantsMap.containsKey(v.getCustomerClassifyName()), (String)"\u7b2c[%s]\u884c\uff0c\u5ba2\u5546\u7c7b\u578b[%s]\u5728\u6570\u636e\u5b57\u5178[%s]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{k, v.getCustomerClassifyName(), "tpm_merchants_type"});
                dto.setCustomerClassifyCode((String)merchantsMap.get(v.getCustomerClassifyName()));
                Validate.notBlank((CharSequence)v.getSupplierCode(), (String)"\u7b2c[%s]\u884c\uff0c\u5ba2\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{k});
                Validate.isTrue((boolean)supplierMap.containsKey(v.getSupplierCode()), (String)"\u7b2c[%s]\u884c\uff0c\u4f9b\u5e94\u5546\u7f16\u7801[%s]\u5df2\u7981\u7528\u6216\u5220\u9664\uff01", (Object[])new Object[]{k, v.getSupplierCode()});
                SupplierVo supplierVo = supplierMap.get(v.getSupplierCode());
                dto.setSupplierName(supplierVo.getSupplierName());
                if (StringUtils.equals((CharSequence)"supplier", (CharSequence)dto.getCustomerClassifyCode())) {
                    dto.setSpecialTag("M");
                } else {
                    dto.setSpecialTag("");
                }
            } else {
                dto.setSupplierCode("");
                dto.setSupplierName("");
            }
            Validate.notBlank((CharSequence)v.getCostCenter(), (String)"\u7b2c[%s]\u884c\uff0c\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[]{k});
            Validate.isTrue((boolean)costCenterMap.containsKey(v.getCostCenter()), (String)"\u7b2c[%s]\u884c\uff0c\u6210\u672c\u4e2d\u5fc3\u7f16\u7801[%s]\u5df2\u7981\u7528\u6216\u5220\u9664\uff01", (Object[])new Object[]{k, v.getCostCenter()});
            CostCenterVo costCenterVo = costCenterMap.get(v.getCostCenter());
            dto.setCostCenterName(costCenterVo.getCostCenterName());
            Validate.isTrue((boolean)Objects.nonNull(v.getWithholdingAmount()), (String)"\u7b2c[%s]\u884c\uff0c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (long)k.intValue());
            Validate.isTrue((boolean)Objects.nonNull(v.getEstimateTaxAmount()), (String)"\u7b2c[%s]\u884c\uff0c\u6682\u4f30\u7a0e\u91d1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (long)k.intValue());
            dto.setEstimateTaxAmount(dto.getEstimateTaxAmount().setScale(2, RoundingMode.HALF_DOWN));
            dto.setWithholdingAmount(dto.getWithholdingAmount().setScale(2, RoundingMode.HALF_DOWN));
            dto.setWithholdingTaxAmount(dto.getWithholdingAmount().add(dto.getEstimateTaxAmount()).setScale(2, RoundingMode.HALF_DOWN));
            Validate.isTrue((boolean)Objects.nonNull(v.getAttachmentNum()), (String)"\u7b2c[%s]\u884c\uff0c\u9644\u4ef6\u5f20\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (long)k.intValue());
            if (Objects.nonNull(dto.getQuantity()) && BigDecimal.ZERO.compareTo(dto.getQuantity()) != 0) {
                dto.setPrice(dto.getWithholdingAmount().divide(dto.getQuantity(), 8, RoundingMode.HALF_DOWN));
            }
            dtoList.add(dto);
        }
        this.withholdingSummaryUtil.valUpdateExtend(dtoList, withholdingSummaryVo.getActivityTypeType(), 2);
        return dtoList;
    }

    public Map<String, CustomerVo> getCustomerMap(LinkedHashMap<Integer, WithholdingSummaryDetailImportVo> data) {
        List customerCodes = data.values().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())).map(WithholdingSummaryDetailImportVo::getCustomerCode).distinct().collect(Collectors.toList());
        Map<String, CustomerVo> customerMap = new HashMap<String, CustomerVo>();
        if (!CollectionUtils.isEmpty(customerCodes)) {
            List supplierVos = this.customerVoService.findByCustomerCodes(customerCodes);
            customerMap = supplierVos.stream().filter(e -> StringUtils.equals((CharSequence)EnableStatusEnum.ENABLE.getCode(), (CharSequence)e.getEnableStatus()) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)e.getDelFlag())).collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (v1, v2) -> v2));
        }
        return customerMap;
    }

    public Map<String, String> getOrgMap(LinkedHashMap<Integer, WithholdingSummaryDetailImportVo> data) {
        List saleOrgCodes = data.values().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())).map(WithholdingSummaryDetailImportVo::getSalesOrgCode).distinct().collect(Collectors.toList());
        Map<String, String> saleOrgMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(saleOrgCodes)) {
            List saleOrgVos = this.salesOrgVoService.findBySalesOrgCodes(saleOrgCodes);
            saleOrgMap = saleOrgVos.stream().filter(e -> StringUtils.equals((CharSequence)EnableStatusEnum.ENABLE.getCode(), (CharSequence)e.getEnableStatus()) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)e.getDelFlag())).collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getSalesOrgName, (v1, v2) -> v2));
        }
        return saleOrgMap;
    }

    public Map<String, SupplierVo> getSupplierMap(LinkedHashMap<Integer, WithholdingSummaryDetailImportVo> data) {
        List supplierCodes = data.values().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSupplierCode())).map(WithholdingSummaryDetailImportVo::getSupplierCode).distinct().collect(Collectors.toList());
        Map<String, SupplierVo> supplierMap = new HashMap<String, SupplierVo>();
        if (!CollectionUtils.isEmpty(supplierCodes)) {
            List supplierVos = this.supplierVoService.findBySupplierCodes(supplierCodes);
            supplierMap = supplierVos.stream().filter(e -> StringUtils.equals((CharSequence)EnableStatusEnum.ENABLE.getCode(), (CharSequence)e.getEnableStatus()) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)e.getDelFlag())).collect(Collectors.toMap(SupplierVo::getSupplierCode, v -> v, (v1, v2) -> v2));
        }
        return supplierMap;
    }

    public Map<String, CostCenterVo> getCostCenterMap(LinkedHashMap<Integer, WithholdingSummaryDetailImportVo> data) {
        List costCenterCodes = data.values().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCostCenter())).map(WithholdingSummaryDetailImportVo::getCostCenter).distinct().collect(Collectors.toList());
        Map<String, CostCenterVo> costCenterMap = new HashMap<String, CostCenterVo>();
        if (!CollectionUtils.isEmpty(costCenterCodes)) {
            List costCenterVos = this.costCenterVoService.findByCodes(costCenterCodes, "Y");
            costCenterMap = costCenterVos.stream().filter(e -> StringUtils.equals((CharSequence)EnableStatusEnum.ENABLE.getCode(), (CharSequence)e.getEnableStatus()) && StringUtils.equals((CharSequence)DelFlagStatusEnum.NORMAL.getCode(), (CharSequence)e.getDelFlag())).collect(Collectors.toMap(CostCenterVo::getCostCenterCode, v -> v, (v1, v2) -> v2));
        }
        return costCenterMap;
    }
}

